/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitArrayTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitListTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ForkJoin", source="")
public final class ForkJoin {
    private ForkJoin() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> ('a * 'a) option)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split(Value value, Value value2, Value value3, Value value4, Value value5) throws FailException {
        ForkJoinPool forkJoinPool = (ForkJoinPool)value.asCustom();
        ForkJoinSplitTask forkJoinSplitTask = new ForkJoinSplitTask(value2, value3, value4, value5);
        Value value6 = null;
        try {
            value6 = forkJoinPool.invoke(forkJoinSplitTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Fail.invalidArgument("Concurrent.ForkJoin.split");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            ForkJoin.raiseException(throwable2, "Concurrent.ForkJoin.split");
        }
        if (value6 != null) {
            return value6;
        }
        ForkJoin.raiseException(forkJoinSplitTask.getException(), "Concurrent.ForkJoin.split");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a list)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_list(Value value, Value value2, Value value3, Value value4, Value value5) throws FailException {
        ForkJoinPool forkJoinPool = (ForkJoinPool)value.asCustom();
        ForkJoinSplitListTask forkJoinSplitListTask = new ForkJoinSplitListTask(value2, value3, value4, value5);
        Value value6 = null;
        try {
            value6 = forkJoinPool.invoke(forkJoinSplitListTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Fail.invalidArgument("Concurrent.ForkJoin.split_list");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            ForkJoin.raiseException(throwable2, "Concurrent.ForkJoin.split_list");
        }
        if (value6 != null) {
            return value6;
        }
        ForkJoin.raiseException(forkJoinSplitListTask.getException(), "Concurrent.ForkJoin.split_list");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a array)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_array(Value value, Value value2, Value value3, Value value4, Value value5) throws FailException {
        ForkJoinPool forkJoinPool = (ForkJoinPool)value.asCustom();
        ForkJoinSplitArrayTask forkJoinSplitArrayTask = new ForkJoinSplitArrayTask(value2, value3, value4, value5);
        Value value6 = null;
        try {
            value6 = forkJoinPool.invoke(forkJoinSplitArrayTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Fail.invalidArgument("Concurrent.ForkJoin.split_array");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            ForkJoin.raiseException(throwable2, "Concurrent.ForkJoin.split_array");
        }
        if (value6 != null) {
            return value6;
        }
        ForkJoin.raiseException(forkJoinSplitArrayTask.getException(), "Concurrent.ForkJoin.split_array");
        return Value.UNIT;
    }

    private static void raiseException(Throwable throwable, String string) throws FailException {
        Throwable throwable2;
        Throwable throwable3 = throwable2 = throwable instanceof RuntimeException ? throwable.getCause() : throwable;
        if (throwable2 instanceof FailException) {
            Runtime.raiseRaised((FailException)throwable2);
        } else {
            Fail.failWith(string);
        }
    }
}

