/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/utimes.c")
public final class Utimes {
    private Utimes() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "float", "float"}, returnType="unit")
    public static Value unix_utimes(Value path, Value atime, Value mtime) throws FailException {
        File f = CurrentContext.getFilesState().getRealFile(path);
        try {
            Path p = f.toPath();
            Files.setLastModifiedTime(p, FileTime.from((long)mtime.asDouble(), TimeUnit.SECONDS));
            Files.setAttribute(p, "lastAccessTime", FileTime.from((long)atime.asDouble(), TimeUnit.SECONDS), new LinkOption[0]);
        }
        catch (IOException ioe) {
            Unix.fail("utimes", ioe);
        }
        return Value.UNIT;
    }
}

