/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.values.Value;

public final class Primitives2Marshalled
extends AbstractPrimitivesConverter {
    private final FileOutputStream out;
    private final List<Value> values;

    private Primitives2Marshalled(String b, String f) throws IOException {
        super(b, null);
        assert (f != null) : "null f";
        this.out = new FileOutputStream(f);
        this.values = new ArrayList<Value>();
    }

    @Override
    protected void beforeWalk() {
        this.values.clear();
    }

    @Override
    protected void visitClass(String className) {
        try {
            Class<?> cl = Class.forName(className);
            PrimitiveProvider prov = cl.getAnnotation(PrimitiveProvider.class);
            if (prov != null) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<Value[]> parameters = new ArrayList<Value[]>();
                ArrayList<Value> returns = new ArrayList<Value>();
                for (Method meth : cl.getDeclaredMethods()) {
                    Primitive prim = meth.getAnnotation(Primitive.class);
                    if (prim == null) continue;
                    names.add(meth.getName());
                    parameters.add(Primitives2Marshalled.convertTypeArray(meth.getParameterTypes(), prim.parameterTypes()));
                    returns.add(Primitives2Marshalled.convertType(meth.getReturnType(), prim.returnType()));
                }
                int sz = names.size();
                Value v = Value.createBlock(0, sz);
                for (int i = 0; i < sz; ++i) {
                    Value triple = Value.createBlock(0, Value.createString((String)names.get(i)), Value.createBlock(0, (Value[])parameters.get(i)), (Value)returns.get(i));
                    v.set(i, triple);
                }
                this.values.add(Value.createBlock(0, Value.createString(className), v));
            }
        }
        catch (ExceptionInInitializerError eiie) {
        }
        catch (Throwable t) {
            PrintStream err = System.err;
            err.printf("error: exception while processing class '%s'\n", className);
            t.printStackTrace(err);
            System.exit(1);
        }
    }

    @Override
    protected void afterWalk() {
    }

    private void write() throws IOException {
        int len = this.values.size();
        Value content = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            content.set(i, this.values.get(i));
        }
        try {
            ContextWithoutRuntimeLock ctxt = new ContextWithoutRuntimeLock(Parameters.defaultByteCodeParameters(), false, new File("."));
            this.out.write(MarshalExtern.externValue(ctxt, content, Value.EMPTY_LIST));
        }
        catch (FailException fe) {
            throw new IOException("error in marshalling");
        }
    }

    private static Value convertType(Class<?> t, String a) {
        assert (t != null) : "null t";
        assert (a != null) : "null a";
        if (Void.TYPE.equals(t)) {
            return Value.createLong(19L);
        }
        if (Integer.TYPE.equals(t)) {
            return Value.createLong(9L);
        }
        if (Long.TYPE.equals(t)) {
            if ("int".equals(a)) {
                return Value.ONE;
            }
            if ("int64".equals(a)) {
                return Value.createLong(10L);
            }
            if ("nativeint".equals(a)) {
                return Value.createLong(8L);
            }
            if ("char".equals(a)) {
                return Value.TWO;
            }
            if ("bool".equals(a)) {
                return Value.FIVE;
            }
            if ("unit".equals(a)) {
                return Value.SIX;
            }
            PrintStream err = System.err;
            err.printf("error: cannot convert Java type '%s' with annotation '%s'\n", t.toString(), a);
            System.exit(1);
            return null;
        }
        if (Double.TYPE.equals(t)) {
            return Value.FOUR;
        }
        if (Value.class.equals(t)) {
            return Value.ZERO;
        }
        if (boolean[].class.equals(t)) {
            return Value.createLong(11L);
        }
        if (byte[].class.equals(t)) {
            return Value.createLong(12L);
        }
        if (char[].class.equals(t)) {
            return Value.createLong(13L);
        }
        if (double[].class.equals(t)) {
            return Value.createLong(14L);
        }
        if (float[].class.equals(t)) {
            return Value.createLong(15L);
        }
        if (int[].class.equals(t)) {
            return Value.createLong(16L);
        }
        if (long[].class.equals(t)) {
            return Value.createLong(17L);
        }
        if (short[].class.equals(t)) {
            return Value.createLong(18L);
        }
        Value cn = Value.createString(t.getName());
        return Value.createBlock(4, cn);
    }

    private static Value[] convertTypeArray(Class<?>[] t, String[] a) {
        assert (t != null) : "null t";
        assert (a != null) : "null a";
        assert (t.length == a.length) : "t and a should have the same length";
        int len = t.length;
        Value[] res = new Value[len];
        for (int i = 0; i < len; ++i) {
            res[i] = Primitives2Marshalled.convertType(t[i], a[i]);
        }
        return res;
    }

    public static void main(String[] args) {
        PrintStream err = System.err;
        if (args.length == 2) {
            try {
                Primitives2Marshalled p2m = new Primitives2Marshalled(args[0], args[1]);
                p2m.walkFileTree();
                p2m.write();
            }
            catch (IOException ioe) {
                err.printf("i/o error: %s\n", ioe.getMessage());
                System.exit(1);
            }
            System.exit(0);
        } else {
            err.println("error: a path, and a file should be provided");
            System.exit(1);
        }
    }
}

