/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.print;

import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Hashtable;
import javax.swing.RepaintManager;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class PrintCmd
implements Command {
    static Hashtable images = new Hashtable();

    PrintCmd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "?-landscape|-portrait -margin marginValue? windowName");
        }
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[argv.length - 1].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[argv.length - 1].toString() + "\"");
        }
        int orientation = 1;
        double margin = 36.0;
        boolean silent = false;
        boolean sizeToFit = false;
        boolean autoSelect = false;
        boolean createPaper = false;
        for (int i = 1; i < argv.length - 1; ++i) {
            if ("-landscape".startsWith(argv[i].toString())) {
                orientation = 0;
                createPaper = true;
                continue;
            }
            if ("-portrait".startsWith(argv[i].toString())) {
                orientation = 1;
                createPaper = true;
                continue;
            }
            if ("-silent".startsWith(argv[i].toString())) {
                silent = true;
                continue;
            }
            if ("-sizetofit".startsWith(argv[i].toString())) {
                sizeToFit = true;
                createPaper = true;
                continue;
            }
            if ("-autoselect".startsWith(argv[i].toString())) {
                autoSelect = true;
                createPaper = true;
                continue;
            }
            if (!"-margin".startsWith(argv[i].toString())) continue;
            createPaper = true;
            if (++i >= argv.length - 1) {
                throw new TclException(interp, "no value for margin");
            }
            margin = TclDouble.get((Interp)interp, (TclObject)argv[i]) * 72.0;
        }
        Object obj = ReflectObject.get((Interp)interp, (TclObject)tObj);
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = pj.defaultPage();
        if (!createPaper && !silent) {
            pf = pj.pageDialog(pf);
        } else {
            Paper paper = new Paper();
            double cWidth = ((Component)obj).getWidth();
            double cHeight = ((Component)obj).getHeight();
            if (autoSelect) {
                orientation = cWidth > cHeight ? 0 : 1;
            }
            if (sizeToFit) {
                if (orientation == 0) {
                    if (cHeight > cWidth) {
                        paper.setSize(cHeight + 2.0 * margin, cHeight + 2.0 * margin);
                        paper.setImageableArea(margin, margin, cHeight + margin, cHeight + margin);
                    } else {
                        paper.setSize(cHeight + 2.0 * margin, cWidth + 2.0 * margin);
                        paper.setImageableArea(margin, margin, cHeight + margin, cWidth + margin);
                    }
                } else if (cWidth > cHeight) {
                    paper.setSize(cWidth + 2.0 * margin, cWidth + 2.0 * margin);
                    paper.setImageableArea(margin, margin, cWidth + margin, cWidth + margin);
                } else {
                    paper.setSize(cWidth + 2.0 * margin, cHeight + 2.0 * margin);
                    paper.setImageableArea(margin, margin, cWidth + margin, cHeight + margin);
                }
            } else {
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
            }
            pf.setPaper(paper);
            pf.setOrientation(orientation);
        }
        pj.setPrintable((Printable)obj, pf);
        if (silent) {
            try {
                pj.print();
            }
            catch (PrinterException e) {
                System.out.println(e);
            }
        } else if (pj.printDialog()) {
            try {
                PrintCmd.disableDoubleBuffering((Component)obj);
                pj.print();
            }
            catch (PrinterException e) {
                System.out.println(e);
            }
            finally {
                PrintCmd.enableDoubleBuffering((Component)obj);
            }
        }
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

