/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.AngleStartParameter;
import com.onemoonscientific.swank.canvas.ArcStyleParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.DashParameter;
import com.onemoonscientific.swank.canvas.DashPhaseParameter;
import com.onemoonscientific.swank.canvas.ExtentParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.OutlineParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.ShearParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.util.Map;
import java.util.TreeMap;

public class ItemArc
extends SwkShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new ExtentParameter(), new AngleStartParameter(), new ArcStyleParameter(), new DashParameter(), new DashPhaseParameter(), new FillParameter(), new OutlineParameter(), new StateParameter(), new RotateParameter(), new ShearParameter(), new TagsParameter(), new TransformerParameter(), new WidthParameter(), new NodeParameter()};
    static Map parameterMap = new TreeMap();
    String imageName = "";
    Arc2D arc2D = null;

    ItemArc(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.storeCoords = new double[4];
        this.arc2D = (Arc2D)shape;
        this.arc2D.setAngleExtent(90.0);
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 4) {
            throw new SwkException("wrong # coordinates: expected 4, got " + coords.length);
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, 4);
        this.applyCoordinates();
    }

    public String getType() {
        return "arc";
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public void applyCoordinates() {
        this.checkCoordinates(this.storeCoords);
        AffineTransform aT = new AffineTransform();
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.xShear, this.yShear);
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.rotate, (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.arc2D.setFrame(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2] - this.storeCoords[0], this.storeCoords[3] - this.storeCoords[1]);
        this.shape = aT.createTransformedShape(this.arc2D);
    }

    static {
        ItemArc.initializeParameters(parameters, parameterMap);
    }
}

