/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class DashParameter
extends CanvasParameter {
    private static String name = "dash";
    private static double[] defValue = new double[0];
    String dashString = "";
    boolean dashIntPattern = false;
    float[] dash = null;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return "";
    }

    public boolean isParameterLabel(String s) {
        return s.equals("-dash");
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        return TclString.newInstance((String)swkShape.getDashString());
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.dashString = arg.toString();
        this.dashIntPattern = SwankUtil.isDashIntPattern(interp, arg);
        this.dash = SwankUtil.getDash(interp, arg);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        swkShape.setDashString(this.dashString);
        swkShape.setDashIntPattern(this.dashIntPattern);
        swkShape.setDash(this.dash);
        swkShape.newStroke = true;
    }
}

