/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class WinfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"children", "class", "exists", "geometry", "height", "toplevel", "width", "x", "y", "parent", "depth", "fpixels", "pixels", "viewable", "screenwidth", "screenheight", "reqwidth", "reqheight", "rootx", "rooty", "vrootx", "vrooty", "visual", "ismapped", "name"};
    private static final int OPT_CHILDREN = 0;
    private static final int OPT_CLASS = 1;
    private static final int OPT_EXISTS = 2;
    private static final int OPT_GEOMETRY = 3;
    private static final int OPT_HEIGHT = 4;
    private static final int OPT_TOPLEVEL = 5;
    private static final int OPT_WIDTH = 6;
    private static final int OPT_X = 7;
    private static final int OPT_Y = 8;
    private static final int OPT_PARENT = 9;
    private static final int OPT_DEPTH = 10;
    private static final int OPT_FPIXELS = 11;
    private static final int OPT_PIXELS = 12;
    private static final int OPT_VIEWABLE = 13;
    private static final int OPT_SCREENWIDTH = 14;
    private static final int OPT_SCREENHEIGHT = 15;
    private static final int OPT_REQWIDTH = 16;
    private static final int OPT_REQHEIGHT = 17;
    private static final int OPT_ROOTX = 18;
    private static final int OPT_ROOTY = 19;
    private static final int OPT_VROOTX = 20;
    private static final int OPT_VROOTY = 21;
    private static final int OPT_VISUAL = 22;
    private static final int OPT_ISMAPPED = 23;
    private static final int OPT_NAME = 24;
    Interp interp;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int index = 0;
        this.interp = interp;
        String checkTL = null;
        SwkWidget widget = null;
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "option window ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[2].toString());
        if (opt == 2) {
            if (tObj == null) {
                interp.setResult("0");
            } else {
                interp.setResult("1");
            }
            return;
        }
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        Object object = ReflectObject.get((Interp)interp, (TclObject)tObj);
        Rectangle rectangle = null;
        switch (opt) {
            case 0: {
                String widgetName = argv[2].toString();
                WinfoCmd.getChildrenByName(interp, widgetName);
                break;
            }
            case 9: {
                String widgetName = argv[2].toString();
                if (!Widgets.exists(interp, widgetName)) {
                    throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
                }
                interp.setResult(Widgets.pathParent(interp, widgetName));
                break;
            }
            case 1: {
                widget = (SwkWidget)ReflectObject.get((Interp)interp, (TclObject)tObj);
                interp.setResult(widget.getClassName());
                break;
            }
            case 3: {
                String widgetName = argv[2].toString();
                if (!Widgets.exists(interp, widgetName)) {
                    throw new TclException(interp, "bad window path name \"" + widgetName + "\"");
                }
                rectangle = this.getGeometry(interp, object, argv);
                interp.setResult(rectangle.width + "x" + rectangle.height + "+" + rectangle.x + "+" + rectangle.y);
                break;
            }
            case 4: {
                rectangle = this.getGeometry(interp, object, argv);
                interp.setResult(rectangle.height);
                break;
            }
            case 10: {
                int pixelSize = new Depth().exec(object);
                interp.setResult(pixelSize);
                break;
            }
            case 5: {
                String widgetName = argv[2].toString().intern();
                index = widgetName.indexOf(".", 1);
                checkTL = index < 0 ? widgetName : widgetName.substring(0, index);
                TclObject tObj2 = (TclObject)Widgets.getWidget(interp, checkTL);
                if (tObj2 == null) {
                    throw new TclException(interp, "bad window path name \"" + checkTL + "\"");
                }
                Object object2 = ReflectObject.get((Interp)interp, (TclObject)tObj2);
                if (object2 == null) {
                    throw new TclException(interp, "bad window path name \"" + checkTL + "\"");
                }
                if (object2 instanceof Window) {
                    interp.setResult(checkTL);
                    break;
                }
                interp.setResult(".");
                break;
            }
            case 6: {
                rectangle = this.getGeometry(interp, object, argv);
                interp.setResult(rectangle.width);
                break;
            }
            case 7: {
                rectangle = this.getGeometry(interp, object, argv);
                interp.setResult(rectangle.x);
                break;
            }
            case 8: {
                rectangle = this.getGeometry(interp, object, argv);
                interp.setResult(rectangle.y);
                break;
            }
            case 11: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                }
                interp.setResult(SwankUtil.getTkSizeD(interp, (Component)object, argv[3]));
                break;
            }
            case 12: {
                if (argv.length != 4) {
                    throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                }
                interp.setResult(SwankUtil.getTkSize(interp, (Component)object, argv[3]));
                break;
            }
            case 13: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                interp.setResult(winfo.viewable);
                break;
            }
            case 14: {
                interp.setResult(((Component)object).getToolkit().getScreenSize().width);
                break;
            }
            case 15: {
                interp.setResult(((Component)object).getToolkit().getScreenSize().height);
                break;
            }
            case 16: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                interp.setResult(winfo.preferredSize.width);
                break;
            }
            case 17: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                interp.setResult(winfo.preferredSize.height);
                break;
            }
            case 18: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                if (!winfo.showing) {
                    throw new TclException(interp, "component is not showing");
                }
                interp.setResult(winfo.locationOnScreen.x);
                break;
            }
            case 19: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                if (!winfo.showing) {
                    throw new TclException(interp, "component is not showing");
                }
                interp.setResult(winfo.locationOnScreen.y);
                break;
            }
            case 20: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                interp.setResult(0);
                break;
            }
            case 21: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                interp.setResult(0);
                break;
            }
            case 22: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                }
                if (!Widgets.exists(interp, argv[2].toString())) {
                    throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
                }
                interp.setResult("truecolor");
                break;
            }
            case 23: {
                Winfo winfo = new Winfo();
                winfo.exec(object);
                interp.setResult(winfo.isMapped);
                break;
            }
            case 24: {
                int lastDot = argv[2].toString().lastIndexOf(46);
                if (lastDot == -1) {
                    throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
                }
                interp.setResult(argv[2].toString().substring(lastDot + 1));
                break;
            }
        }
    }

    static void getChildrenByName(Interp interp, String parentName) throws TclException {
        Vector children = Widgets.children(interp, parentName);
        TclObject list = TclList.newInstance();
        for (int i = 0; i < children.size(); ++i) {
            String childName = (String)children.elementAt(i);
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)childName));
        }
        interp.setResult(list);
    }

    static void getChildren(Interp interp, Component component, TclObject list) throws TclException {
        int i;
        Container master = null;
        if (component instanceof JFrame) {
            master = ((JFrame)component).getContentPane();
        } else if (component instanceof JWindow) {
            master = ((JWindow)component).getContentPane();
        } else if (component instanceof JInternalFrame) {
            master = ((JInternalFrame)component).getContentPane();
        } else if (component instanceof Container) {
            master = (Container)component;
        } else {
            return;
        }
        String compName = null;
        Component[] comps = master.getComponents();
        for (i = 0; i < comps.length; ++i) {
            compName = comps[i].getName();
            if (compName == null || compName.length() == 0) continue;
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)compName));
        }
        for (i = 0; i < comps.length; ++i) {
            WinfoCmd.getChildren(interp, comps[i], list);
        }
    }

    public Rectangle getGeometry(Interp interp, Object object, String widgetName) {
        Point wLocation = null;
        Point pLocation = null;
        Rectangle rectangle = null;
        try {
            Point location;
            Dimension size;
            if (object instanceof JFrame) {
                Window window = (Window)object;
                size = ((JFrame)window).getRootPane().getSize();
                wLocation = window.getLocationOnScreen();
                location = window.getLocation();
            } else if (object instanceof Window) {
                Window window = (Window)object;
                size = window.getSize();
                wLocation = window.getLocationOnScreen();
                location = window.getLocation();
            } else if (object instanceof Component) {
                Component comp = (Component)object;
                String parent = Widgets.pathParent(interp, widgetName);
                TclObject pObj = (TclObject)Widgets.getWidget(interp, parent);
                Object pObject = ReflectObject.get((Interp)interp, (TclObject)pObj);
                if (pObject instanceof Window) {
                    Window pWindow = (Window)pObject;
                    pLocation = Widgets.getContainer(pWindow).getLocationOnScreen();
                } else {
                    Component pComp = (Component)pObject;
                    pLocation = Widgets.getContainer(pComp).getLocationOnScreen();
                }
                size = comp.getSize();
                wLocation = comp.getLocationOnScreen();
                location = comp.getLocation();
            } else {
                throw new TclException(interp, "invalid object type \"" + widgetName + "\"");
            }
            if (pLocation != null && wLocation != null) {
                location = new Point(wLocation.x - pLocation.x, wLocation.y - pLocation.y);
            }
            rectangle = new Rectangle();
            rectangle.x = location.x;
            rectangle.y = location.y;
            rectangle.width = size.width;
            rectangle.height = size.height;
        }
        catch (TclException tclE) {
            interp.backgroundError();
        }
        return rectangle;
    }

    Rectangle getGeometry(Interp interp, Object object, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "window");
        }
        String widgetName = argv[2].toString().intern();
        if (!(object instanceof JFrame || object instanceof JWindow || object instanceof Component)) {
            throw new TclException(interp, "invalid object type \"" + widgetName + "\"");
        }
        Rectangle rectangle = new GeometryGet().exec(object, widgetName);
        if (rectangle == null) {
            throw new TclException(interp, "Can't get geometry for object \"" + widgetName + "\"");
        }
        return rectangle;
    }

    class Winfo
    extends GetValueOnEventThread {
        Object object = null;
        boolean viewable = false;
        boolean showing = false;
        Dimension preferredSize = null;
        Point locationOnScreen = null;
        boolean isMapped = false;

        Winfo() {
        }

        void exec(Object object) throws TclException {
            this.object = object;
            this.execOnThread();
        }

        public void run() {
            this.viewable = ((Component)this.object).isVisible();
            this.preferredSize = ((Component)this.object).getPreferredSize();
            this.showing = ((Component)this.object).isShowing();
            this.locationOnScreen = ((Component)this.object).getLocationOnScreen();
            this.isMapped = this.object instanceof Frame && (((Frame)this.object).getExtendedState() & 1) == 1 ? false : ((Component)this.object).isDisplayable();
        }
    }

    class Depth
    extends GetValueOnEventThread {
        Object object = null;
        int pixelSize;

        Depth() {
        }

        int exec(Object object) throws TclException {
            this.object = object;
            this.execOnThread();
            return this.pixelSize;
        }

        public void run() {
            this.pixelSize = ((Component)this.object).getColorModel().getPixelSize();
        }
    }

    class GeometryGet
    extends GetValueOnEventThread {
        Object object = null;
        Rectangle rectangle = null;
        String widgetName = null;

        GeometryGet() {
        }

        Rectangle exec(Object object, String widgetName) throws TclException {
            this.object = object;
            this.widgetName = widgetName;
            this.execOnThread();
            return this.rectangle;
        }

        public void run() {
            Dimension size = null;
            Point location = null;
            if (this.object instanceof JWindow) {
                JWindow window = (JWindow)this.object;
                JRootPane jRoot = window.getRootPane();
                size = jRoot.getSize();
                location = window.getLocation();
            }
            this.rectangle = WinfoCmd.this.getGeometry(WinfoCmd.this.interp, this.object, this.widgetName);
            this.rectangle.x = location.x;
            this.rectangle.y = location.y;
            this.rectangle.width = size.width;
            this.rectangle.height = size.height;
            if (this.rectangle.x < 0) {
                this.rectangle.x = 0;
            }
            if (this.rectangle.y < 0) {
                this.rectangle.y = 0;
            }
            if (this.rectangle.width < 0) {
                this.rectangle.width = 0;
            }
            if (this.rectangle.height < 0) {
                this.rectangle.height = 0;
            }
        }
    }
}

