/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkJFrame;
import com.onemoonscientific.swank.SwkListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkWindowListener
extends WindowAdapter
implements SwkListener {
    Interp interp;
    String command = "puts component";
    ArrayList<SwkBinding> bindings;
    Window component;
    boolean shown = false;

    SwkWindowListener(Interp interp, Window component) {
        this.interp = interp;
        this.component = component;
        this.bindings = new ArrayList();
    }

    public ArrayList<SwkBinding> getBindings() {
        return this.bindings;
    }

    public void setCommand(String name) {
        this.command = name;
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBinding binding = null;
        if (!newBinding.add) {
            for (int i = 0; i < this.bindings.size(); ++i) {
                binding = this.bindings.get(i);
                if (!binding.equals(newBinding)) continue;
                this.bindings.set(i, newBinding);
                return;
            }
        }
        this.bindings.add(newBinding);
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.processWindow(e, 18);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.processWindow(e, 19);
    }

    public void processWindow(WindowEvent e, int subtype) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, subtype);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    @Override
    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        WindowEvent e = (WindowEvent)eventObject;
        ArrayList<SwkBinding> bindings = null;
        Vector tagList = ((SwkWidget)((Object)this.component)).getTagList();
        for (int j = 0; j < tagList.size(); ++j) {
            bindings = null;
            String tag = (String)tagList.elementAt(j);
            if (tag.equals(((SwkWidget)((Object)this.component)).getName())) {
                bindings = this.bindings;
            } else if (tag.startsWith(".")) {
                try {
                    bindings = ((SwkJFrame)Widgets.get(this.interp, tag)).getWindowListener().getBindings();
                }
                catch (TclException tclE) {}
            } else {
                bindings = BindCmd.getActivationBindings(tag);
            }
            if (bindings == null) continue;
            for (int i = 0; i < bindings.size(); ++i) {
                SwkBinding binding = bindings.get(i);
                if (binding.subtype != subtype || binding.command == null || binding.command.length() == 0) continue;
                try {
                    BindCmd.doCmd(this.interp, binding, (Component)this.component, e);
                    continue;
                }
                catch (TclException tclE) {
                    if (tclE.getCompletionCode() == 3) {
                        return;
                    }
                    this.interp.addErrorInfo("\n    (\"binding\" script)");
                    this.interp.backgroundError();
                }
            }
        }
    }
}

