/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkListener;
import com.onemoonscientific.swank.SwkWidget;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkMouseMotionListener
implements MouseMotionListener,
SwkListener {
    Interp interp;
    String command = "puts mouse";
    ArrayList<SwkBinding> bindings;
    Component component;
    boolean processing = false;

    SwkMouseMotionListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = component;
        this.bindings = new ArrayList();
    }

    public void setCommand(String name) {
        this.command = name.intern();
    }

    public ArrayList<SwkBinding> getBindings() {
        return this.bindings;
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBind.setBinding(this.bindings, newBinding);
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.processing) {
            e.consume();
        } else {
            BindEvent bEvent = new BindEvent(this.interp, this, e, 0);
            this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.processing) {
            e.consume();
        } else {
            BindEvent bEvent = new BindEvent(this.interp, this, e, 0);
            this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        try {
            MouseEvent e = (MouseEvent)eventObject;
            if (e.isConsumed()) {
                return;
            }
            int mods = e.getModifiersEx();
            int buttons = e.getButton();
            ArrayList<SwkBinding> bindings = null;
            Vector tagList = ((SwkWidget)((Object)this.component)).getTagList();
            for (int j = 0; j < tagList.size(); ++j) {
                String tag = (String)tagList.elementAt(j);
                bindings = tag.startsWith(".") ? this.bindings : BindCmd.getMouseMotionBindings(tag);
                if (bindings == null) continue;
                for (int i = 0; i < bindings.size(); ++i) {
                    SwkBinding binding = bindings.get(i);
                    if (binding.subtype != 9 || !SwkMouseMotionListener.checkButtonState(e, binding.mod, mods) || !SwkMouseMotionListener.checkMods(binding.mod, mods) || binding.command == null || binding.command.length() == 0) continue;
                    try {
                        this.processing = true;
                        BindCmd.doCmd(this.interp, binding.command, e);
                        continue;
                    }
                    catch (TclException tclE) {
                        if (tclE.getCompletionCode() == 3) {
                            e.consume();
                            this.processing = false;
                            return;
                        }
                        this.interp.addErrorInfo("\n    (\"binding\" script)");
                        this.interp.backgroundError();
                        continue;
                    }
                }
            }
        }
        finally {
            this.processing = false;
        }
    }

    public static boolean checkMods(int bmod, int emod) {
        int buttonsOn = 7168;
        return (bmod |= buttonsOn) == ((emod |= buttonsOn) & bmod);
    }

    public static boolean checkButtonState(InputEvent e, int bmod, int emod) {
        boolean result = true;
        int buttonsOn = 7168;
        bmod &= buttonsOn;
        if ((emod &= buttonsOn) != 0 && e.getID() == 503) {
            emod = 0;
        }
        return bmod == emod;
    }

    public static boolean checkButtons(int detail, int button) {
        boolean result = true;
        result = detail == 16 && button != 1 ? false : (detail == 8 && button != 2 ? false : detail != 4 || button == 3);
        return result;
    }
}

