/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkJSplitPane;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import javax.swing.JComponent;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJSplitPaneWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "add", "forget", "panes"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ADD = 2;
    private static final int OPT_FORGET = 3;
    private static final int OPT_PANES = 4;
    static boolean gotDefaults = false;

    SwkJSplitPaneWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJSplitPane swkjsplitpane = (SwkJSplitPane)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjsplitpane.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjsplitpane.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjsplitpane.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjsplitpane.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJSplitPane.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjsplitpane.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.add(interp, swkjsplitpane, argv);
                break;
            }
            case 3: {
                this.forget(interp, swkjsplitpane, argv);
                break;
            }
            case 4: {
                this.panes(interp, swkjsplitpane, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void add(Interp interp, SwkJSplitPane swkjsplitpane, TclObject[] argv) throws TclException {
        if (argv.length < 3 || argv.length > 5) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        int iComp = 0;
        int mode = 4;
        int relativeMode = 4;
        JComponent[] jcomps = new JComponent[]{null, null};
        JComponent relativeComp = null;
        for (int i = 2; i < argv.length; ++i) {
            TclObject winObj;
            if (i == 2) {
                if (argv[i].toString().equals("left")) {
                    mode = 0;
                } else if (argv[i].toString().equals("top")) {
                    mode = 1;
                } else if (argv[i].toString().equals("bottom")) {
                    mode = 2;
                } else if (argv[i].toString().equals("right")) {
                    mode = 3;
                }
            }
            if (i <= 2 && mode != 4) continue;
            if (argv[i].toString().startsWith("-")) {
                if (argv[i].toString().equals("-after")) {
                    relativeMode = 5;
                } else if (argv[i].toString().equals("-before")) {
                    relativeMode = 6;
                } else {
                    throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
                }
                if (i >= argv.length) {
                    throw new TclException(interp, "missing value for \"" + argv[i].toString() + "\"");
                }
                winObj = (TclObject)Widgets.getWidget(interp, argv[i + 1].toString());
                if (winObj == null) {
                    throw new TclException(interp, "bad window path name \"" + argv[i + 1].toString() + "\"");
                }
                relativeComp = (JComponent)ReflectObject.get((Interp)interp, (TclObject)winObj);
                ++i;
                continue;
            }
            if (relativeMode != 4) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            winObj = (TclObject)Widgets.getWidget(interp, argv[i].toString());
            if (winObj == null) {
                throw new TclException(interp, "bad window path name \"" + argv[i + 2].toString() + "\"");
            }
            jcomps[iComp] = (JComponent)ReflectObject.get((Interp)interp, (TclObject)winObj);
            ++iComp;
        }
        new Add().exec(swkjsplitpane, jcomps, mode, relativeComp, relativeMode);
    }

    void forget(Interp interp, SwkJSplitPane swkjsplitpane, TclObject[] argv) throws TclException {
        if (argv.length < 3 || argv.length > 4) {
            throw new TclNumArgsException(interp, 2, argv, "win ?win?");
        }
        JComponent[] jcomps = new JComponent[]{null, null};
        for (int i = 0; i < 2 && i < argv.length - 2; ++i) {
            TclObject winObj = (TclObject)Widgets.getWidget(interp, argv[i + 2].toString());
            if (winObj == null) {
                throw new TclException(interp, "bad window path name \"" + argv[i + 2].toString() + "\"");
            }
            jcomps[i] = (JComponent)ReflectObject.get((Interp)interp, (TclObject)winObj);
        }
        new Forget().exec(swkjsplitpane, jcomps);
    }

    void panes(Interp interp, SwkJSplitPane swkjsplitpane, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        TclObject list = TclList.newInstance();
        String[] names = new Panes().exec(swkjsplitpane);
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)names[i]));
        }
        interp.setResult(list);
    }

    class Panes
    extends GetValueOnEventThread {
        SwkJSplitPane swkjsplitpane = null;
        JComponent[] jcomps = null;
        String[] names = new String[]{null, null};

        Panes() {
        }

        String[] exec(SwkJSplitPane swkjsplitpane) {
            this.swkjsplitpane = swkjsplitpane;
            this.execOnThread();
            return this.names;
        }

        public void run() {
            Component comp = this.swkjsplitpane.getTopComponent();
            int iComp = 0;
            if (comp != null) {
                this.names[0] = comp.getName();
                ++iComp;
            }
            if ((comp = this.swkjsplitpane.getBottomComponent()) != null) {
                this.names[iComp] = comp.getName();
            }
        }
    }

    class Forget
    extends UpdateOnEventThread {
        SwkJSplitPane swkjsplitpane = null;
        JComponent[] jcomps = null;

        Forget() {
        }

        void exec(SwkJSplitPane swkjsplitpane, JComponent[] jcomps) {
            this.jcomps = jcomps;
            this.swkjsplitpane = swkjsplitpane;
            this.execOnThread();
        }

        public void run() {
            for (int i = 0; i < this.jcomps.length; ++i) {
                if (this.jcomps[i] == null) continue;
                this.swkjsplitpane.remove(this.jcomps[i]);
            }
        }
    }

    class Add
    extends UpdateOnEventThread {
        static final int LEFT = 0;
        static final int TOP = 1;
        static final int BOTTOM = 2;
        static final int RIGHT = 3;
        static final int NONE = 4;
        static final int AFTER = 5;
        static final int BEFORE = 6;
        SwkJSplitPane swkjsplitpane = null;
        JComponent[] jcomps = null;
        JComponent relComp = null;
        int mode = 4;
        int relMode = 4;

        Add() {
        }

        void exec(SwkJSplitPane swkjsplitpane, JComponent[] jcomps, int mode, JComponent relComp, int relMode) {
            this.swkjsplitpane = swkjsplitpane;
            this.mode = mode;
            this.jcomps = jcomps;
            this.relMode = relMode;
            this.relComp = relComp;
            this.execOnThread();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int nComps = 1;
            if (this.jcomps[0] == null) {
                return;
            }
            if (this.jcomps[1] != null) {
                nComps = 2;
            }
            int relCompPosition = -1;
            System.out.println("ncomps " + nComps);
            if (this.relMode != 4 && this.relComp != null) {
                if (this.relComp == this.swkjsplitpane.getLeftComponent()) {
                    relCompPosition = 0;
                } else {
                    if (this.relComp != this.swkjsplitpane.getRightComponent()) return;
                    relCompPosition = 1;
                }
            } else if (nComps == 1) {
                this.relComp = (JComponent)this.swkjsplitpane.getLeftComponent();
                if (this.relComp != null) {
                    relCompPosition = 1;
                    this.relMode = 5;
                }
            }
            if (nComps == 2 && relCompPosition != -1) {
                return;
            }
            boolean newPosition = false;
            if (relCompPosition != -1) {
                if (this.relMode == 5) {
                    this.jcomps[1] = this.jcomps[0];
                    this.jcomps[0] = this.relComp;
                } else {
                    this.jcomps[1] = this.relComp;
                }
            }
            switch (this.mode) {
                case 3: {
                    this.jcomps[1] = this.jcomps[0];
                    this.jcomps[0] = null;
                }
                case 0: {
                    this.swkjsplitpane.setOrientation(1);
                    break;
                }
                case 2: {
                    this.jcomps[1] = this.jcomps[0];
                    this.jcomps[0] = null;
                }
                case 1: {
                    this.swkjsplitpane.setOrientation(0);
                }
            }
            int iComp = 0;
            for (int i = 0; i < this.jcomps.length; ++i) {
                if (this.jcomps[i] == null) continue;
                if (iComp == 0) {
                    this.swkjsplitpane.setLeftComponent(this.jcomps[i]);
                } else {
                    this.swkjsplitpane.setRightComponent(this.jcomps[i]);
                }
                ++iComp;
            }
        }
    }
}

