/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkJSliderWidgetCmd;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkSliderChangeListener;
import com.onemoonscientific.swank.SwkVariable;
import com.onemoonscientific.swank.SwkWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkJSlider
extends JPanel
implements SwkWidget,
Printable,
SwkVariable {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    String jhelptarget = "";
    Color activeBackground;
    int borderWidth = 0;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    String relief = null;
    int repeatDelay;
    int repeatInterval;
    String takeFocus = null;
    DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
    double bigIncrement = 0.0;
    MySlider jslider = null;
    MyPanel jPanel = null;
    JLabel jLabel = null;
    int currentOrientation = 2;
    double from = 0.0;
    String orient = null;
    double to = 100.0;
    String label = "";
    Color troughColor = Color.white;
    String state = "normal";
    String sliderRelief = "sunken";
    double resolution = 1.0;
    int digits = 0;
    SwkSliderChangeListener sliderChangeListener = null;
    boolean showValue = true;
    int length = 100;
    int swkwidth = 15;
    double tickInterval = 0.0;
    boolean componentsValid = false;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-activebackground", "-autoscrolls", "-background", "-bd", "-bg", "-bigincrement", "-border", "-borderwidth", "-class", "-command", "-cursor", "-digits", "-enabled", "-extent", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-from", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-inverted", "-jhelptarget", "-label", "-length", "-majortickspacing", "-maximum", "-minimum", "-minortickspacing", "-opaque", "-orient", "-orientation", "-paintlabels", "-paintticks", "-painttrack", "-relief", "-repeatdelay", "-repeatinterval", "-requestfocusenabled", "-resolution", "-showvalue", "-sliderlength", "-sliderrelief", "-snaptoticks", "-state", "-takefocus", "-tickinterval", "-to", "-tooltiptext", "-troughcolor", "-value", "-valueisadjusting", "-variable", "-verifyinputwhenfocustarget", "-visible", "-width"};
    private static final int OPT_ACTIVEBACKGROUND = 0;
    private static final int OPT_AUTOSCROLLS = 1;
    private static final int OPT_BACKGROUND = 2;
    private static final int OPT_BD = 3;
    private static final int OPT_BG = 4;
    private static final int OPT_BIGINCREMENT = 5;
    private static final int OPT_BORDER = 6;
    private static final int OPT_BORDERWIDTH = 7;
    private static final int OPT_CLASS = 8;
    private static final int OPT_COMMAND = 9;
    private static final int OPT_CURSOR = 10;
    private static final int OPT_DIGITS = 11;
    private static final int OPT_ENABLED = 12;
    private static final int OPT_EXTENT = 13;
    private static final int OPT_FG = 14;
    private static final int OPT_FOCUSABLE = 15;
    private static final int OPT_FOCUSCYCLEROOT = 16;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 17;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 18;
    private static final int OPT_FONT = 19;
    private static final int OPT_FOREGROUND = 20;
    private static final int OPT_FROM = 21;
    private static final int OPT_HIGHLIGHTBACKGROUND = 22;
    private static final int OPT_HIGHLIGHTCOLOR = 23;
    private static final int OPT_HIGHLIGHTTHICKNESS = 24;
    private static final int OPT_INVERTED = 25;
    private static final int OPT_JHELPTARGET = 26;
    private static final int OPT_LABEL = 27;
    private static final int OPT_LENGTH = 28;
    private static final int OPT_MAJORTICKSPACING = 29;
    private static final int OPT_MAXIMUM = 30;
    private static final int OPT_MINIMUM = 31;
    private static final int OPT_MINORTICKSPACING = 32;
    private static final int OPT_OPAQUE = 33;
    private static final int OPT_ORIENT = 34;
    private static final int OPT_ORIENTATION = 35;
    private static final int OPT_PAINTLABELS = 36;
    private static final int OPT_PAINTTICKS = 37;
    private static final int OPT_PAINTTRACK = 38;
    private static final int OPT_RELIEF = 39;
    private static final int OPT_REPEATDELAY = 40;
    private static final int OPT_REPEATINTERVAL = 41;
    private static final int OPT_REQUESTFOCUSENABLED = 42;
    private static final int OPT_RESOLUTION = 43;
    private static final int OPT_SHOWVALUE = 44;
    private static final int OPT_SLIDERLENGTH = 45;
    private static final int OPT_SLIDERRELIEF = 46;
    private static final int OPT_SNAPTOTICKS = 47;
    private static final int OPT_STATE = 48;
    private static final int OPT_TAKEFOCUS = 49;
    private static final int OPT_TICKINTERVAL = 50;
    private static final int OPT_TO = 51;
    private static final int OPT_TOOLTIPTEXT = 52;
    private static final int OPT_TROUGHCOLOR = 53;
    private static final int OPT_VALUE = 54;
    private static final int OPT_VALUEISADJUSTING = 55;
    private static final int OPT_VARIABLE = 56;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 57;
    private static final int OPT_VISIBLE = 58;
    private static final int OPT_WIDTH = 59;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkJSlider(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkJSlider.initResources();
        }
        this.jslider = new MySlider();
        this.jPanel = new MyPanel();
        this.jLabel = new JLabel(this.label);
        this.setLayout(new GridBagLayout());
        this.sliderChangeListener = new SwkSliderChangeListener(interp, this);
        this.jslider.addChangeListener(this.sliderChangeListener);
        this.setOpaque(true);
        this.jslider.setOpaque(true);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkJSlider.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkJSlider.this.mouseX = mEvent.getX();
                SwkJSlider.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkJSlider.this.mouseX = mEvent.getX();
                SwkJSlider.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkJSliderWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setActiveBackground(Color activeBackground) {
        this.activeBackground = activeBackground;
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setRepeatDelay(int repeatDelay) {
        this.repeatDelay = repeatDelay;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setRepeatInterval(int repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setTakeFocus(String takeFocus) {
        this.takeFocus = takeFocus.intern();
    }

    public String getTakeFocus() {
        return this.takeFocus;
    }

    public void setBigIncrement(double value) {
        this.bigIncrement = value;
    }

    public double getBigIncrement() {
        return this.bigIncrement;
    }

    public JSlider getSlider() {
        return this.jslider;
    }

    public void setDValue(double value) {
        boolean iValue = false;
        Dimension size = this.getSize();
        double to = this.getTo();
        double from = this.getFrom();
        double f = (value - from) / (to - from);
        this.jslider.setValue((int)Math.round(f * (double)(this.jslider.getMaximum() - this.jslider.getMinimum()) + (double)this.jslider.getMinimum()));
    }

    public double getDValue() {
        return this.convertValue(this.jslider.getValue());
    }

    double convertValue(double iValue) {
        double dValue = 0.0;
        double to = this.getTo();
        double from = this.getFrom();
        double f = (iValue - (double)this.jslider.getMinimum()) / (double)(this.jslider.getMaximum() - this.jslider.getMinimum());
        dValue = f * (to - from) + from;
        double cRes = 1.0;
        if (this.resolution > 0.0) {
            cRes = this.resolution;
        } else {
            cRes = Math.abs(to - from) / (double)this.getLength();
            cRes = Math.pow(10.0, Math.floor(Math.log(cRes) / Math.log(10.0)));
        }
        dValue = (double)Math.round(dValue / cRes) * cRes;
        return dValue;
    }

    public void updateRange() {
        if (this.to <= this.from) {
            return;
        }
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(new Integer(0), new JLabel("0"));
        this.jslider.setLabelTable(labels);
        double dValue = this.getDValue();
        this.jslider.setMinimum(0);
        if (this.resolution > 0.0) {
            this.to = (double)Math.round(this.to / this.resolution) * this.resolution;
            this.from = (double)Math.round(this.from / this.resolution) * this.resolution;
            this.jslider.setMaximum((int)Math.round(Math.abs(this.to - this.from) / this.resolution));
        } else {
            this.jslider.setMaximum(1000);
        }
        this.setDValue(dValue);
        this.tickInterval = this.from < this.to ? Math.abs(this.tickInterval) : -Math.abs(this.tickInterval);
        if (this.tickInterval == 0.0) {
            this.jslider.setPaintLabels(false);
            this.jslider.setMajorTickSpacing(this.jslider.getMaximum() / 10);
            this.jslider.setMinorTickSpacing(this.jslider.getMajorTickSpacing() / 2);
        } else {
            this.jslider.setMajorTickSpacing((int)Math.round((double)this.jslider.getMaximum() * Math.abs(this.tickInterval / (this.to - this.from))));
            this.jslider.setMinorTickSpacing(this.jslider.getMajorTickSpacing() / 2);
            labels = new Hashtable();
            int incr = this.jslider.getMajorTickSpacing();
            for (int i = this.jslider.getMinimum(); i <= this.jslider.getMaximum(); i += incr) {
                String labelValue = this.nf.format(this.convertValue(i));
                labels.put(new Integer(i), new JLabel(labelValue));
            }
            this.jslider.setLabelTable(labels);
        }
    }

    public void setTo(double value) {
        this.to = value;
        this.updateRange();
    }

    public double getTo() {
        return this.to;
    }

    public void setFrom(double value) {
        this.from = value;
        this.updateRange();
    }

    public double getFrom() {
        return this.from;
    }

    public void setOrient(int orient) {
        if (orient == 1) {
            this.jslider.setOrientation(1);
            this.jslider.setInverted(true);
        } else {
            this.jslider.setOrientation(0);
            this.jslider.setInverted(false);
        }
        this.componentsValid = false;
    }

    public String getOrient() {
        if (this.jslider.getOrientation() == 1) {
            return "vertical";
        }
        return "horizontal";
    }

    public void setLabel(String value) {
        if (value == null) {
            value = "";
        }
        this.label = value;
        this.jLabel.setText(this.label);
        this.componentsValid = false;
        this.revalidate();
    }

    public String getLabel() {
        return this.label;
    }

    public void setTroughColor(Color value) {
        this.troughColor = value;
    }

    public Color getTroughColor() {
        return this.troughColor;
    }

    public void setState(String value) {
        if ("normal".startsWith(value)) {
            this.state = "normal";
            this.setEnabled(true);
        } else if ("active".startsWith(value)) {
            this.state = "active";
            this.setEnabled(true);
        } else if ("disabled".startsWith(value)) {
            this.state = "disabled";
            this.setEnabled(false);
        }
    }

    public String getState() {
        if (this.isEnabled()) {
            if (!this.state.equals("active") && !this.state.equals("normal")) {
                this.state = "normal";
            }
        } else {
            this.state = "disabled";
        }
        return this.state;
    }

    public void setSliderRelief(String value) {
        this.sliderRelief = value;
    }

    public String getSliderRelief() {
        return this.sliderRelief;
    }

    public void setResolution(double value) {
        this.resolution = value;
        this.updateRange();
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setDigits(int value) {
        this.digits = value;
        this.nf.setMaximumFractionDigits(this.digits);
        this.nf.setMinimumFractionDigits(this.digits);
    }

    public int getDigits() {
        return this.digits;
    }

    void updateComponents() {
        GridBagConstraints gbConstr = new GridBagConstraints();
        this.removeAll();
        if (this.jslider.getOrientation() == 1) {
            gbConstr.gridx = -1;
            gbConstr.gridy = 0;
            gbConstr.weighty = 0.0;
            gbConstr.anchor = 11;
            gbConstr.fill = 3;
            if (this.showValue) {
                this.add((Component)this.jPanel, gbConstr);
            }
            gbConstr.weighty = 1.0;
            this.add((Component)this.jslider, gbConstr);
            gbConstr.weighty = 0.0;
            if (!this.label.equals("")) {
                gbConstr.fill = 0;
                this.add((Component)this.jLabel, gbConstr);
            }
        } else {
            gbConstr.gridx = 0;
            gbConstr.weightx = 0.0;
            gbConstr.gridy = -1;
            gbConstr.anchor = 17;
            if (!this.label.equals("")) {
                gbConstr.fill = 0;
                this.add((Component)this.jLabel, gbConstr);
            }
            gbConstr.fill = 2;
            gbConstr.weightx = 1.0;
            this.add((Component)this.jslider, gbConstr);
            if (this.showValue) {
                gbConstr.weightx = 0.0;
                this.add((Component)this.jPanel, gbConstr);
            }
        }
        this.componentsValid = true;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.jslider.getOrientation() != this.currentOrientation) {
            this.currentOrientation = this.jslider.getOrientation();
        }
        if (!this.componentsValid) {
            this.updateComponents();
        }
        Dimension dSize = this.jslider.getMinimumSize();
        if (this.jslider.getOrientation() == 1) {
            if (this.showValue) {
                Dimension dSizeP = this.jPanel.getMinimumSize();
                dSize.width += dSizeP.width;
            }
            if (!this.label.equals("")) {
                Dimension dSizeL = this.jLabel.getMinimumSize();
                dSize.width += dSizeL.width;
            }
        } else {
            if (this.showValue) {
                Dimension dSizeP = this.jPanel.getMinimumSize();
                dSize.height += dSizeP.height;
            }
            if (!this.label.equals("")) {
                Dimension dSizeL = this.jLabel.getMinimumSize();
                dSize.height += dSizeL.height;
            }
        }
        return dSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setCommand(String name) {
        this.sliderChangeListener.setCommand(name);
    }

    public String getCommand() {
        return this.sliderChangeListener.getCommand();
    }

    public void setTickInterval(double tickInterval) {
        this.tickInterval = this.resolution > 0.0 ? this.resolution * (double)((int)Math.round(tickInterval / this.resolution)) : (double)Math.round(tickInterval);
        this.updateRange();
    }

    public double getTickInterval() {
        return this.tickInterval;
    }

    public String getVarName() {
        return this.sliderChangeListener.getVarName();
    }

    public void setShowValue(boolean showValue) {
        this.showValue = showValue;
        this.componentsValid = false;
        this.revalidate();
    }

    public String getShowValue() {
        if (this.showValue) {
            return "1";
        }
        return "0";
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
    }

    public int getSwkWidth() {
        return this.swkwidth;
    }

    @Override
    public void setVarName(Interp interp, String name) throws TclException {
        this.sliderChangeListener.setVarName(interp, name);
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() {
        if (this.getVarName() != null && this.getVarName().length() != 0) {
            this.interp.untraceVar(this.getVarName(), (VarTrace)this.sliderChangeListener, 33);
        }
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setActiveBackground((Color)setter.oValue);
                break;
            }
            case 1: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 2: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 3: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 4: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 5: {
                this.setBigIncrement(setter.dValue);
                break;
            }
            case 6: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 7: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 8: {
                this.setClassName(setter.sValue);
                break;
            }
            case 9: {
                this.setCommand(setter.sValue);
                break;
            }
            case 10: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 11: {
                this.setDigits(setter.iValue);
                break;
            }
            case 12: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 13: {
                this.jslider.setExtent(setter.iValue);
                break;
            }
            case 14: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 15: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 16: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 17: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 18: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 19: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 20: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 21: {
                this.setFrom(setter.dValue);
                break;
            }
            case 22: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 23: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 24: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 25: {
                this.jslider.setInverted(setter.bValue);
                break;
            }
            case 26: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 27: {
                this.setLabel(setter.sValue);
                break;
            }
            case 28: {
                this.setLength(setter.iValue);
                break;
            }
            case 29: {
                this.jslider.setMajorTickSpacing(setter.iValue);
                break;
            }
            case 30: {
                this.jslider.setMaximum(setter.iValue);
                break;
            }
            case 31: {
                this.jslider.setMinimum(setter.iValue);
                break;
            }
            case 32: {
                this.jslider.setMinorTickSpacing(setter.iValue);
                break;
            }
            case 33: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 34: {
                this.setOrient(setter.iValue);
                break;
            }
            case 35: {
                this.jslider.setOrientation(setter.iValue);
                break;
            }
            case 36: {
                this.jslider.setPaintLabels(setter.bValue);
                break;
            }
            case 37: {
                this.jslider.setPaintTicks(setter.bValue);
                break;
            }
            case 38: {
                this.jslider.setPaintTrack(setter.bValue);
                break;
            }
            case 39: {
                this.setRelief(setter.sValue);
                break;
            }
            case 40: {
                this.setRepeatDelay(setter.iValue);
                break;
            }
            case 41: {
                this.setRepeatInterval(setter.iValue);
                break;
            }
            case 42: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 43: {
                this.setResolution(setter.dValue);
                break;
            }
            case 44: {
                this.setShowValue(setter.bValue);
                break;
            }
            case 45: {
                this.setLength(setter.iValue);
                break;
            }
            case 46: {
                this.setSliderRelief(setter.sValue);
                break;
            }
            case 47: {
                this.jslider.setSnapToTicks(setter.bValue);
                break;
            }
            case 48: {
                this.setState(setter.sValue);
                break;
            }
            case 49: {
                this.setTakeFocus(setter.sValue);
                break;
            }
            case 50: {
                this.setTickInterval(setter.dValue);
                break;
            }
            case 51: {
                this.setTo(setter.dValue);
                break;
            }
            case 52: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 53: {
                this.setTroughColor((Color)setter.oValue);
                break;
            }
            case 54: {
                this.setDValue(setter.dValue);
                break;
            }
            case 55: {
                this.jslider.setValueIsAdjusting(setter.bValue);
                break;
            }
            case 56: {
                this.setCommand(setter.sValue);
                break;
            }
            case 57: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 58: {
                this.setVisible(setter.bValue);
                break;
            }
            case 59: {
                this.setSwkWidth(setter.iValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block62: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 1: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 2: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 3: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 4: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 5: {
                    double value = TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 6: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 7: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 8: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 9: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt, false).exec(value);
                    continue block62;
                }
                case 10: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 11: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 12: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 13: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 14: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 15: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 16: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 17: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 18: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 19: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 20: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 21: {
                    double value = TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 22: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 23: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 24: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 25: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 26: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 27: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 28: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 29: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 30: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 31: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 32: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 33: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 34: {
                    int value = SwankUtil.getOrient(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 35: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 36: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 37: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 38: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 39: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 40: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 41: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 42: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 43: {
                    double value = TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 44: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 45: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 46: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 47: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 48: {
                    String value = SwankUtil.getState(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 49: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 50: {
                    double value = TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 51: {
                    double value = TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 52: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 53: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 54: {
                    double value = TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 55: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 56: {
                    this.setVarName(interp, argv[i + 1].toString());
                    continue block62;
                }
                case 57: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 58: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
                case 59: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block62;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return SwankUtil.parseColor(this.getActiveBackground());
            }
            case 1: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 2: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 3: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 4: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 5: {
                return Double.toString(this.getBigIncrement());
            }
            case 6: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 7: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 8: {
                return this.getClassName();
            }
            case 9: {
                return this.getCommand();
            }
            case 10: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 11: {
                return Integer.toString(this.getDigits());
            }
            case 12: {
                return this.isEnabled() ? "1" : "0";
            }
            case 13: {
                return Integer.toString(this.jslider.getExtent());
            }
            case 14: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 15: {
                return this.isFocusable() ? "1" : "0";
            }
            case 16: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 17: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 18: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 19: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 20: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 21: {
                return Double.toString(this.getFrom());
            }
            case 22: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 23: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 24: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 25: {
                return String.valueOf(this.jslider.getInverted());
            }
            case 26: {
                return this.getJHelpTarget();
            }
            case 27: {
                return this.getLabel();
            }
            case 28: {
                return SwankUtil.parseTkSize(this.getLength());
            }
            case 29: {
                return Integer.toString(this.jslider.getMajorTickSpacing());
            }
            case 30: {
                return Integer.toString(this.jslider.getMaximum());
            }
            case 31: {
                return Integer.toString(this.jslider.getMinimum());
            }
            case 32: {
                return Integer.toString(this.jslider.getMinorTickSpacing());
            }
            case 33: {
                return this.isOpaque() ? "1" : "0";
            }
            case 35: {
                return Integer.toString(this.jslider.getOrientation());
            }
            case 36: {
                return String.valueOf(this.jslider.getPaintLabels());
            }
            case 37: {
                return String.valueOf(this.jslider.getPaintTicks());
            }
            case 38: {
                return String.valueOf(this.jslider.getPaintTrack());
            }
            case 39: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 40: {
                return Integer.toString(this.getRepeatDelay());
            }
            case 41: {
                return Integer.toString(this.getRepeatInterval());
            }
            case 42: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 43: {
                return Double.toString(this.getResolution());
            }
            case 44: {
                return String.valueOf(this.getShowValue());
            }
            case 45: {
                return SwankUtil.parseTkSize(this.getLength());
            }
            case 46: {
                return SwankUtil.parseTkRelief(this.getSliderRelief());
            }
            case 47: {
                return String.valueOf(this.jslider.getSnapToTicks());
            }
            case 48: {
                return this.getState();
            }
            case 49: {
                return this.getTakeFocus();
            }
            case 50: {
                return Double.toString(this.getTickInterval());
            }
            case 51: {
                return Double.toString(this.getTo());
            }
            case 52: {
                return this.getToolTipText();
            }
            case 53: {
                return SwankUtil.parseColor(this.getTroughColor());
            }
            case 54: {
                return Double.toString(this.getDValue());
            }
            case 55: {
                return String.valueOf(this.jslider.getValueIsAdjusting());
            }
            case 56: {
                return this.getVarName();
            }
            case 57: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 58: {
                return this.isVisible() ? "1" : "0";
            }
            case 59: {
                return SwankUtil.parseTkSize(this.getSwkWidth());
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("activeBackground", "ActiveBackground", 0);
        resourceDB.put("-activebackground", resourceObject);
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 1);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 2);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 3);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 4);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("bigIncrement", "BigIncrement", 5);
        resourceDB.put("-bigincrement", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 6);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 7);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 8);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("command", "Command", 9);
        resourceDB.put("-command", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 10);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("digits", "Digits", 11);
        resourceDB.put("-digits", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 12);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("extent", "Extent", 13);
        resourceDB.put("-extent", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 14);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 15);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 16);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 17);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 18);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 19);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 20);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("from", "From", 21);
        resourceDB.put("-from", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 22);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 23);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 24);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("inverted", "Inverted", 25);
        resourceDB.put("-inverted", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 26);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("label", "Label", 27);
        resourceDB.put("-label", resourceObject);
        resourceObject = new ResourceObject("length", "Length", 28);
        resourceDB.put("-length", resourceObject);
        resourceObject = new ResourceObject("majorTickSpacing", "MajorTickSpacing", 29);
        resourceDB.put("-majortickspacing", resourceObject);
        resourceObject = new ResourceObject("maximum", "Maximum", 30);
        resourceDB.put("-maximum", resourceObject);
        resourceObject = new ResourceObject("minimum", "Minimum", 31);
        resourceDB.put("-minimum", resourceObject);
        resourceObject = new ResourceObject("minorTickSpacing", "MinorTickSpacing", 32);
        resourceDB.put("-minortickspacing", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 33);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("orient", "Orient", 34);
        resourceDB.put("-orient", resourceObject);
        resourceObject = new ResourceObject("orientation", "Orientation", 35);
        resourceDB.put("-orientation", resourceObject);
        resourceObject = new ResourceObject("paintLabels", "PaintLabels", 36);
        resourceDB.put("-paintlabels", resourceObject);
        resourceObject = new ResourceObject("paintTicks", "PaintTicks", 37);
        resourceDB.put("-paintticks", resourceObject);
        resourceObject = new ResourceObject("paintTrack", "PaintTrack", 38);
        resourceDB.put("-painttrack", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 39);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("repeatDelay", "RepeatDelay", 40);
        resourceDB.put("-repeatdelay", resourceObject);
        resourceObject = new ResourceObject("repeatInterval", "RepeatInterval", 41);
        resourceDB.put("-repeatinterval", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 42);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("resolution", "Resolution", 43);
        resourceDB.put("-resolution", resourceObject);
        resourceObject = new ResourceObject("showValue", "ShowValue", 44);
        resourceDB.put("-showvalue", resourceObject);
        resourceObject = new ResourceObject("length", "Length", 45);
        resourceDB.put("-sliderlength", resourceObject);
        resourceObject = new ResourceObject("sliderRelief", "SliderRelief", 46);
        resourceDB.put("-sliderrelief", resourceObject);
        resourceObject = new ResourceObject("snapToTicks", "SnapToTicks", 47);
        resourceDB.put("-snaptoticks", resourceObject);
        resourceObject = new ResourceObject("state", "State", 48);
        resourceDB.put("-state", resourceObject);
        resourceObject = new ResourceObject("takeFocus", "TakeFocus", 49);
        resourceDB.put("-takefocus", resourceObject);
        resourceObject = new ResourceObject("tickInterval", "TickInterval", 50);
        resourceDB.put("-tickinterval", resourceObject);
        resourceObject = new ResourceObject("to", "To", 51);
        resourceDB.put("-to", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 52);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("troughColor", "TroughColor", 53);
        resourceDB.put("-troughcolor", resourceObject);
        resourceObject = new ResourceObject("dValue", "DValue", 54);
        resourceDB.put("-value", resourceObject);
        resourceObject = new ResourceObject("valueIsAdjusting", "ValueIsAdjusting", 55);
        resourceDB.put("-valueisadjusting", resourceObject);
        resourceObject = new ResourceObject("varName", "VarName", 56);
        resourceDB.put("-variable", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 57);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 58);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 59);
        resourceDB.put("-width", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkJSlider swkjslider;

        ResourceDefaultsSetter(Interp interp, SwkJSlider swkjslider) {
            this.interp = interp;
            this.swkjslider = swkjslider;
        }

        public void run() {
            SwkJSlider.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkJSlider swkjslider;
        int opt = 0;
        String result = "";

        JGet(SwkJSlider swkjslider, int opt) {
            this.swkjslider = swkjslider;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkjslider.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkJSlider swkjslider;
        ArrayList roValues = null;

        JGetAll(SwkJSlider swkjslider) {
            this.swkjslider = swkjslider;
        }

        public void run() {
            this.roValues = SwkJSlider.this.getAllConfigurations();
        }
    }

    class MyPanel
    extends JPanel {
        MyPanel() {
        }

        public synchronized void paintComponent(Graphics g) {
            double value = SwkJSlider.this.jslider.getValue();
            Dimension size = SwkJSlider.this.jPanel.getSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int valueHeight = fontMetrics.getHeight();
            String valString = SwkJSlider.this.nf.format(SwkJSlider.this.getDValue());
            int valueWidth = fontMetrics.stringWidth(valString);
            if (SwkJSlider.this.jslider.getOrientation() == 1) {
                if (SwkJSlider.this.showValue) {
                    int y = Math.round((int)((double)(size.height - 20) * value / (double)(SwkJSlider.this.jslider.getMaximum() - SwkJSlider.this.jslider.getMinimum())) + 10);
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, size.width, size.height);
                    g.setColor(this.getForeground());
                    g.drawString(valString, 0, y += valueHeight / 2);
                }
            } else if (SwkJSlider.this.showValue) {
                int x = Math.round((int)((double)(size.width - 20) * value / (double)(SwkJSlider.this.jslider.getMaximum() - SwkJSlider.this.jslider.getMinimum())) + 10);
                if ((x -= valueWidth / 2) < 0) {
                    x = 0;
                }
                if (x > size.width - valueWidth) {
                    x = size.width - valueWidth;
                }
                int y = size.height - 1;
                g.setColor(this.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(this.getForeground());
                g.drawString(valString, x, y);
            }
        }

        public Dimension getMinimumSize() {
            Dimension dSize = new Dimension(0, 0);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (SwkJSlider.this.jslider.getOrientation() == 1) {
                if (SwkJSlider.this.showValue) {
                    double dVal = SwkJSlider.this.convertValue(SwkJSlider.this.jslider.getMaximum());
                    String valString = SwkJSlider.this.nf.format(dVal);
                    dSize.width += fontMetrics.stringWidth(valString);
                }
            } else if (SwkJSlider.this.showValue) {
                dSize.height += fontMetrics.getHeight();
            }
            return dSize;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    class MySlider
    extends JSlider {
        MySlider() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            SwkJSlider.this.jPanel.repaint();
        }

        public Dimension getMinimumSize() {
            Dimension dSize = new Dimension(0, 0);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int fontHeight = fontMetrics.getHeight();
            if (SwkJSlider.this.jslider.getOrientation() == 1) {
                dSize = super.getMinimumSize();
                if (dSize.height < SwkJSlider.this.length) {
                    dSize.height = SwkJSlider.this.length;
                }
                if (dSize.width < SwkJSlider.this.swkwidth) {
                    dSize.width = SwkJSlider.this.swkwidth;
                }
                if (SwkJSlider.this.jslider.getPaintLabels()) {
                    dSize.width += 20;
                }
                if (SwkJSlider.this.jslider.getPaintTicks()) {
                    dSize.width += 10;
                }
            } else {
                dSize = super.getMinimumSize();
                if (dSize.width < SwkJSlider.this.length) {
                    dSize.width = SwkJSlider.this.length;
                }
                if (dSize.height < SwkJSlider.this.swkwidth) {
                    dSize.height = SwkJSlider.this.swkwidth;
                }
            }
            return dSize;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }
}

