/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkJScrollBar;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJScrollBarWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "activate", "delta", "fraction", "get", "identify", "set"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ACTIVATE = 2;
    private static final int OPT_DELTA = 3;
    private static final int OPT_FRACTION = 4;
    private static final int OPT_GET = 5;
    private static final int OPT_IDENTIFY = 6;
    private static final int OPT_SET = 7;
    static boolean gotDefaults = false;

    SwkJScrollBarWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJScrollBar swkjscrollbar = (SwkJScrollBar)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjscrollbar.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjscrollbar.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjscrollbar.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjscrollbar.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJScrollBar.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjscrollbar.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.activate(interp, swkjscrollbar, argv);
                break;
            }
            case 3: {
                this.delta(interp, swkjscrollbar, argv);
                break;
            }
            case 4: {
                this.fraction(interp, swkjscrollbar, argv);
                break;
            }
            case 5: {
                this.get(interp, swkjscrollbar, argv);
                break;
            }
            case 6: {
                this.identify(interp, swkjscrollbar, argv);
                break;
            }
            case 7: {
                this.set(interp, swkjscrollbar, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void activate(Interp interp, SwkJScrollBar swkjscrollbar, TclObject[] argv) throws TclException {
        if (argv.length > 3) {
            throw new TclNumArgsException(interp, 2, argv, "?element?");
        }
    }

    void delta(Interp interp, SwkJScrollBar swkjscrollbar, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "deltaX deltaY");
        }
        double deltaX = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        double deltaY = TclInteger.get((Interp)interp, (TclObject)argv[3]);
        double result = new Delta().exec(swkjscrollbar, deltaX, deltaY);
        interp.setResult(result);
    }

    void fraction(Interp interp, SwkJScrollBar swkjscrollbar, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "deltaX deltaY");
        }
        double x = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        double y = TclInteger.get((Interp)interp, (TclObject)argv[3]);
        double result = new Delta().exec(swkjscrollbar, x, y);
        interp.setResult(result);
    }

    void get(Interp interp, SwkJScrollBar swkjscrollbar, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        double[] result = new Get().exec(swkjscrollbar);
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)result[0]));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)result[1]));
        interp.setResult(list);
    }

    void identify(Interp interp, SwkJScrollBar swkjscrollbar, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "x delytaY");
        }
    }

    void set(Interp interp, SwkJScrollBar swkjscrollbar, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "firstFraction lastFraction");
        }
        double firstFraction = TclDouble.get((Interp)interp, (TclObject)argv[2]);
        double lastFraction = TclDouble.get((Interp)interp, (TclObject)argv[3]);
        if (firstFraction < 0.0) {
            firstFraction = 0.0;
        }
        if (firstFraction > 1.0) {
            firstFraction = 1.0;
        }
        if (lastFraction < firstFraction) {
            lastFraction = firstFraction;
        }
        if (lastFraction > 1.0) {
            lastFraction = 1.0;
        }
        new Set().exec(swkjscrollbar, firstFraction, lastFraction);
    }

    class Set
    extends UpdateOnEventThread {
        SwkJScrollBar swkjscrollbar;
        double firstFraction = 0.0;
        double lastFraction = 1.0;

        Set() {
        }

        void exec(SwkJScrollBar swkjscrollbar, double firstFraction, double lastFraction) {
            this.swkjscrollbar = swkjscrollbar;
            this.firstFraction = firstFraction;
            this.lastFraction = lastFraction;
            this.execOnThread();
        }

        public void run() {
            int min = this.swkjscrollbar.getMinimum();
            int max = this.swkjscrollbar.getMaximum();
            int value = (int)Math.round(this.firstFraction * (double)(max - min) + (double)min);
            int extent = (int)Math.round((this.lastFraction - this.firstFraction) * (double)(max - min));
            this.swkjscrollbar.setFromSet();
            this.swkjscrollbar.setValues(value, extent, min, max);
        }
    }

    class Get
    extends GetValueOnEventThread {
        SwkJScrollBar swkjscrollbar;
        double[] result = new double[2];

        Get() {
        }

        double[] exec(SwkJScrollBar swkjscrollbar) {
            this.swkjscrollbar = swkjscrollbar;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            int min = this.swkjscrollbar.getMinimum();
            int max = this.swkjscrollbar.getMaximum();
            int value = this.swkjscrollbar.getValue();
            int extent = this.swkjscrollbar.getVisibleAmount();
            this.result[0] = ((double)value - (double)min) / (double)(max - min);
            this.result[1] = ((double)value + (double)extent - (double)min) / (double)(max - min);
        }
    }

    class Fraction
    extends GetValueOnEventThread {
        SwkJScrollBar swkjscrollbar;
        double result = 0.0;
        double x = 0.0;
        double y = 0.0;

        Fraction() {
        }

        double exec(SwkJScrollBar swkjscrollbar, double x, double y) {
            this.swkjscrollbar = swkjscrollbar;
            this.x = x;
            this.y = y;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            int min = this.swkjscrollbar.getMinimum();
            int max = this.swkjscrollbar.getMaximum();
            if (this.swkjscrollbar.getOrientation() == 0) {
                if (this.x > (double)max) {
                    this.x = max;
                }
                if (this.x < (double)min) {
                    this.x = min;
                }
                this.result = (this.x - (double)min) / (double)(max - min);
            } else {
                if (this.y > (double)max) {
                    this.y = max;
                }
                if (this.y < (double)min) {
                    this.y = min;
                }
                this.result = (this.y - (double)min) / (double)(max - min);
            }
        }
    }

    class Delta
    extends GetValueOnEventThread {
        SwkJScrollBar swkjscrollbar;
        double result = 0.0;
        double deltaX = 0.0;
        double deltaY = 0.0;

        Delta() {
        }

        double exec(SwkJScrollBar swkjscrollbar, double deltaX, double deltaY) {
            this.swkjscrollbar = swkjscrollbar;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            int min = this.swkjscrollbar.getMinimum();
            int max = this.swkjscrollbar.getMaximum();
            this.result = this.swkjscrollbar.getOrientation() == 0 ? this.deltaX / (double)(max - min) : this.deltaY / (double)(max - min);
        }
    }
}

