/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.Widgets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.lang.reflect.Method;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class SwkColorPicker
implements Command {
    Interp interp = null;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        this.interp = interp;
        this.option(interp, argv);
    }

    void option(Interp interp, TclObject[] argv) throws TclException {
        Object options = null;
        if ((argv.length - 1) % 2 != 0) {
            throw new TclException(interp, "tk_messageBox:  number of args must be a multiple of 2");
        }
        String title = "Choose Color";
        String icon = "info";
        String type = "ok";
        String defaultValue = "";
        String dialogParent = "";
        Object choices = null;
        Color initialColor = Color.BLACK;
        boolean showOpacity = true;
        for (int i = 1; i < argv.length; i += 2) {
            String option = argv[i].toString();
            if (option.equals("-initialcolor")) {
                initialColor = SwankUtil.getColor(interp, argv[i + 1]);
                continue;
            }
            if (option.equals("-parent")) {
                dialogParent = argv[i + 1].toString();
                continue;
            }
            if (option.equals("-title")) {
                title = argv[i + 1].toString();
                continue;
            }
            if (option.equals("-showopacity")) {
                showOpacity = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                continue;
            }
            throw new TclException(interp, "bad option \"" + option + "\": must be -initialcolor, -parent, -showopacity, -title");
        }
        Component dParent = null;
        if (dialogParent != null && dialogParent.length() != 0) {
            TclObject tObj = (TclObject)Widgets.getWidget(interp, dialogParent);
            if (tObj == null) {
                throw new TclException(interp, "bad window path name \"" + dialogParent + "\"");
            }
            dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
        } else {
            TclObject tObj;
            String focusWindow = FocusCmd.getFocusWindow();
            if (focusWindow != null && focusWindow.length() != 0 && (tObj = (TclObject)Widgets.getWidget(interp, focusWindow)) != null) {
                dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
            }
            if (dParent == null && (tObj = (TclObject)Widgets.getWidget(interp, ".")) != null) {
                dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
            }
        }
        Container container = Widgets.getContainer(dParent);
        Component frameOrWindow = Widgets.getFrameOrWindow(container);
        new Option().exec(title, initialColor, showOpacity, frameOrWindow);
    }

    class Option
    extends GetValueOnEventThread {
        int index = -1;
        String title = "";
        String[] options = null;
        String defaultOption = "";
        String strResult = "";
        int result = -1;
        boolean showOpacity = false;
        Color color;
        Component dParent = null;
        Color initialColor = Color.BLACK;

        Option() {
        }

        void exec(String title, Color initialColor, boolean showOpacity, Component dParent) {
            this.title = title;
            this.initialColor = initialColor;
            this.showOpacity = showOpacity;
            this.dParent = dParent;
            this.execOnThread();
            if (this.color != null) {
                SwkColorPicker.this.interp.setResult(SwankUtil.parseColor(this.color));
            }
        }

        public void run() {
            Class<?> cl = null;
            try {
                cl = Class.forName("com.bric.swing.ColorPicker");
            }
            catch (ClassNotFoundException cnfE) {
                return;
            }
            if (cl != null) {
                Method method = null;
                Class[] classArgs = new Class[]{Window.class, String.class, Color.class, Boolean.TYPE};
                try {
                    method = cl.getMethod("showDialog", classArgs);
                }
                catch (NoSuchMethodException nsmE) {
                    // empty catch block
                }
                try {
                    if (method != null) {
                        this.color = (Color)method.invoke(cl.newInstance(), (Window)this.dParent, this.title, this.initialColor, this.showOpacity);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }
}

