/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.EventCmd;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkEventType;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import tcl.lang.Interp;
import tcl.lang.TclObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkBind {
    public static SwkBinding getBinding(Interp interp, TclObject[] argv, int firstArg) {
        String eventString = argv[firstArg].toString();
        StreamTokenizer tokenizer = null;
        SwkBinding swkBinding = new SwkBinding();
        int subtype = -1;
        if (EventCmd.checkVirtual(eventString)) {
            if (eventString.equals("<<StateChanged>>")) {
                swkBinding.type = 15;
            } else if (eventString.equals("<<SelectionChanged>>")) {
                swkBinding.type = 16;
            } else {
                swkBinding.virtual = true;
                swkBinding.string = eventString;
            }
            return swkBinding;
        }
        SwkEventType eventType = null;
        if (SwkEventType.eventTable == null) {
            SwkEventType.initEventTable();
        }
        int end = eventString.length();
        int start = 0;
        if (eventString.charAt(0) == '<') {
            start = 1;
        }
        if (eventString.charAt(end - 1) == '>') {
            --end;
        }
        if ((eventString = eventString.substring(start, end)).length() == 1) {
            char eventChar = eventString.charAt(0);
            if (start > 0 && (eventChar == '1' || eventChar == '2' || eventChar == '3')) {
                swkBinding.type = 2;
                swkBinding.subtype = 0;
                if (eventChar == '1') {
                    swkBinding.detail = 16;
                    swkBinding.mod |= 0x400;
                } else if (eventChar == '2') {
                    swkBinding.detail = 8;
                    swkBinding.mod |= 0x800;
                } else if (eventChar == '3') {
                    swkBinding.detail = 4;
                    swkBinding.mod |= 0x1000;
                }
            } else {
                swkBinding.type = 3;
                swkBinding.subtype = 0;
                swkBinding.detail = eventChar;
                swkBinding.keyStroke = null;
            }
        } else {
            boolean gotMod;
            boolean gotEvent;
            block43: {
                tokenizer = new StreamTokenizer(new StringReader(eventString));
                tokenizer.resetSyntax();
                tokenizer.wordChars(97, 122);
                tokenizer.wordChars(65, 90);
                tokenizer.wordChars(95, 95);
                tokenizer.whitespaceChars(0, 32);
                tokenizer.wordChars(48, 57);
                tokenizer.whitespaceChars(45, 45);
                gotEvent = false;
                gotMod = false;
                while (true) {
                    block42: {
                        try {
                            if (tokenizer.nextToken() != -1) break block42;
                            break block43;
                        }
                        catch (IOException ioE) {
                            return null;
                        }
                    }
                    if (tokenizer.ttype != -3) continue;
                    eventType = (SwkEventType)SwkEventType.countTable.get(tokenizer.sval.toLowerCase());
                    if (eventType != null) {
                        if (swkBinding.count > 1) {
                            System.out.println("Two count fields");
                            return null;
                        }
                        swkBinding.count = eventType.type;
                        continue;
                    }
                    eventType = (SwkEventType)SwkEventType.modTable.get(tokenizer.sval.toLowerCase());
                    if (eventType != null) {
                        gotMod = true;
                        if (gotEvent) {
                            System.out.println("Mod field after event field: " + tokenizer.sval);
                            return null;
                        }
                        swkBinding.mod |= eventType.type;
                        continue;
                    }
                    eventType = (SwkEventType)SwkEventType.eventTable.get(tokenizer.sval.toLowerCase());
                    if (eventType != null) {
                        if (gotEvent) {
                            System.out.println("Event field after event field");
                            return null;
                        }
                        swkBinding.type = eventType.type;
                        subtype = swkBinding.subtype = eventType.subtype;
                        gotEvent = true;
                        continue;
                    }
                    if (tokenizer.sval.length() == 1) {
                        char eCh = tokenizer.sval.charAt(0);
                        if (!gotEvent) {
                            swkBinding.type = eCh == '1' || eCh == '2' || eCh == '3' ? 2 : 3;
                        }
                        if (swkBinding.type == 3) {
                            swkBinding.detail = eCh;
                            swkBinding.keyStroke = null;
                        } else if (swkBinding.type == 2 || swkBinding.type == 4) {
                            if (eCh == '1') {
                                swkBinding.detail = 16;
                                swkBinding.mod |= 0x400;
                            } else if (eCh == '2') {
                                swkBinding.mod |= 0x800;
                                swkBinding.detail = 8;
                            } else if (eCh == '3') {
                                swkBinding.mod |= 0x1000;
                                swkBinding.detail = 4;
                            }
                        }
                        gotEvent = true;
                        continue;
                    }
                    if (!gotEvent) {
                        eventType = (SwkEventType)SwkEventType.detailTable.get(tokenizer.sval.toLowerCase());
                        if (eventType != null) {
                            swkBinding.type = eventType.type;
                            swkBinding.subtype = eventType.subtype;
                            swkBinding.detail = eventType.detail;
                            swkBinding.name = eventType.name;
                            swkBinding.keyStroke = KeyStroke.getKeyStroke((char)eventType.detail);
                            if (eventType.subtype == 0) {
                                swkBinding.mod |= eventType.mods;
                            }
                            gotEvent = true;
                            continue;
                        }
                        System.out.println("Unknown detail " + tokenizer.sval.toLowerCase());
                        return null;
                    }
                    eventType = (SwkEventType)SwkEventType.detailTable.get(tokenizer.sval.toLowerCase());
                    if (eventType == null) break;
                    swkBinding.detail = eventType.detail;
                    swkBinding.name = eventType.name;
                    swkBinding.keyStroke = KeyStroke.getKeyStroke((char)eventType.detail);
                    if (subtype == 0) {
                        swkBinding.mod |= eventType.mods;
                    }
                    gotEvent = true;
                }
                System.out.println("Unknown detail " + tokenizer.sval.toLowerCase());
                return null;
            }
            if (!gotEvent) {
                if (!gotMod) {
                    System.out.println("no event");
                    return null;
                }
                System.out.println("event is mod");
                return null;
            }
        }
        return swkBinding;
    }

    public static void updateBindingCommand(Interp interp, SwkBinding swkBinding, TclObject[] argv, int firstArg) {
        if (argv.length != firstArg + 1) {
            if (argv[firstArg + 1].toString().length() == 0) {
                swkBinding.remove = true;
            } else if (argv[firstArg + 1].toString().charAt(0) == '+') {
                swkBinding.add = true;
                swkBinding.command = argv[firstArg + 1].toString().substring(1);
            } else {
                swkBinding.add = false;
                swkBinding.command = argv[firstArg + 1].toString();
            }
        }
    }

    public static void setBinding(ArrayList<SwkBinding> bindings, SwkBinding newBinding) {
        int index = -1;
        for (int i = 0; i < bindings.size(); ++i) {
            SwkBinding binding = bindings.get(i);
            if (!binding.equals(newBinding)) continue;
            index = i;
            break;
        }
        if (newBinding.add) {
            if (index != -1) {
                SwkBinding binding = bindings.get(index);
                binding.command = binding.command + '\n' + newBinding.command;
            } else {
                bindings.add(newBinding);
            }
        } else if (index != -1) {
            bindings.set(index, newBinding);
        } else {
            bindings.add(newBinding);
        }
    }
}

