/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

public class ImageTestCmd
implements Command {
    static Hashtable images = new Hashtable();
    static int iImage = 0;
    private static final String[] validCmds = new String[]{"changed"};
    private static final int OPT_CHANGED = 0;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: {
                if (argv.length != 8) {
                    throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                }
                int x = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                int y = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                int width = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                int height = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                int timWidth = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                int timHeight = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    public static BufferedImage edge(Interp interp, BufferedImage sourceImage, BufferedImage destImage) {
        float[] edge = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, edge), 1, null);
        return op.filter(sourceImage, destImage);
    }

    public static BufferedImage scale(Interp interp, BufferedImage sourceImage, double scaleValue, double offsetValue) {
        RescaleOp op = new RescaleOp((float)scaleValue, (float)offsetValue, null);
        return op.filter(sourceImage, null);
    }

    public static void configure(Interp interp, ImageIcon image, TclObject[] argv, int start) throws TclException {
        if (argv.length <= start) {
            return;
        }
        Object ro = null;
        for (int i = start; i < argv.length; i += 2) {
            Object iObj;
            String imageName;
            if (argv[i].toString().equals("-file")) {
                String fileName = argv[i + 1].toString();
                imageName = image.getDescription();
                ImageIcon image2 = null;
                URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
                image2 = url != null ? new ImageIcon(url, imageName) : new ImageIcon(fileName, imageName);
                if (image2 == null) {
                    throw new TclException(interp, "Couldn't create image from file " + fileName);
                }
                image.setImage(image2.getImage());
                continue;
            }
            if (!argv[i].toString().equals("-object") || !((iObj = ReflectObject.get((Interp)interp, (TclObject)argv[i + 1])) instanceof BufferedImage)) continue;
            imageName = image.getDescription();
            images.put(imageName, (BufferedImage)iObj);
        }
    }
}

