/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import java.awt.Container;
import java.awt.Window;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class DestroyCmd
implements Command {
    public void cmdProc(final Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            return;
        }
        final String[] widgetNames = new String[argv.length - 1];
        for (int j = 1; j < argv.length; ++j) {
            widgetNames[j - 1] = argv[j].toString().intern();
        }
        new GetValueOnEventThread(){

            public void run() {
                DestroyCmd.destroyWidgets(interp, widgetNames);
            }
        }.execOnThread();
    }

    public static void destroyWidgets(Interp interp, String[] widgetNames) {
        HashSet topLevels = new HashSet();
        for (int j = 0; j < widgetNames.length; ++j) {
            try {
                DestroyCmd.destroyWidget(interp, widgetNames[j], topLevels);
                continue;
            }
            catch (TclException tclE) {
                interp.backgroundError();
            }
        }
        for (Container topLevel : topLevels) {
            Widgets.relayoutContainer(topLevel);
        }
    }

    public static void destroyWidget(Interp interp, String name) throws TclException {
        DestroyCmd.destroyWidget(interp, name, null);
    }

    public static void destroyWidget(Interp interp, String name, HashSet topLevels) throws TclException {
        Container container;
        TclObject tObj = (TclObject)Widgets.getWidget(interp, name);
        if (tObj == null) {
            return;
        }
        Vector childrenNames = Widgets.children(interp, name);
        for (int k = 0; k < childrenNames.size(); ++k) {
            DestroyCmd.destroyWidget(interp, (String)childrenNames.elementAt(k), topLevels);
        }
        Widgets.removeChild(interp, name);
        Widgets.removeWidget(interp, name);
        interp.deleteCommand(name);
        Object object = ReflectObject.get((Interp)interp, (TclObject)tObj);
        if (object == null) {
            return;
        }
        if (object instanceof JComponent && (container = ((JComponent)object).getParent()) != null) {
            container.remove((JComponent)object);
            while (container != null) {
                if (container instanceof Window) {
                    if (topLevels == null) break;
                    topLevels.add(container);
                    break;
                }
                if (container instanceof JFrame) {
                    if (topLevels == null) break;
                    topLevels.add(container);
                    break;
                }
                container = container.getParent();
            }
        }
        if (object instanceof Window) {
            ((Window)object).dispose();
            if (topLevels != null) {
                topLevels.remove((Container)object);
            }
        }
        if (object instanceof SwkWidget) {
            ((SwkWidget)object).close();
        }
        tObj.release();
        tObj = null;
    }
}

