/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class CursorCmd
implements Command {
    static HashMap cursors = new HashMap();
    private static final String[] validCmds = new String[]{"create", "object"};
    private static final int OPT_CREATE = 0;
    private static final int OPT_OBJECT = 1;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: {
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                }
                String cursorName = argv[2].toString();
                int firstOption = 3;
                CursorCmd.create(interp, cursorName, argv, firstOption);
                interp.setResult(cursorName);
                break;
            }
            case 1: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "object imageName");
                }
                Object cursorObject = cursors.get(argv[2].toString());
                if (cursorObject == null) {
                    throw new TclException(interp, "image " + argv[2].toString() + " doesn't exist");
                }
                if (!(cursorObject instanceof Cursor)) break;
                TclObject tObj = ReflectObject.newInstance((Interp)interp, Cursor.class, (Object)((Cursor)cursorObject));
                interp.setResult(tObj);
                break;
            }
        }
    }

    public static void create(Interp interp, String cursorName, TclObject[] argv, int start) throws TclException {
        Cursor cursor;
        if (argv.length <= start) {
            return;
        }
        Object ro = null;
        String fileName = null;
        int x = 0;
        int y = 0;
        for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "no value for \"" + argv[i].toString() + "\"");
            }
            if (argv[i].toString().equals("-file")) {
                fileName = argv[i + 1].toString();
                continue;
            }
            if (argv[i].toString().equals("-x")) {
                x = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                continue;
            }
            if (!argv[i].toString().equals("-y")) continue;
            y = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
        }
        if (fileName == null) {
            throw new TclException(interp, "No filename specified");
        }
        ImageIcon imageIcon = null;
        URL url = null;
        url = fileName.startsWith("resource:") ? Thread.currentThread().getContextClassLoader().getResource(fileName.substring(10)) : Thread.currentThread().getContextClassLoader().getResource(fileName);
        imageIcon = url != null ? new ImageIcon(url, cursorName) : new ImageIcon(fileName, cursorName);
        if (imageIcon == null) {
            throw new TclException(interp, "Couldn't create image from file " + fileName);
        }
        Image image = imageIcon.getImage();
        int curWidth = image.getWidth(null);
        int curHeight = image.getHeight(null);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension bestSize = toolkit.getBestCursorSize(curWidth, curHeight);
        int bestWidth = (int)bestSize.getWidth();
        int bestHeight = (int)bestSize.getHeight();
        if (bestWidth > curWidth && bestHeight > curHeight) {
            BufferedImage fullImage = new BufferedImage(bestWidth, bestHeight, 2);
            Graphics g2D = ((Image)fullImage).getGraphics();
            Color transpColor = new Color(0, true);
            int xOff = (bestWidth - curWidth) / 2;
            int yOff = (bestHeight - curHeight) / 2;
            x += xOff;
            y += yOff;
            g2D.drawImage(image, xOff, yOff, transpColor, null);
            image = fullImage;
        }
        if ((cursor = toolkit.createCustomCursor(image, new Point(x, y), cursorName)) == null) {
            throw new TclException(interp, "Couldn't create cursor from image");
        }
        cursors.put(cursorName, cursor);
    }

    public static Cursor getCursor(String name) {
        return (Cursor)cursors.get(name);
    }
}

