/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Compiler;
import org.codehaus.janino.Cookable;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.codehaus.janino.util.resource.PathResourceFinder;

public class SimpleCompiler
extends Cookable {
    private static final boolean DEBUG = false;
    private final ClassLoaderIClassLoader DEFAULT_ICLASSLOADER;
    private ClassLoaderIClassLoader classLoaderIClassLoader;
    private ClassLoader classLoader;
    boolean noloadSimpleCompiler;
    IClassLoader icloader;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$codehaus$janino$SimpleCompiler;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage:");
            System.err.println("    org.codehaus.janino.SimpleCompiler <source-file> <class-name> <arg> [ ... ]");
            System.err.println("Reads a compilation unit from the given <source-file> and invokes method");
            System.err.println("\"public static void main(String[])\" of class <class-name>.");
            System.exit(1);
        }
        String sourceFileName = args[0];
        String className = args[1];
        String[] mainArgs = new String[args.length - 2];
        System.arraycopy(args, 2, mainArgs, 0, mainArgs.length);
        ClassLoader cl = new SimpleCompiler(sourceFileName, new FileInputStream(sourceFileName)).getClassLoader();
        Class<?> c = cl.loadClass(className);
        Method m = c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = SimpleCompiler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        m.invoke(null, new Object[]{mainArgs});
    }

    public SimpleCompiler(String optionalFileName, Reader in) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.classLoaderIClassLoader = this.DEFAULT_ICLASSLOADER = new ClassLoaderIClassLoader(Thread.currentThread().getContextClassLoader());
        this.classLoader = null;
        this.noloadSimpleCompiler = false;
        this.icloader = null;
        this.cook(optionalFileName, in);
    }

    public SimpleCompiler(String optionalFileName, InputStream is) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.classLoaderIClassLoader = this.DEFAULT_ICLASSLOADER = new ClassLoaderIClassLoader(Thread.currentThread().getContextClassLoader());
        this.classLoader = null;
        this.noloadSimpleCompiler = false;
        this.icloader = null;
        this.cook(optionalFileName, is);
    }

    public SimpleCompiler(String fileName) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.classLoaderIClassLoader = this.DEFAULT_ICLASSLOADER = new ClassLoaderIClassLoader(Thread.currentThread().getContextClassLoader());
        this.classLoader = null;
        this.noloadSimpleCompiler = false;
        this.icloader = null;
        this.cookFile(fileName);
    }

    public SimpleCompiler(Scanner scanner, ClassLoader optionalParentClassLoader) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.classLoaderIClassLoader = this.DEFAULT_ICLASSLOADER = new ClassLoaderIClassLoader(Thread.currentThread().getContextClassLoader());
        this.classLoader = null;
        this.noloadSimpleCompiler = false;
        this.icloader = null;
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public SimpleCompiler() {
        this.classLoaderIClassLoader = this.DEFAULT_ICLASSLOADER = new ClassLoaderIClassLoader(Thread.currentThread().getContextClassLoader());
        this.classLoader = null;
        this.noloadSimpleCompiler = false;
        this.icloader = null;
    }

    public SimpleCompiler(boolean noload) {
        this.classLoaderIClassLoader = this.DEFAULT_ICLASSLOADER = new ClassLoaderIClassLoader(Thread.currentThread().getContextClassLoader());
        this.classLoader = null;
        this.noloadSimpleCompiler = false;
        this.icloader = null;
        this.setParentClassLoader(null);
        if (!noload) {
            throw new RuntimeException("noload must be true");
        }
        this.noloadSimpleCompiler = true;
        String classPath = System.getProperty("java.class.path");
        this.icloader = Compiler.createJavacLikePathIClassLoader(null, null, PathResourceFinder.parsePath(classPath));
    }

    public ClassFile[] compile(String javasrc) {
        if (!this.noloadSimpleCompiler) {
            throw new RuntimeException("SimpleCompiler.compile() can only be used with a SimpleCompiler() constructed with no arguments");
        }
        try {
            StringReader sreader = new StringReader(javasrc);
            Scanner scanner = new Scanner(null, sreader);
            Parser parser = new Parser(scanner);
            Java.CompilationUnit cunit = parser.parseCompilationUnit();
            UnitCompiler ucompiler = new UnitCompiler(cunit, this.icloader);
            EnumeratorSet defaultDebug = DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION;
            ClassFile[] cfiles = ucompiler.compileUnit(defaultDebug);
            return cfiles;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public void setParentClassLoader(ClassLoader optionalParentClassLoader) {
        this.classLoaderIClassLoader = optionalParentClassLoader != null ? new ClassLoaderIClassLoader(optionalParentClassLoader) : this.DEFAULT_ICLASSLOADER;
    }

    protected void internalCook(Scanner scanner) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        Java.CompilationUnit compilationUnit = new Parser(scanner).parseCompilationUnit();
        this.compileToClassLoader(compilationUnit, DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION);
    }

    public ClassLoader getClassLoader() {
        if (this.getClass() != (class$org$codehaus$janino$SimpleCompiler == null ? (class$org$codehaus$janino$SimpleCompiler = SimpleCompiler.class$("org.codehaus.janino.SimpleCompiler")) : class$org$codehaus$janino$SimpleCompiler)) {
            throw new IllegalStateException("Must not be called on derived instances");
        }
        if (this.classLoader == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.classLoader;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleCompiler)) {
            return false;
        }
        SimpleCompiler that = (SimpleCompiler)o;
        if (this.getClass() != that.getClass()) {
            return false;
        }
        if (this.classLoader == null || that.classLoader == null) {
            throw new IllegalStateException("Equality can only be checked after cooking");
        }
        return this.classLoader.equals(that.classLoader);
    }

    public int hashCode() {
        return this.classLoader.hashCode();
    }

    protected Java.Type classToType(Location location, Class optionalClass) {
        IClass iClass;
        if (optionalClass == null) {
            return null;
        }
        try {
            iClass = this.classLoaderIClassLoader.loadIClass(Descriptor.fromClassName(optionalClass.getName()));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Loading IClass \"" + optionalClass.getName() + "\": " + ex);
        }
        if (iClass == null) {
            throw new RuntimeException("Cannot load class \"" + optionalClass.getName() + "\" through the given ClassLoader");
        }
        return new Java.SimpleType(location, iClass);
    }

    protected Java.Type[] classesToTypes(Location location, Class[] classes) {
        Java.Type[] types = new Java.Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = this.classToType(location, classes[i]);
        }
        return types;
    }

    protected ClassLoader compileToClassLoader(Java.CompilationUnit compilationUnit, EnumeratorSet debuggingInformation) throws CompileException {
        ClassFile[] classFiles = new UnitCompiler(compilationUnit, this.classLoaderIClassLoader).compileUnit(debuggingInformation);
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (int i = 0; i < classFiles.length; ++i) {
            ClassFile cf = classFiles[i];
            classes.put(cf.getThisClassName(), cf.toByteArray());
        }
        this.classLoader = new ByteArrayClassLoader(classes, this.classLoaderIClassLoader.getClassLoader());
        return this.classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

