/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.enumerator.Enumerator;

public class Parser {
    private final Scanner scanner;
    private static final short[] MUTUALS = new short[]{7};
    private WarningHandler optionalWarningHandler = null;

    public Parser(Scanner scanner) {
        this.scanner = scanner;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public Java.CompilationUnit parseCompilationUnit() throws ParseException, Scanner.ScanException, IOException {
        Java.CompilationUnit compilationUnit = new Java.CompilationUnit(this.location().getFileName());
        if (this.peekKeyword("package")) {
            compilationUnit.setPackageDeclaration(this.parsePackageDeclaration());
        }
        while (this.peekKeyword("import")) {
            compilationUnit.addImportDeclaration(this.parseImportDeclaration());
        }
        while (!this.scanner.peek().isEOF()) {
            if (this.peekOperator(";")) {
                this.eatToken();
                continue;
            }
            compilationUnit.addPackageMemberTypeDeclaration(this.parsePackageMemberTypeDeclaration());
        }
        return compilationUnit;
    }

    public Java.PackageDeclaration parsePackageDeclaration() throws ParseException, Scanner.ScanException, IOException {
        this.readKeyword("package");
        Location loc = this.location();
        String packageName = Parser.join(this.parseQualifiedIdentifier(), ".");
        this.readOperator(";");
        this.verifyStringIsConventionalPackageName(packageName, loc);
        return new Java.PackageDeclaration(loc, packageName);
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclaration() throws ParseException, Scanner.ScanException, IOException {
        this.readKeyword("import");
        Java.CompilationUnit.ImportDeclaration importDeclaration = this.parseImportDeclarationBody();
        this.readOperator(";");
        return importDeclaration;
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclarationBody() throws ParseException, Scanner.ScanException, IOException {
        Location loc = this.location();
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.readIdentifier());
        while (this.peekOperator(".")) {
            this.readOperator(".");
            if (this.peekOperator("*")) {
                this.eatToken();
                return new Java.CompilationUnit.TypeImportOnDemandDeclaration(loc, l.toArray(new String[l.size()]));
            }
            l.add(this.readIdentifier());
        }
        return new Java.CompilationUnit.SingleTypeImportDeclaration(loc, l.toArray(new String[l.size()]));
    }

    public String[] parseQualifiedIdentifier() throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Identifier expected");
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.readIdentifier());
        while (this.peekOperator(".") && this.scanner.peekNextButOne().isIdentifier()) {
            this.eatToken();
            l.add(this.readIdentifier());
        }
        return l.toArray(new String[l.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public Java.PackageMemberTypeDeclaration parsePackageMemberTypeDeclaration() throws ParseException, Scanner.ScanException, IOException {
        void var3_3;
        Java.AbstractTypeDeclaration res;
        String optionalDocComment = this.scanner.doc();
        short modifiers = this.parseModifiersOpt();
        if (this.peekKeyword("class")) {
            if (optionalDocComment == null) {
                this.warning("CDCM", "Class doc comment missing", this.location());
            }
            this.eatToken();
            res = (Java.PackageMemberClassDeclaration)this.parseClassDeclarationRest(optionalDocComment, modifiers, ClassDeclarationContext.COMPILATION_UNIT);
        } else if (this.peekKeyword("interface")) {
            if (optionalDocComment == null) {
                this.warning("IDCM", "Interface doc comment missing", this.location());
            }
            this.eatToken();
            res = (Java.PackageMemberInterfaceDeclaration)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers, InterfaceDeclarationContext.COMPILATION_UNIT);
        } else {
            this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in class or interface declaration");
            return null;
        }
        return var3_3;
    }

    public short parseModifiersOpt() throws ParseException, Scanner.ScanException, IOException {
        short mod = 0;
        while (this.peekKeyword()) {
            int x;
            String kw = this.scanner.peek().getKeyword();
            int n = kw == "public" ? 1 : (kw == "protected" ? 4 : (kw == "private" ? 2 : (kw == "static" ? 8 : (kw == "abstract" ? 1024 : (kw == "final" ? 16 : (kw == "native" ? 256 : (kw == "synchronized" ? 32 : (kw == "transient" ? 128 : (kw == "volatile" ? 64 : (x = kw == "strictfp" ? 2048 : -1))))))))));
            if (x == -1) break;
            this.eatToken();
            if ((mod & x) != 0) {
                this.throwParseException("Duplicate modifier \"" + kw + "\"");
            }
            for (int i = 0; i < MUTUALS.length; ++i) {
                short m = MUTUALS[i];
                if ((x & m) == 0 || (mod & m) == 0) continue;
                this.throwParseException("Only one of \"" + Mod.shortToString(m) + "\" allowed");
            }
            mod = (short)(mod | x);
        }
        return mod;
    }

    /*
     * WARNING - void declaration
     */
    public Java.NamedClassDeclaration parseClassDeclarationRest(String optionalDocComment, short modifiers, ClassDeclarationContext context) throws ParseException, Scanner.ScanException, IOException {
        void var8_8;
        Java.NamedClassDeclaration namedClassDeclaration;
        Location location = this.location();
        String className = this.readIdentifier();
        this.verifyIdentifierIsConventionalClassOrInterfaceName(className, location);
        Java.ReferenceType optionalExtendedType = null;
        if (this.peekKeyword("extends")) {
            this.eatToken();
            optionalExtendedType = this.parseReferenceType();
        }
        Java.Type[] implementedTypes = new Java.ReferenceType[]{};
        if (this.peekKeyword("implements")) {
            this.eatToken();
            implementedTypes = this.parseReferenceTypeList();
        }
        if (context == ClassDeclarationContext.COMPILATION_UNIT) {
            namedClassDeclaration = new Java.PackageMemberClassDeclaration(location, optionalDocComment, modifiers, className, optionalExtendedType, implementedTypes);
        } else if (context == ClassDeclarationContext.TYPE_DECLARATION) {
            namedClassDeclaration = new Java.MemberClassDeclaration(location, optionalDocComment, modifiers, className, optionalExtendedType, implementedTypes);
        } else if (context == ClassDeclarationContext.BLOCK) {
            namedClassDeclaration = new Java.LocalClassDeclaration(location, optionalDocComment, modifiers, className, optionalExtendedType, implementedTypes);
        } else {
            throw new RuntimeException("SNO: Class declaration in unexpected context " + context);
        }
        this.parseClassBody((Java.ClassDeclaration)var8_8);
        return var8_8;
    }

    public void parseClassBody(Java.ClassDeclaration classDeclaration) throws ParseException, Scanner.ScanException, IOException {
        if (!this.peekOperator("{")) {
            this.throwParseException("\"{\" expected at start of class body");
        }
        this.eatToken();
        while (true) {
            if (this.peekOperator("}")) {
                this.eatToken();
                return;
            }
            this.parseClassBodyDeclaration(classDeclaration);
        }
    }

    public void parseClassBodyDeclaration(Java.ClassDeclaration classDeclaration) throws ParseException, Scanner.ScanException, IOException {
        if (this.peekOperator(";")) {
            this.eatToken();
            return;
        }
        String optionalDocComment = this.scanner.doc();
        short modifiers = this.parseModifiersOpt();
        if (this.peekOperator("{")) {
            if ((modifiers & 0xFFFFFFF7) != 0) {
                this.throwParseException("Only modifier \"static\" allowed on initializer");
            }
            Java.Initializer initializer = new Java.Initializer(this.location(), (modifiers & 8) != 0, this.parseBlock());
            classDeclaration.addVariableDeclaratorOrInitializer(initializer);
            return;
        }
        if (this.peekKeyword("void")) {
            Location location = this.location();
            this.eatToken();
            if (optionalDocComment == null) {
                this.warning("MDCM", "Method doc comment missing", location);
            }
            String name = this.readIdentifier();
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(classDeclaration, optionalDocComment, modifiers, new Java.BasicType(location, 0), name));
            return;
        }
        if (this.peekKeyword("class")) {
            if (optionalDocComment == null) {
                this.warning("MCDCM", "Member class doc comment missing", this.location());
            }
            this.eatToken();
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(optionalDocComment, modifiers, ClassDeclarationContext.TYPE_DECLARATION)));
            return;
        }
        if (this.peekKeyword("interface")) {
            if (optionalDocComment == null) {
                this.warning("MIDCM", "Member interface doc comment missing", this.location());
            }
            this.eatToken();
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, (short)(modifiers | 8), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
            return;
        }
        if (classDeclaration instanceof Java.NamedClassDeclaration && this.scanner.peek().isIdentifier(((Java.NamedClassDeclaration)classDeclaration).getName()) && this.scanner.peekNextButOne().isOperator("(")) {
            if (optionalDocComment == null) {
                this.warning("CDCM", "Constructor doc comment missing", this.location());
            }
            classDeclaration.addConstructor(this.parseConstructorDeclarator(classDeclaration, optionalDocComment, modifiers));
            return;
        }
        Java.Type memberType = this.parseType();
        Location location = this.location();
        String memberName = this.readIdentifier();
        if (this.peekOperator("(")) {
            if (optionalDocComment == null) {
                this.warning("MDCM", "Method doc comment missing", this.location());
            }
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(classDeclaration, optionalDocComment, modifiers, memberType, memberName));
            return;
        }
        if (optionalDocComment == null) {
            this.warning("FDCM", "Field doc comment missing", this.location());
        }
        Java.FieldDeclaration fd = new Java.FieldDeclaration(location, optionalDocComment, modifiers, memberType, this.parseFieldDeclarationRest(memberName));
        this.readOperator(";");
        classDeclaration.addVariableDeclaratorOrInitializer(fd);
    }

    /*
     * WARNING - void declaration
     */
    public Java.InterfaceDeclaration parseInterfaceDeclarationRest(String optionalDocComment, short modifiers, InterfaceDeclarationContext context) throws ParseException, Scanner.ScanException, IOException {
        void var7_7;
        Java.InterfaceDeclaration interfaceDeclaration;
        Location location = this.location();
        String interfaceName = this.readIdentifier();
        this.verifyIdentifierIsConventionalClassOrInterfaceName(interfaceName, location);
        Java.Type[] extendedTypes = new Java.ReferenceType[]{};
        if (this.peekKeyword("extends")) {
            this.eatToken();
            extendedTypes = this.parseReferenceTypeList();
        }
        if (context == InterfaceDeclarationContext.COMPILATION_UNIT) {
            interfaceDeclaration = new Java.PackageMemberInterfaceDeclaration(location, optionalDocComment, modifiers, interfaceName, extendedTypes);
        } else if (context == InterfaceDeclarationContext.NAMED_TYPE_DECLARATION) {
            interfaceDeclaration = new Java.MemberInterfaceDeclaration(location, optionalDocComment, modifiers, interfaceName, extendedTypes);
        } else {
            throw new RuntimeException("SNO: Interface declaration in unexpected context " + context);
        }
        this.parseInterfaceBody((Java.InterfaceDeclaration)var7_7);
        return var7_7;
    }

    public void parseInterfaceBody(Java.InterfaceDeclaration interfaceDeclaration) throws ParseException, Scanner.ScanException, IOException {
        this.readOperator("{");
        while (true) {
            if (this.peekOperator("}")) break;
            if (this.peekOperator(";")) {
                this.eatToken();
                continue;
            }
            String optionalDocComment = this.scanner.doc();
            short modifiers = this.parseModifiersOpt();
            if (this.peekKeyword("void")) {
                if (optionalDocComment == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                Location location = this.location();
                this.eatToken();
                String name = this.readIdentifier();
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(interfaceDeclaration, optionalDocComment, (short)(modifiers | 0x400 | 1), new Java.BasicType(location, 0), name));
                continue;
            }
            if (this.peekKeyword("class")) {
                if (optionalDocComment == null) {
                    this.warning("MCDCM", "Member class doc comment missing", this.location());
                }
                this.eatToken();
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(optionalDocComment, (short)(modifiers | 8 | 1), ClassDeclarationContext.TYPE_DECLARATION)));
                continue;
            }
            if (this.peekKeyword("interface")) {
                if (optionalDocComment == null) {
                    this.warning("MIDCM", "Member interface doc comment missing", this.location());
                }
                this.eatToken();
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, (short)(modifiers | 8 | 1), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
                continue;
            }
            Java.Type memberType = this.parseType();
            if (!this.scanner.peek().isIdentifier()) {
                this.throwParseException("Identifier expected in member declaration");
            }
            Location location = this.location();
            String memberName = this.readIdentifier();
            if (this.peekOperator("(")) {
                if (optionalDocComment == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(interfaceDeclaration, optionalDocComment, (short)(modifiers | 0x400 | 1), memberType, memberName));
                continue;
            }
            if (optionalDocComment == null) {
                this.warning("FDCM", "Field doc comment missing", this.location());
            }
            Java.FieldDeclaration fd = new Java.FieldDeclaration(location, optionalDocComment, (short)(modifiers | 1 | 8 | 0x10), memberType, this.parseFieldDeclarationRest(memberName));
            interfaceDeclaration.addConstantDeclaration(fd);
        }
        this.eatToken();
    }

    public Java.ConstructorDeclarator parseConstructorDeclarator(Java.ClassDeclaration declaringClass, String optionalDocComment, short modifiers) throws ParseException, Scanner.ScanException, IOException {
        Java.Type[] thrownExceptions;
        Location location = this.location();
        this.readIdentifier();
        Java.FunctionDeclarator.FormalParameter[] formalParameters = this.parseFormalParameters(declaringClass);
        if (this.peekKeyword("throws")) {
            this.eatToken();
            thrownExceptions = this.parseReferenceTypeList();
        } else {
            thrownExceptions = new Java.ReferenceType[]{};
        }
        location = this.location();
        this.readOperator("{");
        Java.ConstructorInvocation optionalConstructorInvocation = null;
        Java.Block body = new Java.Block(location);
        if (this.peekKeyword(new String[]{"this", "super", "new", "void", "byte", "char", "short", "int", "long", "float", "double", "boolean"}) || this.scanner.peek().isLiteral() || this.scanner.peek().isIdentifier()) {
            Java.Atom a = this.parseExpression();
            if (a instanceof Java.ConstructorInvocation) {
                this.readOperator(";");
                optionalConstructorInvocation = (Java.ConstructorInvocation)a;
            } else {
                Java.Statement s;
                if (this.scanner.peek().isIdentifier()) {
                    Java.Type variableType = a.toTypeOrPE();
                    s = new Java.LocalVariableDeclarationStatement(a.getLocation(), 0, variableType, this.parseLocalVariableDeclarators());
                    this.readOperator(";");
                } else {
                    s = new Java.ExpressionStatement(a.toRvalueOrPE());
                    this.readOperator(";");
                }
                body.addStatement(s);
            }
        }
        body.addStatements(this.parseBlockStatements());
        this.readOperator("}");
        return new Java.ConstructorDeclarator(location, optionalDocComment, modifiers, formalParameters, thrownExceptions, optionalConstructorInvocation, body);
    }

    public Java.MethodDeclarator parseMethodDeclarationRest(Java.AbstractTypeDeclaration declaringType, String optionalDocComment, short modifiers, Java.Type type, String name) throws ParseException, Scanner.ScanException, IOException {
        Java.Block optionalBody;
        Java.Type[] thrownExceptions;
        Location location = this.location();
        this.verifyIdentifierIsConventionalMethodName(name, location);
        Java.FunctionDeclarator.FormalParameter[] formalParameters = this.parseFormalParameters(declaringType);
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            type = new Java.ArrayType(type);
        }
        if (this.peekKeyword("throws")) {
            this.eatToken();
            thrownExceptions = this.parseReferenceTypeList();
        } else {
            thrownExceptions = new Java.ReferenceType[]{};
        }
        if (this.peekOperator(";")) {
            if ((modifiers & 0x500) == 0) {
                this.throwParseException("Non-abstract, non-native method must have a body");
            }
            this.eatToken();
            optionalBody = null;
        } else {
            if ((modifiers & 0x500) != 0) {
                this.throwParseException("Abstract or native method must not have a body");
            }
            optionalBody = this.parseMethodBody();
        }
        return new Java.MethodDeclarator(location, optionalDocComment, modifiers, type, name, formalParameters, thrownExceptions, optionalBody);
    }

    public Java.ArrayInitializerOrRvalue parseVariableInitializer() throws ParseException, Scanner.ScanException, IOException {
        if (this.peekOperator("{")) {
            return this.parseArrayInitializer();
        }
        return this.parseExpression().toRvalueOrPE();
    }

    public Java.ArrayInitializer parseArrayInitializer() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readOperator("{");
        ArrayList<Java.ArrayInitializerOrRvalue> l = new ArrayList<Java.ArrayInitializerOrRvalue>();
        while (!this.peekOperator("}")) {
            l.add(this.parseVariableInitializer());
            if (this.peekOperator("}")) break;
            if (!this.peekOperator(",")) {
                this.throwParseException("\",\" or \"}\" expected");
            }
            this.eatToken();
        }
        this.eatToken();
        return new Java.ArrayInitializer(location, l.toArray(new Java.ArrayInitializerOrRvalue[l.size()]));
    }

    public Java.FunctionDeclarator.FormalParameter[] parseFormalParameters(Java.Scope enclosingScope) throws ParseException, Scanner.ScanException, IOException {
        this.readOperator("(");
        if (this.peekOperator(")")) {
            this.eatToken();
            return new Java.FunctionDeclarator.FormalParameter[0];
        }
        ArrayList<Java.FunctionDeclarator.FormalParameter> l = new ArrayList<Java.FunctionDeclarator.FormalParameter>();
        while (true) {
            l.add(this.parseFormalParameter());
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        this.readOperator(")");
        return l.toArray(new Java.FunctionDeclarator.FormalParameter[l.size()]);
    }

    public Java.FunctionDeclarator.FormalParameter parseFormalParameter() throws ParseException, Scanner.ScanException, IOException {
        boolean finaL = this.peekKeyword("final");
        if (finaL) {
            this.eatToken();
        }
        Java.Type type = this.parseType();
        Location location = this.location();
        String name = this.readIdentifier();
        this.verifyIdentifierIsConventionalLocalVariableOrParameterName(name, location);
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            type = new Java.ArrayType(type);
        }
        return new Java.FunctionDeclarator.FormalParameter(location, finaL, type, name);
    }

    int parseBracketsOpt() throws Scanner.ScanException, IOException {
        int res = 0;
        while (this.scanner.peek().isOperator("[") && this.scanner.peekNextButOne().isOperator("]")) {
            this.eatToken();
            this.eatToken();
            ++res;
        }
        return res;
    }

    public Java.Block parseMethodBody() throws ParseException, Scanner.ScanException, IOException {
        return this.parseBlock();
    }

    public Java.Block parseBlock() throws ParseException, Scanner.ScanException, IOException {
        Java.Block block = new Java.Block(this.location());
        this.readOperator("{");
        block.addStatements(this.parseBlockStatements());
        this.readOperator("}");
        return block;
    }

    public List parseBlockStatements() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.BlockStatement> l = new ArrayList<Java.BlockStatement>();
        while (!(this.peekOperator("}") || this.peekKeyword("case") || this.peekKeyword("default"))) {
            l.add(this.parseBlockStatement());
        }
        return l;
    }

    public Java.BlockStatement parseBlockStatement() throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isIdentifier() && this.scanner.peekNextButOne().isOperator(":") || this.peekKeyword(new String[]{"if", "for", "while", "do", "try", "switch", "synchronized", "return", "throw", "break", "continue"}) || this.peekOperator(new String[]{"{", ";"})) {
            return this.parseStatement();
        }
        if (this.peekKeyword("class")) {
            String optionalDocComment = this.scanner.doc();
            if (optionalDocComment == null) {
                this.warning("LCDCM", "Local class doc comment missing", this.location());
            }
            this.eatToken();
            Java.LocalClassDeclaration lcd = (Java.LocalClassDeclaration)this.parseClassDeclarationRest(optionalDocComment, (short)18, ClassDeclarationContext.BLOCK);
            return new Java.LocalClassDeclarationStatement(lcd);
        }
        if (this.peekKeyword("final")) {
            Location location = this.location();
            this.eatToken();
            Java.Type variableType = this.parseType();
            Java.LocalVariableDeclarationStatement lvds = new Java.LocalVariableDeclarationStatement(location, 16, variableType, this.parseLocalVariableDeclarators());
            this.readOperator(";");
            return lvds;
        }
        Java.Atom a = this.parseExpression();
        if (this.peekOperator(";")) {
            this.eatToken();
            return new Java.ExpressionStatement(a.toRvalueOrPE());
        }
        Java.Type variableType = a.toTypeOrPE();
        Java.LocalVariableDeclarationStatement lvds = new Java.LocalVariableDeclarationStatement(a.getLocation(), 0, variableType, this.parseLocalVariableDeclarators());
        this.readOperator(";");
        return lvds;
    }

    public Java.VariableDeclarator[] parseLocalVariableDeclarators() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.VariableDeclarator> l = new ArrayList<Java.VariableDeclarator>();
        while (true) {
            Java.VariableDeclarator vd = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalLocalVariableOrParameterName(vd.name, vd.getLocation());
            l.add(vd);
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        return l.toArray(new Java.VariableDeclarator[l.size()]);
    }

    public Java.VariableDeclarator[] parseFieldDeclarationRest(String name) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.VariableDeclarator> l = new ArrayList<Java.VariableDeclarator>();
        Java.VariableDeclarator vd = this.parseVariableDeclaratorRest(name);
        this.verifyIdentifierIsConventionalFieldName(vd.name, vd.getLocation());
        l.add(vd);
        while (this.peekOperator(",")) {
            this.eatToken();
            vd = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalFieldName(vd.name, vd.getLocation());
            l.add(vd);
        }
        return l.toArray(new Java.VariableDeclarator[l.size()]);
    }

    public Java.VariableDeclarator parseVariableDeclarator() throws ParseException, Scanner.ScanException, IOException {
        return this.parseVariableDeclaratorRest(this.readIdentifier());
    }

    public Java.VariableDeclarator parseVariableDeclaratorRest(String name) throws ParseException, Scanner.ScanException, IOException {
        Location loc = this.location();
        int brackets = this.parseBracketsOpt();
        Java.ArrayInitializerOrRvalue initializer = null;
        if (this.peekOperator("=")) {
            this.eatToken();
            initializer = this.parseVariableInitializer();
        }
        return new Java.VariableDeclarator(loc, name, brackets, initializer);
    }

    public Java.Statement parseStatement() throws ParseException, Scanner.ScanException, IOException {
        Java.Block stmt;
        if (this.scanner.peek().isIdentifier() && this.scanner.peekNextButOne().isOperator(":")) {
            return this.parseLabeledStatement();
        }
        Scanner.Token t = this.scanner.peek();
        Java.Statement statement = t.isOperator("{") ? this.parseBlock() : (t.isKeyword("if") ? this.parseIfStatement() : (t.isKeyword("for") ? this.parseForStatement() : (t.isKeyword("while") ? this.parseWhileStatement() : (t.isKeyword("do") ? this.parseDoStatement() : (t.isKeyword("try") ? this.parseTryStatement() : (t.isKeyword("switch") ? this.parseSwitchStatement() : (t.isKeyword("synchronized") ? this.parseSynchronizedStatement() : (t.isKeyword("return") ? this.parseReturnStatement() : (t.isKeyword("throw") ? this.parseThrowStatement() : (t.isKeyword("break") ? this.parseBreakStatement() : (t.isKeyword("continue") ? this.parseContinueStatement() : (stmt = t.isOperator(";") ? this.parseEmptyStatement() : this.parseExpressionStatement()))))))))))));
        if (stmt == null) {
            this.throwParseException("\"" + t.getKeyword() + "\" NYI");
        }
        return stmt;
    }

    public Java.Statement parseLabeledStatement() throws ParseException, Scanner.ScanException, IOException {
        String label = this.readIdentifier();
        this.readOperator(":");
        return new Java.LabeledStatement(this.location(), label, this.parseStatement());
    }

    public Java.Statement parseIfStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("if");
        this.readOperator("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        Java.Statement thenStatement = this.parseStatement();
        Java.Statement optionalElseStatement = null;
        if (this.peekKeyword("else")) {
            this.eatToken();
            optionalElseStatement = this.parseStatement();
        }
        return new Java.IfStatement(location, condition, thenStatement, optionalElseStatement);
    }

    public Java.Statement parseForStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("for");
        this.readOperator("(");
        Java.BlockStatement optionalInit = null;
        if (!this.peekOperator(";")) {
            optionalInit = this.parseForInit();
        }
        this.readOperator(";");
        Java.Rvalue optionalCondition = null;
        if (!this.peekOperator(";")) {
            optionalCondition = this.parseExpression().toRvalueOrPE();
        }
        this.readOperator(";");
        Java.Rvalue[] optionalUpdate = null;
        if (!this.peekOperator(")")) {
            optionalUpdate = this.parseExpressionList();
        }
        this.readOperator(")");
        return new Java.ForStatement(location, optionalInit, optionalCondition, optionalUpdate, this.parseStatement());
    }

    private Java.BlockStatement parseForInit() throws ParseException, Scanner.ScanException, IOException {
        if (this.peekKeyword(new String[]{"final", "byte", "short", "char", "int", "long", "float", "double", "boolean"})) {
            short modifiers = this.parseModifiersOpt();
            Java.Type variableType = this.parseType();
            return new Java.LocalVariableDeclarationStatement(this.location(), modifiers, variableType, this.parseLocalVariableDeclarators());
        }
        Java.Atom a = this.parseExpression();
        if (this.scanner.peek().isIdentifier()) {
            Java.Type variableType = a.toTypeOrPE();
            return new Java.LocalVariableDeclarationStatement(a.getLocation(), 0, variableType, this.parseLocalVariableDeclarators());
        }
        if (!this.peekOperator(",")) {
            return new Java.ExpressionStatement(a.toRvalueOrPE());
        }
        this.eatToken();
        ArrayList<Java.ExpressionStatement> l = new ArrayList<Java.ExpressionStatement>();
        l.add(new Java.ExpressionStatement(a.toRvalueOrPE()));
        while (true) {
            l.add(new Java.ExpressionStatement(this.parseExpression().toRvalueOrPE()));
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        Java.Block b = new Java.Block(a.getLocation());
        b.addStatements(l);
        return b;
    }

    public Java.Statement parseWhileStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("while");
        this.readOperator("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        return new Java.WhileStatement(location, condition, this.parseStatement());
    }

    public Java.Statement parseDoStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("do");
        Java.Statement body = this.parseStatement();
        this.readKeyword("while");
        this.readOperator("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        this.readOperator(";");
        return new Java.DoStatement(location, body, condition);
    }

    public Java.Statement parseTryStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("try");
        Java.Block body = this.parseBlock();
        ArrayList<Java.CatchClause> ccs = new ArrayList<Java.CatchClause>();
        while (this.peekKeyword("catch")) {
            Location loc = this.location();
            this.eatToken();
            this.readOperator("(");
            Java.FunctionDeclarator.FormalParameter caughtException = this.parseFormalParameter();
            this.readOperator(")");
            ccs.add(new Java.CatchClause(loc, caughtException, this.parseBlock()));
        }
        Java.Block optionalFinally = null;
        if (this.peekKeyword("finally")) {
            this.eatToken();
            optionalFinally = this.parseBlock();
        }
        if (ccs.size() == 0 && optionalFinally == null) {
            this.throwParseException("\"try\" statement must have at least one \"catch\" clause or a \"finally\" clause");
        }
        return new Java.TryStatement(location, body, ccs, optionalFinally);
    }

    public Java.Statement parseSwitchStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("switch");
        this.readOperator("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        this.readOperator("{");
        ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup> sbsgs = new ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup>();
        while (!this.peekOperator("}")) {
            Location location2 = this.location();
            boolean hasDefaultLabel = false;
            ArrayList<Java.Rvalue> caseLabels = new ArrayList<Java.Rvalue>();
            do {
                if (this.peekKeyword("case")) {
                    this.eatToken();
                    caseLabels.add(this.parseExpression().toRvalueOrPE());
                } else if (this.peekKeyword("default")) {
                    this.eatToken();
                    if (hasDefaultLabel) {
                        this.throwParseException("Duplicate \"default\" label");
                    }
                    hasDefaultLabel = true;
                } else {
                    this.throwParseException("\"case\" or \"default\" expected");
                }
                this.readOperator(":");
            } while (this.peekKeyword(new String[]{"case", "default"}));
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = new Java.SwitchStatement.SwitchBlockStatementGroup(location2, caseLabels, hasDefaultLabel, this.parseBlockStatements());
            sbsgs.add(sbsg);
        }
        this.eatToken();
        return new Java.SwitchStatement(location, condition, sbsgs);
    }

    public Java.Statement parseSynchronizedStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("synchronized");
        this.readOperator("(");
        Java.Rvalue expression = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        return new Java.SynchronizedStatement(location, expression, this.parseBlock());
    }

    public Java.Statement parseReturnStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("return");
        Java.Rvalue returnValue = this.peekOperator(";") ? null : this.parseExpression().toRvalueOrPE();
        this.readOperator(";");
        return new Java.ReturnStatement(location, returnValue);
    }

    public Java.Statement parseThrowStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("throw");
        Java.Rvalue expression = this.parseExpression().toRvalueOrPE();
        this.readOperator(";");
        return new Java.ThrowStatement(location, expression);
    }

    public Java.Statement parseBreakStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("break");
        String optionalLabel = null;
        if (this.scanner.peek().isIdentifier()) {
            optionalLabel = this.readIdentifier();
        }
        this.readOperator(";");
        return new Java.BreakStatement(location, optionalLabel);
    }

    public Java.Statement parseContinueStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("continue");
        String optionalLabel = null;
        if (this.scanner.peek().isIdentifier()) {
            optionalLabel = this.readIdentifier();
        }
        this.readOperator(";");
        return new Java.ContinueStatement(location, optionalLabel);
    }

    public Java.Statement parseEmptyStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readOperator(";");
        return new Java.EmptyStatement(location);
    }

    public Java.Rvalue[] parseExpressionList() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        while (true) {
            l.add(this.parseExpression().toRvalueOrPE());
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Type parseType() throws ParseException, Scanner.ScanException, IOException {
        Java.Type res;
        Scanner.Token t = this.scanner.peek();
        int bt = -1;
        if (t.isKeyword("byte")) {
            bt = 1;
        } else if (t.isKeyword("short")) {
            bt = 2;
        } else if (t.isKeyword("char")) {
            bt = 3;
        } else if (t.isKeyword("int")) {
            bt = 4;
        } else if (t.isKeyword("long")) {
            bt = 5;
        } else if (t.isKeyword("float")) {
            bt = 6;
        } else if (t.isKeyword("double")) {
            bt = 7;
        } else if (t.isKeyword("boolean")) {
            bt = 8;
        }
        if (bt != -1) {
            res = new Java.BasicType(t.getLocation(), bt);
            this.eatToken();
        } else {
            res = this.parseReferenceType();
        }
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            res = new Java.ArrayType(res);
        }
        return res;
    }

    public Java.ReferenceType parseReferenceType() throws ParseException, Scanner.ScanException, IOException {
        return new Java.ReferenceType(this.location(), this.parseQualifiedIdentifier());
    }

    public Java.ReferenceType[] parseReferenceTypeList() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.ReferenceType> l = new ArrayList<Java.ReferenceType>();
        l.add(this.parseReferenceType());
        while (this.peekOperator(",")) {
            this.eatToken();
            l.add(this.parseReferenceType());
        }
        return l.toArray(new Java.ReferenceType[l.size()]);
    }

    public Java.Atom parseExpression() throws ParseException, Scanner.ScanException, IOException {
        return this.parseAssignmentExpression();
    }

    public Java.Atom parseAssignmentExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseConditionalExpression();
        if (this.peekOperator(new String[]{"=", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="})) {
            Location location = this.location();
            String operator = this.readOperator();
            Java.Lvalue lhs = a.toLvalueOrPE();
            Java.Rvalue rhs = this.parseAssignmentExpression().toRvalueOrPE();
            return new Java.Assignment(location, lhs, operator, rhs);
        }
        return a;
    }

    public Java.Atom parseConditionalExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseConditionalOrExpression();
        if (!this.peekOperator("?")) {
            return a;
        }
        Location location = this.location();
        this.eatToken();
        Java.Rvalue lhs = a.toRvalueOrPE();
        Java.Rvalue mhs = this.parseExpression().toRvalueOrPE();
        this.readOperator(":");
        Java.Rvalue rhs = this.parseConditionalExpression().toRvalueOrPE();
        return new Java.ConditionalExpression(location, lhs, mhs, rhs);
    }

    public Java.Atom parseConditionalOrExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseConditionalAndExpression();
        while (this.peekOperator("||")) {
            Location location = this.location();
            this.eatToken();
            a = new Java.BinaryOperation(location, a.toRvalueOrPE(), "||", this.parseConditionalAndExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseConditionalAndExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseInclusiveOrExpression();
        while (this.peekOperator("&&")) {
            Location location = this.location();
            this.eatToken();
            a = new Java.BinaryOperation(location, a.toRvalueOrPE(), "&&", this.parseInclusiveOrExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseInclusiveOrExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseExclusiveOrExpression();
        while (this.peekOperator("|")) {
            Location location = this.location();
            this.eatToken();
            a = new Java.BinaryOperation(location, a.toRvalueOrPE(), "|", this.parseExclusiveOrExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseExclusiveOrExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseAndExpression();
        while (this.peekOperator("^")) {
            Location location = this.location();
            this.eatToken();
            a = new Java.BinaryOperation(location, a.toRvalueOrPE(), "^", this.parseAndExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseAndExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseEqualityExpression();
        while (this.peekOperator("&")) {
            Location location = this.location();
            this.eatToken();
            a = new Java.BinaryOperation(location, a.toRvalueOrPE(), "&", this.parseEqualityExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseEqualityExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseRelationalExpression();
        while (this.peekOperator(new String[]{"==", "!="})) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrPE(), this.readOperator(), this.parseRelationalExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseRelationalExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseShiftExpression();
        while (true) {
            if (this.peekKeyword("instanceof")) {
                Location location = this.location();
                this.eatToken();
                a = new Java.Instanceof(location, a.toRvalueOrPE(), this.parseType());
                continue;
            }
            if (!this.peekOperator(new String[]{"<", ">", "<=", ">="})) break;
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrPE(), this.readOperator(), this.parseShiftExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseShiftExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseAdditiveExpression();
        while (this.peekOperator(new String[]{"<<", ">>", ">>>"})) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrPE(), this.readOperator(), this.parseAdditiveExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseAdditiveExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseMultiplicativeExpression();
        while (this.peekOperator(new String[]{"+", "-"})) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrPE(), this.readOperator(), this.parseMultiplicativeExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseMultiplicativeExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom a = this.parseUnaryExpression();
        while (this.peekOperator(new String[]{"*", "/", "%"})) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrPE(), this.readOperator(), this.parseUnaryExpression().toRvalueOrPE());
        }
        return a;
    }

    public Java.Atom parseUnaryExpression() throws ParseException, Scanner.ScanException, IOException {
        if (this.peekOperator(new String[]{"++", "--"})) {
            return new Java.Crement(this.location(), this.readOperator(), this.parseUnaryExpression().toLvalueOrPE());
        }
        if (this.peekOperator(new String[]{"+", "-", "~", "!"})) {
            return new Java.UnaryOperation(this.location(), this.readOperator(), this.parseUnaryExpression().toRvalueOrPE());
        }
        Java.Atom a = this.parsePrimary();
        while (this.peekOperator(new String[]{".", "["})) {
            a = this.parseSelector(a);
        }
        while (this.peekOperator(new String[]{"++", "--"})) {
            a = new Java.Crement(this.location(), a.toLvalueOrPE(), this.readOperator());
        }
        return a;
    }

    public Java.Atom parsePrimary() throws ParseException, Scanner.ScanException, IOException {
        Location location;
        if (this.peekOperator("(")) {
            this.eatToken();
            if (this.peekKeyword(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"})) {
                Java.Type type = this.parseType();
                int brackets = this.parseBracketsOpt();
                this.readOperator(")");
                for (int i = 0; i < brackets; ++i) {
                    type = new Java.ArrayType(type);
                }
                return new Java.Cast(this.location(), type, this.parseUnaryExpression().toRvalueOrPE());
            }
            Java.Atom a = this.parseExpression();
            this.readOperator(")");
            if (this.scanner.peek().isLiteral() || this.scanner.peek().isIdentifier() || this.peekOperator(new String[]{"(", "~", "!"}) || this.peekKeyword(new String[]{"this", "super", "new"})) {
                return new Java.Cast(this.location(), a.toTypeOrPE(), this.parseUnaryExpression().toRvalueOrPE());
            }
            return new Java.ParenthesizedExpression(a.getLocation(), a.toRvalueOrPE());
        }
        if (this.scanner.peek().isLiteral()) {
            return this.parseLiteral();
        }
        if (this.scanner.peek().isIdentifier()) {
            Location location2 = this.location();
            String[] qi = this.parseQualifiedIdentifier();
            if (this.peekOperator("(")) {
                return new Java.MethodInvocation(this.location(), qi.length == 1 ? null : new Java.AmbiguousName(location2, qi, qi.length - 1), qi[qi.length - 1], this.parseArguments());
            }
            if (this.peekOperator("[") && this.scanner.peekNextButOne().isOperator("]")) {
                Java.Type res = new Java.ReferenceType(location2, qi);
                int brackets = this.parseBracketsOpt();
                for (int i = 0; i < brackets; ++i) {
                    res = new Java.ArrayType(res);
                }
                if (this.peekOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                    this.eatToken();
                    Location location22 = this.location();
                    this.eatToken();
                    return new Java.ClassLiteral(location22, res);
                }
                return res;
            }
            return new Java.AmbiguousName(this.location(), qi);
        }
        if (this.peekKeyword("this")) {
            Location location3 = this.location();
            this.eatToken();
            if (this.peekOperator("(")) {
                return new Java.AlternateConstructorInvocation(location3, this.parseArguments());
            }
            return new Java.ThisReference(location3);
        }
        if (this.peekKeyword("super")) {
            this.eatToken();
            if (this.peekOperator("(")) {
                return new Java.SuperConstructorInvocation(this.location(), null, this.parseArguments());
            }
            this.readOperator(".");
            String name = this.readIdentifier();
            if (this.peekOperator("(")) {
                return new Java.SuperclassMethodInvocation(this.location(), name, this.parseArguments());
            }
            this.throwParseException("Superclass field access NYI");
        }
        if (this.peekKeyword("new")) {
            location = this.location();
            this.eatToken();
            Java.Type type = this.parseType();
            if (type instanceof Java.ArrayType) {
                return new Java.NewInitializedArray(location, (Java.ArrayType)type, this.parseArrayInitializer());
            }
            if (type instanceof Java.ReferenceType && this.peekOperator("(")) {
                Java.Rvalue[] arguments = this.parseArguments();
                if (this.peekOperator("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location, null, anonymousClassDeclaration, arguments);
                }
                return new Java.NewClassInstance(location, (Java.Rvalue)null, type, arguments);
            }
            return new Java.NewArray(location, type, this.parseDimExprs(), this.parseBracketsOpt());
        }
        if (this.peekKeyword(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"})) {
            Java.Type res = this.parseType();
            int brackets = this.parseBracketsOpt();
            for (int i = 0; i < brackets; ++i) {
                res = new Java.ArrayType(res);
            }
            if (this.peekOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                this.eatToken();
                Location location4 = this.location();
                this.eatToken();
                return new Java.ClassLiteral(location4, res);
            }
            return res;
        }
        if (this.peekKeyword("void")) {
            this.eatToken();
            if (this.peekOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                this.eatToken();
                location = this.location();
                this.eatToken();
                return new Java.ClassLiteral(location, new Java.BasicType(location, 0));
            }
            this.throwParseException("\"void\" encountered in wrong context");
        }
        this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in primary");
        return null;
    }

    public Java.Atom parseSelector(Java.Atom atom) throws ParseException, Scanner.ScanException, IOException {
        Location location;
        if (this.peekOperator(".")) {
            this.eatToken();
            if (this.scanner.peek().isIdentifier()) {
                String identifier = this.readIdentifier();
                if (this.peekOperator("(")) {
                    return new Java.MethodInvocation(this.location(), atom.toRvalueOrPE(), identifier, this.parseArguments());
                }
                return new Java.FieldAccessExpression(this.location(), atom.toRvalueOrPE(), identifier);
            }
            if (this.peekKeyword("this")) {
                Location location2 = this.location();
                this.eatToken();
                return new Java.QualifiedThisReference(location2, atom.toTypeOrPE());
            }
            if (this.peekKeyword("super")) {
                location = this.location();
                this.eatToken();
                if (this.peekOperator("(")) {
                    return new Java.SuperConstructorInvocation(location, atom.toRvalueOrPE(), this.parseArguments());
                }
                this.readOperator(".");
                this.readIdentifier();
                if (this.peekOperator("(")) {
                    this.throwParseException("Qualified superclass method invocation NYI");
                } else {
                    this.throwParseException("Qualified superclass field access NYI");
                }
            }
            if (this.peekKeyword("new")) {
                Java.Rvalue lhs = atom.toRvalue();
                Location location3 = this.location();
                this.eatToken();
                String identifier = this.readIdentifier();
                Java.RvalueMemberType type = new Java.RvalueMemberType(location3, lhs, identifier);
                Java.Rvalue[] arguments = this.parseArguments();
                if (this.peekOperator("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location3, lhs, anonymousClassDeclaration, arguments);
                }
                return new Java.NewClassInstance(location3, lhs, type, arguments);
            }
            if (this.peekKeyword("class")) {
                location = this.location();
                this.eatToken();
                return new Java.ClassLiteral(location, atom.toTypeOrPE());
            }
            this.throwParseException("Unexpected selector \"" + this.scanner.peek() + "\" after \".\"");
        }
        if (this.peekOperator("[")) {
            location = this.location();
            this.eatToken();
            Java.Rvalue index = this.parseExpression().toRvalueOrPE();
            this.readOperator("]");
            return new Java.ArrayAccessExpression(location, atom.toRvalueOrPE(), index);
        }
        this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in selector");
        return null;
    }

    public Java.Rvalue[] parseDimExprs() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        l.add(this.parseDimExpr());
        while (this.peekOperator("[") && !this.scanner.peekNextButOne().isOperator("]")) {
            l.add(this.parseDimExpr());
        }
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Rvalue parseDimExpr() throws Scanner.ScanException, ParseException, IOException {
        this.readOperator("[");
        Java.Rvalue res = this.parseExpression().toRvalueOrPE();
        this.readOperator("]");
        return res;
    }

    public Java.Rvalue[] parseArguments() throws ParseException, Scanner.ScanException, IOException {
        this.readOperator("(");
        if (this.peekOperator(")")) {
            this.eatToken();
            return new Java.Rvalue[0];
        }
        Java.Rvalue[] arguments = this.parseArgumentList();
        this.readOperator(")");
        return arguments;
    }

    public Java.Rvalue[] parseArgumentList() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        while (true) {
            l.add(this.parseExpression().toRvalueOrPE());
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Atom parseLiteral() throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token t = this.scanner.read();
        if (!t.isLiteral()) {
            this.throwParseException("Literal expected");
        }
        return new Java.Literal(t.getLocation(), t.getLiteralValue());
    }

    public Location location() {
        return this.scanner.location();
    }

    public void eatToken() throws Scanner.ScanException, IOException {
        this.scanner.read();
    }

    public boolean peekKeyword() {
        return this.scanner.peek().isKeyword();
    }

    public boolean peekKeyword(String keyword) {
        return this.scanner.peek().isKeyword(keyword);
    }

    public boolean peekKeyword(String[] keywords) {
        return this.scanner.peek().isKeyword(keywords);
    }

    public void readKeyword(String keyword) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.read().isKeyword(keyword)) {
            this.throwParseException("\"" + keyword + "\" expected");
        }
    }

    public boolean peekOperator(String operator) {
        return this.scanner.peek().isOperator(operator);
    }

    public boolean peekOperator(String[] operators) {
        return this.scanner.peek().isOperator(operators);
    }

    public String readOperator() throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token t = this.scanner.read();
        if (!t.isOperator()) {
            this.throwParseException("Operator expected");
        }
        return t.getOperator();
    }

    public void readOperator(String operator) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.read().isOperator(operator)) {
            this.throwParseException("Operator \"" + operator + "\" expected");
        }
    }

    public boolean peekIdentifier() {
        return this.scanner.peek().isIdentifier();
    }

    public String readIdentifier() throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token t = this.scanner.read();
        if (!t.isIdentifier()) {
            this.throwParseException("Identifier expected");
        }
        return t.getIdentifier();
    }

    public Java.Statement parseExpressionStatement() throws ParseException, Scanner.ScanException, IOException {
        Java.Rvalue rv = this.parseExpression().toRvalueOrPE();
        this.readOperator(";");
        return new Java.ExpressionStatement(rv);
    }

    private void verifyStringIsConventionalPackageName(String s, Location loc) {
        if (!Character.isLowerCase(s.charAt(0))) {
            this.warning("UPN", "Package name \"" + s + "\" does not begin with a lower-case letter (see JLS2 6.8.1)", loc);
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLowerCase(c) || c == '_' || c == '.') continue;
            this.warning("PPN", "Poorly chosen package name \"" + s + "\" contains bad character '" + c + "'", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalClassOrInterfaceName(String id, Location loc) {
        if (!Character.isUpperCase(id.charAt(0))) {
            this.warning("UCOIN1", "Class or interface name \"" + id + "\" does not begin with an upper-case letter (see JLS2 6.8.2)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("UCOIN", "Class or interface name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.2)", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalMethodName(String id, Location loc) {
        if (!Character.isLowerCase(id.charAt(0))) {
            this.warning("UMN1", "Method name \"" + id + "\" does not begin with a lower-case letter (see JLS2 6.8.3)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("UMN", "Method name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.3)", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalFieldName(String id, Location loc) {
        if (Character.isUpperCase(id.charAt(0))) {
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isUpperCase(c) || Character.isDigit(c) || c == '_') continue;
                this.warning("UCN", "Constant name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.5)", loc);
                return;
            }
        } else if (Character.isLowerCase(id.charAt(0))) {
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c)) continue;
                this.warning("UFN", "Field name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.4)", loc);
                return;
            }
        } else {
            this.warning("UFN1", "\"" + id + "\" is neither a conventional field name (JLS2 6.8.4) nor a conventional constant name (JLS2 6.8.5)", loc);
        }
    }

    private void verifyIdentifierIsConventionalLocalVariableOrParameterName(String id, Location loc) {
        if (!Character.isLowerCase(id.charAt(0))) {
            this.warning("ULVN1", "Local variable name \"" + id + "\" does not begin with a lower-case letter (see JLS2 6.8.6)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("ULVN", "Local variable name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.6)", loc);
            return;
        }
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    private void warning(String handle, String message, Location optionalLocation) {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    protected final void throwParseException(String message) throws ParseException {
        throw new ParseException(message, this.location());
    }

    private static String join(String[] sa, String separator) {
        if (sa == null) {
            return "(null)";
        }
        if (sa.length == 0) {
            return "(zero length array)";
        }
        StringBuffer sb = new StringBuffer(sa[0]);
        for (int i = 1; i < sa.length; ++i) {
            sb.append(separator).append(sa[i]);
        }
        return sb.toString();
    }

    public static class ParseException
    extends Scanner.LocatedException {
        ParseException(String message, Location location) {
            super(message, location);
        }
    }

    private static class InterfaceDeclarationContext
    extends Enumerator {
        public static final InterfaceDeclarationContext NAMED_TYPE_DECLARATION = new InterfaceDeclarationContext("named_type_declaration");
        public static final InterfaceDeclarationContext COMPILATION_UNIT = new InterfaceDeclarationContext("compilation_unit");

        private InterfaceDeclarationContext(String name) {
            super(name);
        }
    }

    private static class ClassDeclarationContext
    extends Enumerator {
        public static final ClassDeclarationContext BLOCK = new ClassDeclarationContext("block");
        public static final ClassDeclarationContext TYPE_DECLARATION = new ClassDeclarationContext("type_declaration");
        public static final ClassDeclarationContext COMPILATION_UNIT = new ClassDeclarationContext("compilation_unit");

        private ClassDeclarationContext(String name) {
            super(name);
        }
    }
}

