/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.UnsupportedEncodingException;
import tcl.lang.CharPointer;
import tcl.lang.InternalRep;
import tcl.lang.StringCmd;
import tcl.lang.TclRuntimeError;

class UTF8CharPointer
extends CharPointer
implements InternalRep {
    int[] charToByteIndex;
    int[] byteToCharIndex;
    byte[] bytes;
    String orig;

    UTF8CharPointer(String s) {
        super(s);
        this.orig = s;
        this.getByteInfo();
    }

    void getByteInfo() {
        try {
            int charIndex;
            int bytesThisChar;
            char c;
            boolean singleBytes = true;
            for (int i = 0; i < this.array.length; ++i) {
                c = this.array[i];
                bytesThisChar = c == '\u0000' ? 1 : StringCmd.Utf8Count(c);
                if (bytesThisChar == 1) continue;
                singleBytes = false;
                break;
            }
            if (singleBytes) {
                this.bytes = null;
                return;
            }
            String chars = new String(this.array);
            this.bytes = chars.getBytes("UTF8");
            if (chars == null) {
                System.out.println("chars is \"" + chars + "\" len = " + chars.length());
                String bstr = new String(this.bytes, 0, this.bytes.length, "UTF8");
                System.out.println("bytes is \"" + bstr + "\" len = " + this.bytes.length);
            }
            this.charToByteIndex = new int[this.array.length];
            int byteIndex = 0;
            for (charIndex = 0; charIndex < this.charToByteIndex.length; ++charIndex) {
                this.charToByteIndex[charIndex] = byteIndex;
                c = this.array[charIndex];
                bytesThisChar = c == '\u0000' ? 1 : StringCmd.Utf8Count(c);
                byteIndex += bytesThisChar;
            }
            int bytesTotal = byteIndex;
            if (this.bytes.length != bytesTotal) {
                throw new TclRuntimeError("generated " + this.bytes.length + " but expected to generate " + bytesTotal + " bytes");
            }
            this.byteToCharIndex = new int[this.bytes.length];
            charIndex = 0;
            byteIndex = 0;
            bytesThisChar = 0;
            while (byteIndex < this.byteToCharIndex.length) {
                if (byteIndex <= 0 || bytesThisChar == 0) {
                    // empty if block
                }
                this.byteToCharIndex[byteIndex] = ++charIndex;
                c = this.array[charIndex];
                if (bytesThisChar == 0) {
                    bytesThisChar = c == '\u0000' ? 1 : StringCmd.Utf8Count(c);
                }
                ++byteIndex;
                --bytesThisChar;
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new TclRuntimeError("UTF8 encoding not supported");
        }
    }

    String getByteRangeAsString(int byteIndex, int byteLength) {
        if (this.bytes == null) {
            return this.orig.substring(byteIndex, byteIndex + byteLength);
        }
        try {
            return new String(this.bytes, byteIndex, byteLength, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new TclRuntimeError("UTF8 encoding not supported");
        }
    }

    int getByteIndex(int charIndex) {
        if (this.bytes == null) {
            return charIndex;
        }
        return this.charToByteIndex[charIndex];
    }

    int getByteRange(int charIndex, int charRange) {
        if (this.bytes == null) {
            return charRange;
        }
        return this.charToByteIndex[charIndex + charRange] - this.charToByteIndex[charIndex];
    }

    int getBytesAtIndex(int charIndex) {
        if (this.bytes == null) {
            return 1;
        }
        return this.charToByteIndex[charIndex + 1] - this.charToByteIndex[charIndex];
    }

    int getByteLength() {
        if (this.bytes == null) {
            return this.orig.length();
        }
        return this.bytes.length - 1;
    }

    int getCharIndex(int byteIndex) {
        if (this.bytes == null) {
            return byteIndex;
        }
        return this.byteToCharIndex[byteIndex];
    }

    int getCharRange(int byteIndex, int byteRange) {
        if (this.bytes == null) {
            return byteRange;
        }
        return this.byteToCharIndex[byteIndex + byteRange] - this.byteToCharIndex[byteIndex];
    }

    public String toString() {
        int i;
        if (this.bytes == null) {
            return "1 byte for each character with length " + this.orig.length();
        }
        StringBuffer sb = new StringBuffer();
        int max_byte = this.bytes.length - 1;
        int max_char = this.array.length - 1;
        int max = max_char;
        if (max_byte > max) {
            max = max_byte;
        }
        sb.append("index char/byte array: (sizes = " + max_char + " " + max_byte + ")\n");
        for (i = 0; i < max; ++i) {
            String char_ind = "   ";
            String byte_ind = "   ";
            if (i < max_char) {
                char_ind = "'" + this.array[i] + "'";
            }
            if (i < max_byte) {
                byte_ind = "'" + (char)this.bytes[i] + "'";
            }
            sb.append("[" + i + "] = " + char_ind + " " + byte_ind + "\n");
        }
        sb.append("\n");
        sb.append("charToByteIndex array:\n");
        for (i = 0; i < this.charToByteIndex.length - 1; ++i) {
            sb.append("[" + i + "] = " + this.charToByteIndex[i] + "\n");
        }
        sb.append("\n");
        sb.append("byteToCharIndex array:\n");
        for (i = 0; i < this.byteToCharIndex.length - 1; ++i) {
            sb.append("[" + i + "] = " + this.byteToCharIndex[i] + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public void dispose() {
    }

    public InternalRep duplicate() {
        return this;
    }
}

