/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.Parser;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;

class ParseExpr {
    static final int LITERAL = 0;
    static final int FUNC_NAME = 1;
    static final int OPEN_BRACKET = 2;
    static final int OPEN_BRACE = 3;
    static final int OPEN_PAREN = 4;
    static final int CLOSE_PAREN = 5;
    static final int DOLLAR = 6;
    static final int QUOTE = 7;
    static final int COMMA = 8;
    static final int END = 9;
    static final int UNKNOWN = 10;
    static final int UNKNOWN_CHAR = 11;
    static final int MULT = 12;
    static final int DIVIDE = 13;
    static final int MOD = 14;
    static final int PLUS = 15;
    static final int MINUS = 16;
    static final int LEFT_SHIFT = 17;
    static final int RIGHT_SHIFT = 18;
    static final int LESS = 19;
    static final int GREATER = 20;
    static final int LEQ = 21;
    static final int GEQ = 22;
    static final int EQUAL = 23;
    static final int NEQ = 24;
    static final int BIT_AND = 25;
    static final int BIT_XOR = 26;
    static final int BIT_OR = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int QUESTY = 30;
    static final int COLON = 31;
    static final int NOT = 32;
    static final int BIT_NOT = 33;
    static final int STREQ = 34;
    static final int STRNEQ = 35;
    static String[] lexemeStrings = new String[]{"LITERAL", "FUNCNAME", "[", "{", "(", ")", "$", "\"", ",", "END", "UNKNOWN", "*", "/", "%", "+", "-", "<<", ">>", "<", ">", "<=", ">=", "==", "!=", "&", "^", "|", "&&", "||", "?", ":", "!", "~", "eq", "ne"};

    ParseExpr() {
    }

    static TclParse parseExpr(Interp interp, char[] script_array, int script_index, int numChars) {
        int endIndex;
        String fileName = "unknown";
        int lineNum = 0;
        int script_length = script_array.length - 1;
        if (numChars < 0) {
            numChars = script_length - script_index;
        }
        if ((endIndex = script_index + numChars) > script_length) {
            endIndex = script_length;
        }
        TclParse parse = new TclParse(interp, script_array, endIndex, fileName, lineNum);
        ParseInfo info = new ParseInfo(parse, script_array, script_index, numChars);
        try {
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseCondExpr(interp, info);
            if (info.lexeme != 9) {
                ParseExpr.LogSyntaxError(info, "extra tokens at end of expression");
            }
        }
        catch (TclException te) {
            parse.result = 1;
            return parse;
        }
        if (parse.result != 0) {
            throw new TclRuntimeError("non TCL.OK parse result in parseExpr():  TclException should have been raised");
        }
        parse.result = 0;
        return parse;
    }

    static void ParseCondExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseLorExpr(interp, info);
        if (info.lexeme == 30) {
            parseObj.insertInTokenArray(firstIndex, 2);
            parseObj.numTokens += 2;
            TclToken token = parseObj.getToken(firstIndex);
            token.type = 64;
            token.script_array = info.originalExpr;
            token.script_index = srcStart;
            token.size = 0;
            token = parseObj.getToken(firstIndex + 1);
            token.type = 128;
            token.script_array = info.originalExpr;
            token.script_index = info.start;
            token.size = 1;
            token.numComponents = 0;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseCondExpr(interp, info);
            if (info.lexeme != 31) {
                ParseExpr.LogSyntaxError(info, "missing colon from ternary conditional");
            }
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseCondExpr(interp, info);
            TclToken condToken = parseObj.getToken(firstIndex);
            condToken.script_array = info.originalExpr;
            condToken.size = info.prevEnd - srcStart;
            condToken.numComponents = parseObj.numTokens - (firstIndex + 1);
        }
    }

    static void ParseLorExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseLandExpr(interp, info);
        while (info.lexeme == 29) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseLandExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 2, srcStart, info.prevEnd - srcStart, firstIndex, info);
        }
    }

    static void ParseLandExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseBitOrExpr(interp, info);
        while (info.lexeme == 28) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseBitOrExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 2, srcStart, info.prevEnd - srcStart, firstIndex, info);
        }
    }

    static void ParseBitOrExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseBitXorExpr(interp, info);
        while (info.lexeme == 27) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseBitXorExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 1, srcStart, info.prevEnd - srcStart, firstIndex, info);
        }
    }

    static void ParseBitXorExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseBitAndExpr(interp, info);
        while (info.lexeme == 26) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseBitAndExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 1, srcStart, info.prevEnd - srcStart, firstIndex, info);
        }
    }

    static void ParseBitAndExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseEqualityExpr(interp, info);
        while (info.lexeme == 25) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseEqualityExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 1, srcStart, info.prevEnd - srcStart, firstIndex, info);
        }
    }

    static void ParseEqualityExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseRelationalExpr(interp, info);
        int lexeme = info.lexeme;
        while (lexeme == 23 || lexeme == 24 || lexeme == 34 || lexeme == 35) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseRelationalExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 2, srcStart, info.prevEnd - srcStart, firstIndex, info);
            lexeme = info.lexeme;
        }
    }

    static void ParseRelationalExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseShiftExpr(interp, info);
        int lexeme = info.lexeme;
        while (lexeme == 19 || lexeme == 20 || lexeme == 21 || lexeme == 22) {
            int operator = info.start;
            int operatorSize = lexeme == 21 || lexeme == 22 ? 2 : 1;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseShiftExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, operatorSize, srcStart, info.prevEnd - srcStart, firstIndex, info);
            lexeme = info.lexeme;
        }
    }

    static void ParseShiftExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseAddExpr(interp, info);
        int lexeme = info.lexeme;
        while (lexeme == 17 || lexeme == 18) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseAddExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 2, srcStart, info.prevEnd - srcStart, firstIndex, info);
            lexeme = info.lexeme;
        }
    }

    static void ParseAddExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseMultiplyExpr(interp, info);
        int lexeme = info.lexeme;
        while (lexeme == 15 || lexeme == 16) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseMultiplyExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 1, srcStart, info.prevEnd - srcStart, firstIndex, info);
            lexeme = info.lexeme;
        }
    }

    static void ParseMultiplyExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        ParseExpr.ParseUnaryExpr(interp, info);
        int lexeme = info.lexeme;
        while (lexeme == 12 || lexeme == 13 || lexeme == 14) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseUnaryExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 1, srcStart, info.prevEnd - srcStart, firstIndex, info);
            lexeme = info.lexeme;
        }
    }

    static void ParseUnaryExpr(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        int srcStart = info.start;
        int firstIndex = parseObj.numTokens;
        int lexeme = info.lexeme;
        if (lexeme == 15 || lexeme == 16 || lexeme == 33 || lexeme == 32) {
            int operator = info.start;
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseUnaryExpr(interp, info);
            ParseExpr.PrependSubExprTokens(operator, 1, srcStart, info.prevEnd - srcStart, firstIndex, info);
        } else {
            ParseExpr.ParsePrimaryExpr(interp, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void ParsePrimaryExpr(Interp interp, ParseInfo info) throws TclException {
        parseObj = info.parseObj;
        lexeme = info.lexeme;
        if (lexeme == 4) {
            ParseExpr.GetLexeme(interp, info);
            ParseExpr.ParseCondExpr(interp, info);
            if (info.lexeme != 5) {
                ParseExpr.LogSyntaxError(info, "looking for close parenthesis");
            }
            ParseExpr.GetLexeme(interp, info);
            return;
        }
        if (parseObj.numTokens == parseObj.tokensAvailable) {
            parseObj.expandTokenArray(parseObj.numTokens);
        }
        exprIndex = parseObj.numTokens++;
        exprToken = parseObj.getToken(exprIndex);
        exprToken.type = 64;
        exprToken.script_array = info.originalExpr;
        exprToken.script_index = info.start;
        firstIndex = parseObj.numTokens;
        switch (lexeme) {
            case 0: {
                if (parseObj.numTokens == parseObj.tokensAvailable) {
                    parseObj.expandTokenArray(parseObj.numTokens);
                }
                token = parseObj.getToken(parseObj.numTokens);
                token.type = 4;
                token.script_array = info.originalExpr;
                token.script_index = info.start;
                token.size = info.size;
                info.next = info.start + info.size;
                token.numComponents = 0;
                ++parseObj.numTokens;
                exprToken.script_array = info.originalExpr;
                exprToken.size = info.size;
                exprToken.numComponents = 1;
                break;
            }
            case 6: {
                dollar = info.next - 1;
                parseObj = Parser.parseVarName(interp, info.originalExpr, dollar, info.lastChar - dollar, parseObj, true);
                if (parseObj.result != 0) {
                    throw new TclException(parseObj.result);
                }
                info.next = dollar + parseObj.getToken((int)firstIndex).size;
                exprToken = parseObj.getToken(exprIndex);
                exprToken.size = parseObj.getToken((int)firstIndex).size;
                exprToken.numComponents = parseObj.getToken((int)firstIndex).numComponents + 1;
                exprToken.script_array = info.originalExpr;
                break;
            }
            case 7: {
                stringStart = info.next;
                parseObj = Parser.ParseQuotedString(interp, info.originalExpr, info.next - 1, info.lastChar - stringStart, parseObj, true);
                info.next = term = parseObj.extra;
                exprToken = parseObj.getToken(exprIndex);
                exprToken.size = term - exprToken.script_index;
                exprToken.numComponents = parseObj.numTokens - firstIndex;
                exprToken.script_array = info.originalExpr;
                if (exprToken.numComponents <= 1) break;
                if (parseObj.numTokens >= parseObj.tokensAvailable) {
                    parseObj.expandTokenArray(parseObj.numTokens + 1);
                }
                parseObj.insertInTokenArray(firstIndex, 1);
                ++parseObj.numTokens;
                token = parseObj.getToken(firstIndex);
                exprToken = parseObj.getToken(exprIndex);
                ++exprToken.numComponents;
                exprToken.script_array = info.originalExpr;
                token.type = 1;
                token.script_array = info.originalExpr;
                token.script_index = exprToken.script_index;
                token.size = exprToken.size;
                token.numComponents = exprToken.numComponents - 1;
                break;
            }
            case 2: {
                if (parseObj.numTokens == parseObj.tokensAvailable) {
                    parseObj.expandTokenArray(parseObj.numTokens);
                }
                token = parseObj.getToken(parseObj.numTokens);
                token.type = 16;
                token.script_array = info.originalExpr;
                token.script_index = info.start;
                token.numComponents = 0;
                ++parseObj.numTokens;
                src = info.next;
                do {
                    nested = Parser.parseCommand(interp, info.originalExpr, src, parseObj.endIndex - src, parseObj.fileName, parseObj.lineNum, true);
                    if (nested.result != 0) {
                        parseObj.termIndex = nested.termIndex;
                        parseObj.errorType = nested.errorType;
                        parseObj.incomplete = nested.incomplete;
                        parseObj.result = nested.result;
                    }
                    src = nested.commandStart + nested.commandSize;
                    if (nested.termIndex < parseObj.endIndex && info.originalExpr[nested.termIndex] == ']' && !nested.incomplete) ** GOTO lbl92
                } while (src != parseObj.endIndex);
                parseObj.termIndex = token.script_index;
                parseObj.incomplete = true;
                parseObj.result = 1;
                throw new TclException(parseObj.interp, "missing close-bracket");
lbl92:
                // 1 sources

                token.size = src - token.script_index;
                info.next = src;
                exprToken = parseObj.getToken(exprIndex);
                exprToken.size = src - token.script_index;
                exprToken.numComponents = 1;
                exprToken.script_array = info.originalExpr;
                break;
            }
            case 3: {
                parseObj = Parser.ParseBraces(interp, info.originalExpr, info.start, info.lastChar - info.start, parseObj, true);
                info.next = term = parseObj.extra;
                exprToken = parseObj.getToken(exprIndex);
                exprToken.size = term - info.start;
                exprToken.numComponents = parseObj.numTokens - firstIndex;
                if (exprToken.numComponents <= 1) break;
                if (parseObj.numTokens >= parseObj.tokensAvailable) {
                    parseObj.expandTokenArray(parseObj.numTokens + 1);
                }
                parseObj.insertInTokenArray(firstIndex, 1);
                ++parseObj.numTokens;
                token = parseObj.getToken(firstIndex);
                exprToken = parseObj.getToken(exprIndex);
                ++exprToken.numComponents;
                token.type = 1;
                token.script_array = exprToken.script_array;
                token.script_index = exprToken.script_index;
                token.size = exprToken.size;
                token.numComponents = exprToken.numComponents - 1;
                break;
            }
            case 1: {
                savedInfo = info.duplicate();
                ParseExpr.GetLexeme(interp, info);
                if (info.lexeme == 4) ** GOTO lbl149
                obj = TclString.newInstance((String)new String(savedInfo.originalExpr, savedInfo.start, savedInfo.size));
                obj.preserve();
                try {
                    TclBoolean.get((Interp)interp, (TclObject)obj);
                    info = savedInfo;
                    if (parseObj.numTokens == parseObj.tokensAvailable) {
                        parseObj.expandTokenArray(parseObj.numTokens);
                    }
                    token = parseObj.getToken(parseObj.numTokens);
                    token.type = 4;
                    token.script_array = info.originalExpr;
                    token.script_index = info.start;
                    token.size = info.size;
                    info.next = info.start + info.size;
                    token.numComponents = 0;
                    ++parseObj.numTokens;
                    exprToken.script_array = info.originalExpr;
                    exprToken.size = info.size;
                    exprToken.numComponents = 1;
                    break;
                }
                catch (TclException ex) {
                }
                finally {
                    obj.release();
                }
                ParseExpr.LogSyntaxError(info, null);
lbl149:
                // 2 sources

                if (parseObj.numTokens == parseObj.tokensAvailable) {
                    parseObj.expandTokenArray(parseObj.numTokens);
                }
                token = parseObj.getToken(parseObj.numTokens);
                token.type = 128;
                token.script_array = savedInfo.originalExpr;
                token.script_index = savedInfo.start;
                token.size = savedInfo.size;
                token.numComponents = 0;
                ++parseObj.numTokens;
                ParseExpr.GetLexeme(interp, info);
                while (info.lexeme != 5) {
                    ParseExpr.ParseCondExpr(interp, info);
                    if (info.lexeme == 8) {
                        ParseExpr.GetLexeme(interp, info);
                        continue;
                    }
                    if (info.lexeme == 5) continue;
                    ParseExpr.LogSyntaxError(info, "missing close parenthesis at end of function call");
                }
                exprToken = parseObj.getToken(exprIndex);
                exprToken.size = info.next - exprToken.script_index;
                exprToken.numComponents = parseObj.numTokens - firstIndex;
                exprToken.script_array = info.originalExpr;
                break;
            }
            case 8: {
                ParseExpr.LogSyntaxError(info, "commas can only separate function arguments");
            }
            case 9: {
                ParseExpr.LogSyntaxError(info, "premature end of expression");
            }
            case 10: {
                ParseExpr.LogSyntaxError(info, "single equality character not legal in expressions");
            }
            case 11: {
                ParseExpr.LogSyntaxError(info, "character not legal in expressions");
            }
            case 30: {
                ParseExpr.LogSyntaxError(info, "unexpected ternary 'then' separator");
            }
            case 31: {
                ParseExpr.LogSyntaxError(info, "unexpected ternary 'else' separator");
            }
            case 5: {
                ParseExpr.LogSyntaxError(info, "unexpected close parenthesis");
            }
            default: {
                msg = "unexpected operator " + ParseExpr.lexemeStrings[lexeme];
                ParseExpr.LogSyntaxError(info, msg);
            }
        }
        ParseExpr.GetLexeme(interp, info);
        parseObj.termIndex = info.next;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void GetLexeme(Interp interp, ParseInfo info) throws TclException {
        TclParse parseObj = info.parseObj;
        info.lexeme = 10;
        info.prevEnd = info.next;
        int src = info.next;
        if (src >= info.lastChar) {
            info.lexeme = 9;
            info.next = src;
            return;
        }
        char c = info.originalExpr[src];
        while (c == ' ' || Character.isWhitespace(c) || c == '\\') {
            if (c == '\\') {
                if (info.originalExpr[src + 1] != '\n') break;
                src += 2;
            } else {
                ++src;
            }
            c = info.originalExpr[src];
        }
        parseObj.termIndex = src;
        if (src >= info.lastChar) {
            info.lexeme = 9;
            info.next = src;
            return;
        }
        if (c != '+' && c != '-') {
            boolean startsWithDigit = Character.isDigit(c);
            String s = new String(info.originalExpr, src, info.lastChar - src);
            if (startsWithDigit && Expression.looksLikeInt(s, s.length(), 0, false)) {
                StrtoulResult res = interp.strtoulResult;
                Util.strtoul(s, 0, 0, res);
                if (res.errno == 0) {
                    int term = src + res.index;
                    info.lexeme = 0;
                    info.start = src;
                    info.size = term - src;
                    info.next = term;
                    parseObj.termIndex = term;
                    return;
                }
                parseObj.errorType = 9;
                if (res.errno != -2) throw new TclException(interp, "parse bad number");
                Expression.IntegerTooLarge(interp);
            } else {
                int length = ParseExpr.ParseMaxDoubleLength(info.originalExpr, src, info.lastChar);
                if (length > 0) {
                    s = new String(info.originalExpr, src, length);
                    StrtodResult res = interp.strtodResult;
                    Util.strtod(s, 0, -1, res);
                    if (res.index > 0) {
                        if (res.errno != 0) {
                            parseObj.errorType = 9;
                            if (res.errno != -4) throw new TclException(interp, "parse bad number");
                            if (res.value != 0.0) {
                                Expression.DoubleTooLarge(interp);
                            } else {
                                Expression.DoubleTooSmall(interp);
                            }
                        }
                        int term = src + res.index;
                        info.lexeme = 0;
                        info.start = src;
                        info.size = term - src;
                        if (info.size > length) {
                            info.size = length;
                        }
                        parseObj.termIndex = info.next = src + info.size;
                        return;
                    }
                }
            }
        }
        c = info.originalExpr[src];
        char c2 = info.originalExpr[src + 1];
        info.start = src;
        info.size = 1;
        parseObj.termIndex = info.next = src + 1;
        switch (c) {
            case '[': {
                info.lexeme = 2;
                return;
            }
            case '{': {
                info.lexeme = 3;
                return;
            }
            case '(': {
                info.lexeme = 4;
                return;
            }
            case ')': {
                info.lexeme = 5;
                return;
            }
            case '$': {
                info.lexeme = 6;
                return;
            }
            case '\"': {
                info.lexeme = 7;
                return;
            }
            case ',': {
                info.lexeme = 8;
                return;
            }
            case '*': {
                info.lexeme = 12;
                return;
            }
            case '/': {
                info.lexeme = 13;
                return;
            }
            case '%': {
                info.lexeme = 14;
                return;
            }
            case '+': {
                info.lexeme = 15;
                return;
            }
            case '-': {
                info.lexeme = 16;
                return;
            }
            case '?': {
                info.lexeme = 30;
                return;
            }
            case ':': {
                info.lexeme = 31;
                return;
            }
            case '<': {
                switch (c2) {
                    case '<': {
                        info.lexeme = 17;
                        info.size = 2;
                        info.next = src + 2;
                        break;
                    }
                    case '=': {
                        info.lexeme = 21;
                        info.size = 2;
                        info.next = src + 2;
                        break;
                    }
                    default: {
                        info.lexeme = 19;
                    }
                }
                parseObj.termIndex = info.next;
                return;
            }
            case '>': {
                switch (c2) {
                    case '>': {
                        info.lexeme = 18;
                        info.size = 2;
                        info.next = src + 2;
                        break;
                    }
                    case '=': {
                        info.lexeme = 22;
                        info.size = 2;
                        info.next = src + 2;
                        break;
                    }
                    default: {
                        info.lexeme = 20;
                    }
                }
                parseObj.termIndex = info.next;
                return;
            }
            case '=': {
                if (c2 == '=') {
                    info.lexeme = 23;
                    info.size = 2;
                    info.next = src + 2;
                } else {
                    info.lexeme = 10;
                }
                parseObj.termIndex = info.next;
                return;
            }
            case '!': {
                if (c2 == '=') {
                    info.lexeme = 24;
                    info.size = 2;
                    info.next = src + 2;
                } else {
                    info.lexeme = 32;
                }
                parseObj.termIndex = info.next;
                return;
            }
            case '&': {
                if (c2 == '&') {
                    info.lexeme = 28;
                    info.size = 2;
                    info.next = src + 2;
                } else {
                    info.lexeme = 25;
                }
                parseObj.termIndex = info.next;
                return;
            }
            case '^': {
                info.lexeme = 26;
                return;
            }
            case '|': {
                if (c2 == '|') {
                    info.lexeme = 29;
                    info.size = 2;
                    info.next = src + 2;
                } else {
                    info.lexeme = 27;
                }
                parseObj.termIndex = info.next;
                return;
            }
            case '~': {
                info.lexeme = 33;
                return;
            }
            case 'e': {
                if (c2 == 'q') {
                    info.lexeme = 34;
                    info.size = 2;
                    parseObj.termIndex = info.next = src + 2;
                    return;
                }
                ParseExpr.checkFuncName(interp, info, src);
                return;
            }
            case 'n': {
                if (c2 == 'e') {
                    info.lexeme = 35;
                    info.size = 2;
                    parseObj.termIndex = info.next = src + 2;
                    return;
                }
                ParseExpr.checkFuncName(interp, info, src);
                return;
            }
        }
        ParseExpr.checkFuncName(interp, info, src);
    }

    static void checkFuncName(Interp interp, ParseInfo info, int src) {
        char c = info.originalExpr[src];
        if (Character.isLetter(c)) {
            info.lexeme = 1;
            while (Character.isLetterOrDigit(c) || c == '_') {
                c = info.originalExpr[++src];
            }
            info.size = src - info.start;
            info.parseObj.termIndex = info.next = src;
            String s = new String(info.originalExpr, info.start, info.size);
            c = info.originalExpr[info.start];
            switch (c) {
                case 'f': {
                    if (info.size != 5 || !s.equals("false")) break;
                    info.lexeme = 0;
                    return;
                }
                case 'n': {
                    if (info.size != 2 || !s.equals("no")) break;
                    info.lexeme = 0;
                    return;
                }
                case 'o': {
                    if (info.size == 3 && s.equals("off")) {
                        info.lexeme = 0;
                        return;
                    }
                    if (info.size != 2 || !s.equals("on")) break;
                    info.lexeme = 0;
                    return;
                }
                case 't': {
                    if (info.size != 4 || !s.equals("true")) break;
                    info.lexeme = 0;
                    return;
                }
                case 'y': {
                    if (info.size != 3 || !s.equals("yes")) break;
                    info.lexeme = 0;
                    return;
                }
            }
        } else {
            info.lexeme = 11;
        }
    }

    static void PrependSubExprTokens(int op, int opBytes, int src, int srcBytes, int firstIndex, ParseInfo info) {
        TclParse parseObj = info.parseObj;
        if (parseObj.numTokens + 1 >= parseObj.tokensAvailable) {
            parseObj.expandTokenArray(parseObj.numTokens + 1);
        }
        parseObj.insertInTokenArray(firstIndex, 2);
        parseObj.numTokens += 2;
        TclToken token = parseObj.getToken(firstIndex);
        token.type = 64;
        token.script_index = src;
        token.script_array = info.originalExpr;
        token.size = srcBytes;
        token.numComponents = parseObj.numTokens - (firstIndex + 1);
        token = parseObj.getToken(firstIndex + 1);
        token.type = 128;
        token.script_index = op;
        token.script_array = info.originalExpr;
        token.size = opBytes;
        token.numComponents = 0;
    }

    static void LogSyntaxError(ParseInfo info, String extraInfo) throws TclException {
        String expr = info.getOriginalExpr();
        if (expr.length() > 60) {
            expr = expr.substring(0, 60) + "...";
        }
        StringBuffer msg = new StringBuffer();
        msg.append("syntax error in expression \"");
        msg.append(expr);
        msg.append("\"");
        info.parseObj.errorType = 8;
        info.parseObj.termIndex = info.start;
        if (info.parseObj.interp != null) {
            info.parseObj.interp.resetResult();
        }
        throw new TclException(info.parseObj.interp, msg.toString());
    }

    static int ParseMaxDoubleLength(char[] script_array, int script_index, int end) {
        int p;
        block3: for (p = script_index; p < end; ++p) {
            switch (script_array[p]) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'I': 
                case 'N': 
                case 'P': 
                case 'X': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'i': 
                case 'n': 
                case 'p': 
                case 'x': {
                    continue block3;
                }
            }
            break;
        }
        return p - script_index;
    }

    static class ParseInfo {
        TclParse parseObj;
        int lexeme;
        int start;
        int size;
        int next;
        int prevEnd;
        char[] originalExpr;
        int originalExprStart;
        int originalExprSize;
        int lastChar;

        ParseInfo() {
        }

        ParseInfo(TclParse parseObj, char[] script_array, int script_index, int length) {
            this.parseObj = parseObj;
            this.lexeme = 10;
            this.originalExpr = script_array;
            this.originalExprStart = script_index;
            this.start = -1;
            this.originalExprSize = length;
            this.size = length;
            this.next = script_index;
            this.prevEnd = script_index;
            this.lastChar = script_index + length;
        }

        String getOriginalExpr() {
            return new String(this.originalExpr, this.originalExprStart, this.originalExprSize);
        }

        ParseInfo duplicate() {
            ParseInfo dup = new ParseInfo();
            dup.parseObj = this.parseObj;
            dup.lexeme = this.lexeme;
            dup.start = this.start;
            dup.size = this.size;
            dup.next = this.next;
            dup.prevEnd = this.prevEnd;
            dup.originalExpr = this.originalExpr;
            dup.originalExprStart = this.originalExprStart;
            dup.originalExprSize = this.originalExprSize;
            dup.lastChar = this.lastChar;
            return dup;
        }
    }
}

