/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class LsearchCmd
implements Command {
    private static final String[] options = new String[]{"-ascii", "-decreasing", "-dictionary", "-exact", "-increasing", "-integer", "-glob", "-real", "-regexp", "-sorted"};
    static final int LSEARCH_ASCII = 0;
    static final int LSEARCH_DECREASING = 1;
    static final int LSEARCH_DICTIONARY = 2;
    static final int LSEARCH_EXACT = 3;
    static final int LSEARCH_INCREASING = 4;
    static final int LSEARCH_INTEGER = 5;
    static final int LSEARCH_GLOB = 6;
    static final int LSEARCH_REAL = 7;
    static final int LSEARCH_REGEXP = 8;
    static final int LSEARCH_SORTED = 9;
    static final int ASCII = 0;
    static final int DICTIONARY = 1;
    static final int INTEGER = 2;
    static final int REAL = 3;
    static final int EXACT = 0;
    static final int GLOB = 1;
    static final int REGEXP = 2;
    static final int SORTED = 3;

    LsearchCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int mode = 1;
        int dataType = 0;
        boolean isIncreasing = true;
        Object pattern = null;
        Object list = null;
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 1, objv, "?options? list pattern");
        }
        block34: for (int i = 1; i < objv.length - 2; ++i) {
            switch (TclIndex.get((Interp)interp, (TclObject)objv[i], (String[])options, (String)"option", (int)0)) {
                case 0: {
                    dataType = 0;
                    continue block34;
                }
                case 1: {
                    isIncreasing = false;
                    continue block34;
                }
                case 2: {
                    dataType = 1;
                    continue block34;
                }
                case 3: {
                    mode = 0;
                    continue block34;
                }
                case 4: {
                    isIncreasing = true;
                    continue block34;
                }
                case 5: {
                    dataType = 2;
                    continue block34;
                }
                case 6: {
                    mode = 1;
                    continue block34;
                }
                case 7: {
                    dataType = 3;
                    continue block34;
                }
                case 8: {
                    mode = 2;
                    continue block34;
                }
                case 9: {
                    mode = 3;
                }
            }
        }
        TclObject[] listv = TclList.getElements(interp, objv[objv.length - 2]);
        TclObject patObj = objv[objv.length - 1];
        String patternBytes = null;
        int patInt = 0;
        double patDouble = 0.0;
        int length = 0;
        if (mode == 0 || mode == 3) {
            switch (dataType) {
                case 0: 
                case 1: {
                    patternBytes = patObj.toString();
                    length = patternBytes.length();
                    break;
                }
                case 2: {
                    patInt = TclInteger.get((Interp)interp, (TclObject)patObj);
                    break;
                }
                case 3: {
                    patDouble = TclDouble.get((Interp)interp, (TclObject)patObj);
                }
            }
        } else {
            patternBytes = patObj.toString();
            length = patternBytes.length();
        }
        int index = -1;
        if (mode == 3) {
            int match = 0;
            int lower = -1;
            int upper = listv.length;
            while (lower + 1 != upper) {
                int i = (lower + upper) / 2;
                switch (dataType) {
                    case 0: {
                        String bytes = listv[i].toString();
                        match = patternBytes.compareTo(bytes);
                        break;
                    }
                    case 1: {
                        String bytes = listv[i].toString();
                        match = LsearchCmd.DictionaryCompare(patternBytes, bytes);
                        break;
                    }
                    case 2: {
                        int objInt = TclInteger.get((Interp)interp, (TclObject)listv[i]);
                        if (patInt == objInt) {
                            match = 0;
                            break;
                        }
                        if (patInt < objInt) {
                            match = -1;
                            break;
                        }
                        match = 1;
                        break;
                    }
                    case 3: {
                        double objDouble = TclDouble.get((Interp)interp, (TclObject)listv[i]);
                        if (patDouble == objDouble) {
                            match = 0;
                            break;
                        }
                        if (patDouble < objDouble) {
                            match = -1;
                            break;
                        }
                        match = 1;
                        break;
                    }
                }
                if (match == 0) {
                    index = i;
                    upper = i;
                    continue;
                }
                if (match > 0) {
                    if (isIncreasing) {
                        lower = i;
                        continue;
                    }
                    upper = i;
                    continue;
                }
                if (isIncreasing) {
                    upper = i;
                    continue;
                }
                lower = i;
            }
        } else {
            for (int i = 0; i < listv.length; ++i) {
                boolean match = false;
                switch (mode) {
                    case 0: 
                    case 3: {
                        switch (dataType) {
                            case 0: {
                                String bytes = listv[i].toString();
                                int elemLen = bytes.length();
                                if (length != elemLen) break;
                                match = bytes.equals(patternBytes);
                                break;
                            }
                            case 1: {
                                String bytes = listv[i].toString();
                                match = LsearchCmd.DictionaryCompare(bytes, patternBytes) == 0;
                                break;
                            }
                            case 2: {
                                int objInt = TclInteger.get((Interp)interp, (TclObject)listv[i]);
                                match = objInt == patInt;
                                break;
                            }
                            case 3: {
                                double objDouble = TclDouble.get((Interp)interp, (TclObject)listv[i]);
                                match = objDouble == patDouble;
                                break;
                            }
                        }
                        break;
                    }
                    case 1: {
                        match = Util.stringMatch(listv[i].toString(), patternBytes);
                        break;
                    }
                    case 2: {
                        match = Util.regExpMatch(interp, listv[i].toString(), patObj);
                    }
                }
                if (!match) continue;
                index = i;
                break;
            }
        }
        interp.setResult(index);
    }

    private static int DictionaryCompare(String left, String right) {
        int diff;
        char[] leftArr = left.toCharArray();
        char[] rightArr = right.toCharArray();
        int lInd = 0;
        int rInd = 0;
        int secondaryDiff = 0;
        block0: while (true) {
            if (rInd < rightArr.length && Character.isDigit(rightArr[rInd]) && lInd < leftArr.length && Character.isDigit(leftArr[lInd])) {
                int zeros = 0;
                while (rightArr[rInd] == '0' && rInd + 1 < rightArr.length && Character.isDigit(rightArr[rInd + 1])) {
                    ++rInd;
                    --zeros;
                }
                while (leftArr[lInd] == '0' && lInd + 1 < leftArr.length && Character.isDigit(leftArr[lInd + 1])) {
                    ++lInd;
                    ++zeros;
                }
                if (secondaryDiff == 0) {
                    secondaryDiff = zeros;
                }
                diff = 0;
                do {
                    if (diff == 0 && lInd < leftArr.length && rInd < rightArr.length) {
                        diff = leftArr[lInd] - rightArr[rInd];
                    }
                    ++lInd;
                    if (++rInd < rightArr.length && Character.isDigit(rightArr[rInd])) continue;
                    if (lInd < leftArr.length && Character.isDigit(leftArr[lInd])) {
                        return 1;
                    }
                    if (diff == 0) continue block0;
                    return diff;
                } while (lInd < leftArr.length && Character.isDigit(leftArr[lInd]));
                return -1;
            }
            if (lInd >= leftArr.length || rInd >= rightArr.length) {
                if (lInd < leftArr.length) {
                    diff = -rightArr[rInd];
                    break;
                }
                if (rInd < rightArr.length) {
                    diff = leftArr[lInd];
                    break;
                }
                diff = 0;
                break;
            }
            char leftChar = leftArr[lInd++];
            char rightChar = rightArr[rInd++];
            char leftLower = Character.toLowerCase(leftChar);
            char rightLower = Character.toLowerCase(rightChar);
            diff = leftLower - rightLower;
            if (diff != 0) {
                return diff;
            }
            if (secondaryDiff != 0) continue;
            if (Character.isUpperCase(leftChar) && Character.isLowerCase(rightChar)) {
                secondaryDiff = -1;
                continue;
            }
            if (!Character.isUpperCase(rightChar) || !Character.isLowerCase(leftChar)) continue;
            secondaryDiff = 1;
        }
        if (diff == 0) {
            diff = secondaryDiff;
        }
        return diff;
    }
}

