/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Var;

class LappendCmd
implements Command {
    LappendCmd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        TclObject newValue = null;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "varName ?value value ...?");
        }
        if (objv.length == 2) {
            try {
                newValue = interp.getVar(objv[1], 0);
            }
            catch (TclException e) {
                TclObject varValue = TclList.newInstance();
                try {
                    newValue = interp.setVar(objv[1], varValue, 0);
                }
                finally {
                    if (newValue == null) {
                        varValue.release();
                    }
                }
                interp.resetResult();
                return;
            }
        }
        newValue = LappendCmd.lappendVar(interp, objv[1].toString(), objv, 2);
        interp.setResult(newValue);
    }

    static TclObject lappendVar(Interp interp, String varName, TclObject[] values, int valuesInd) throws TclException {
        TclObject newValue;
        int len;
        TclObject varValue;
        boolean createdNewObj = false;
        boolean createVar = true;
        try {
            varValue = interp.getVar(varName, 0);
        }
        catch (TclException e) {
            if (Var.isArrayVarname(varName)) {
                createVar = false;
            }
            varValue = TclList.newInstance();
            createdNewObj = true;
        }
        if (!createdNewObj && varValue.isShared()) {
            varValue = varValue.duplicate();
            createdNewObj = true;
        }
        if ((len = values.length) - valuesInd == 1) {
            TclList.append(interp, varValue, values[valuesInd]);
        } else {
            TclList.append(interp, varValue, values, valuesInd, len);
        }
        try {
            newValue = interp.setVar(varName, varValue, 0);
        }
        catch (TclException e) {
            if (createdNewObj && !createVar) {
                varValue.release();
            }
            throw e;
        }
        return newValue;
    }
}

