/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

class IfCmd
implements Command {
    IfCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int i = 1;
        while (true) {
            boolean value;
            if (i >= objv.length) {
                throw new TclException(interp, "wrong # args: no expression after \"" + (Object)((Object)objv[i - 1]) + "\" argument");
            }
            try {
                value = interp.expr.evalBoolean(interp, objv[i].toString());
            }
            catch (TclException e) {
                switch (e.getCompletionCode()) {
                    case 1: {
                        interp.addErrorInfo("\n    (\"if\" test expression)");
                    }
                }
                throw e;
            }
            if (++i < objv.length && objv[i].toString().equals("then")) {
                ++i;
            }
            if (i >= objv.length) {
                throw new TclException(interp, "wrong # args: no script following \"" + (Object)((Object)objv[i - 1]) + "\" argument");
            }
            if (value) {
                try {
                    interp.eval(objv[i], 0);
                }
                catch (TclException e) {
                    switch (e.getCompletionCode()) {
                        case 1: {
                            interp.addErrorInfo("\n    (\"if\" then script line " + interp.errorLine + ")");
                        }
                    }
                    throw e;
                }
                return;
            }
            if (++i >= objv.length) {
                interp.resetResult();
                return;
            }
            if (!objv[i].toString().equals("elseif")) break;
            ++i;
        }
        if (objv[i].toString().equals("else")) {
            if (++i >= objv.length) {
                throw new TclException(interp, "wrong # args: no script following \"else\" argument");
            }
            if (i != objv.length - 1) {
                throw new TclException(interp, "wrong # args: extra words after \"else\" clause in \"if\" command");
            }
        } else if (i != objv.length - 1) {
            throw new TclException(interp, "wrong # args: extra words after \"else\" clause in \"if\" command");
        }
        try {
            interp.eval(objv[i], 0);
        }
        catch (TclException e) {
            switch (e.getCompletionCode()) {
                case 1: {
                    interp.addErrorInfo("\n    (\"if\" else script line " + interp.errorLine + ")");
                }
            }
            throw e;
        }
    }
}

