/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Hashtable;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class EncodingCmd
implements Command {
    static String systemTclEncoding = null;
    static String systemJavaEncoding = null;
    static Hashtable encodeHash;
    static EncodingMap[] encodings;
    private static final String[] validCmds;
    static final int OPT_CONVERTFROM = 0;
    static final int OPT_CONVERTTO = 1;
    static final int OPT_NAMES = 2;
    static final int OPT_SYSTEM = 3;

    EncodingCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option ?arg ...?");
        }
        int index = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])validCmds, (String)"option", (int)0);
        switch (index) {
            case 0: 
            case 1: {
                TclObject data;
                String tclEncoding;
                if (objv.length == 3) {
                    tclEncoding = systemTclEncoding;
                    data = objv[2];
                } else if (objv.length == 4) {
                    tclEncoding = objv[2].toString();
                    data = objv[3];
                } else {
                    throw new TclNumArgsException(interp, 2, objv, "?encoding? data");
                }
                String javaEncoding = EncodingCmd.getJavaName(tclEncoding);
                if (javaEncoding == null) {
                    throw new TclException(interp, "unknown encoding \"" + tclEncoding + "\"");
                }
                try {
                    if (index == 0) {
                        byte[] bytes = TclByteArray.getBytes(interp, data);
                        interp.setResult(new String(bytes, javaEncoding));
                        break;
                    }
                    byte[] bytes = data.toString().getBytes(javaEncoding);
                    interp.setResult(TclByteArray.newInstance(bytes));
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new TclRuntimeError("Encoding.cmdProc() error: unsupported java encoding \"" + javaEncoding + "\"");
                }
            }
            case 2: {
                if (objv.length > 2) {
                    throw new TclNumArgsException(interp, 2, objv, null);
                }
                TclObject list = TclList.newInstance();
                for (int i = 0; i < encodings.length; ++i) {
                    EncodingMap map = encodings[i];
                    if (!EncodingCmd.isSupported(map.javaName)) continue;
                    TclList.append(interp, list, TclString.newInstance((String)map.tclName));
                }
                interp.setResult(list);
                break;
            }
            case 3: {
                if (objv.length > 3) {
                    throw new TclNumArgsException(interp, 2, objv, "?encoding?");
                }
                if (objv.length == 2) {
                    interp.setResult(systemTclEncoding);
                    break;
                }
                String tclEncoding = objv[2].toString();
                String javaEncoding = EncodingCmd.getJavaName(tclEncoding);
                if (javaEncoding == null) {
                    throw new TclException(interp, "unknown encoding \"" + tclEncoding + "\"");
                }
                systemTclEncoding = tclEncoding;
                systemJavaEncoding = javaEncoding;
                break;
            }
            default: {
                throw new TclRuntimeError("Encoding.cmdProc() error: incorrect index returned from TclIndex.get()");
            }
        }
    }

    static int getBytesPerChar(String name) {
        String key = "java," + name;
        EncodingMap map = (EncodingMap)encodeHash.get(key);
        if (map == null) {
            throw new RuntimeException("Invalid encoding \"" + name + "\"");
        }
        return map.bytesPerChar;
    }

    static String getJavaName(String name) {
        String key = "tcl," + name;
        EncodingMap map = (EncodingMap)encodeHash.get(key);
        if (map == null) {
            return null;
        }
        return map.javaName;
    }

    static String getTclName(String name) {
        String key = "java," + name;
        EncodingMap map = (EncodingMap)encodeHash.get(key);
        if (map == null) {
            return null;
        }
        return map.tclName;
    }

    static boolean isSupported(String name) {
        Charset cs;
        String key = "java," + name;
        EncodingMap map = (EncodingMap)encodeHash.get(key);
        if (map == null) {
            return false;
        }
        try {
            cs = Charset.forName(name);
        }
        catch (IllegalCharsetNameException ex) {
            throw new TclRuntimeError("illegal charset name \"" + name + "\"");
        }
        catch (UnsupportedCharsetException ex) {
            return false;
        }
        return cs.canEncode();
    }

    static {
        encodings = new EncodingMap[]{new EncodingMap("identity", "UTF8", 1), new EncodingMap("utf-8", "UTF8", 1), new EncodingMap("utf-16", "UTF16", 2), new EncodingMap("unicode", "ISO-10646-UCS-2", 2), new EncodingMap("ascii", "ASCII", 1), new EncodingMap("big5", "Big5", 0), new EncodingMap("cp1250", "Cp1250", 1), new EncodingMap("cp1251", "Cp1251", 1), new EncodingMap("ansi-1251", "Cp1251", 1), new EncodingMap("cp1252", "Cp1252", 1), new EncodingMap("cp1253", "Cp1253", 1), new EncodingMap("cp1254", "Cp1254", 1), new EncodingMap("cp1255", "Cp1255", 1), new EncodingMap("cp1256", "Cp1256", 1), new EncodingMap("cp1257", "Cp1257", 1), new EncodingMap("cp1258", "Cp1258", 1), new EncodingMap("cp437", "Cp437", 1), new EncodingMap("cp737", "Cp737", 1), new EncodingMap("cp775", "Cp775", 1), new EncodingMap("cp850", "Cp850", 1), new EncodingMap("cp852", "Cp852", 1), new EncodingMap("cp855", "Cp855", 1), new EncodingMap("cp857", "Cp857", 1), new EncodingMap("cp860", "Cp860", 1), new EncodingMap("cp861", "Cp861", 1), new EncodingMap("cp862", "Cp862", 1), new EncodingMap("cp863", "Cp863", 1), new EncodingMap("cp864", "Cp864", 1), new EncodingMap("cp865", "Cp865", 1), new EncodingMap("cp866", "Cp866", 1), new EncodingMap("cp869", "Cp869", 1), new EncodingMap("cp874", "Cp874", 1), new EncodingMap("cp932", "Cp942", 0), new EncodingMap("cp936", "Cp936", 0), new EncodingMap("cp949", "Cp949", 0), new EncodingMap("cp950", "Cp950", 0), new EncodingMap("euc-cn", "EUC_cn", 0), new EncodingMap("euc-jp", "EUC_jp", 0), new EncodingMap("euc-kr", "EUC_kr", 0), new EncodingMap("iso2022", "ISO2022JP", -1), new EncodingMap("iso2022-jp", "ISO2022JP", -1), new EncodingMap("iso2022-kr", "ISO2022KR", -1), new EncodingMap("iso8859-1", "ISO8859_1", 1), new EncodingMap("ansi_x3.4-1968", "ISO8859_1", 1), new EncodingMap("iso8859-2", "ISO8859_2", 1), new EncodingMap("iso8859-3", "ISO8859_3", 1), new EncodingMap("iso8859-4", "ISO8859_4", 1), new EncodingMap("iso8859-5", "ISO8859_5", 1), new EncodingMap("iso8859-6", "ISO8859_6", 1), new EncodingMap("iso8859-7", "ISO8859_7", 1), new EncodingMap("iso8859-8", "ISO8859_8", 1), new EncodingMap("iso8859-9", "ISO8859_9", 1), new EncodingMap("jis0201", "JIS0201", 1), new EncodingMap("jis0208", "JIS0208", 2), new EncodingMap("jis0212", "JIS0212", 2), new EncodingMap("koi8-r", "KOI8_r", 1), new EncodingMap("macCentEuro", "MacCentEuro", 1), new EncodingMap("macCroatian", "MacCroatian", 1), new EncodingMap("macCyrillic", "MacCyrillic", 1), new EncodingMap("macDingbats", "MacDingbats", 1), new EncodingMap("macGreek", "MacGreek", 1), new EncodingMap("macIceland", "MacIceland", 1), new EncodingMap("macJapan", "MacJapan", 0), new EncodingMap("macRoman", "MacRoman", 1), new EncodingMap("macRomania", "MacRomania", 1), new EncodingMap("macThai", "MacThai", 1), new EncodingMap("macTurkish", "MacTurkish", 1), new EncodingMap("macUkraine", "MacUkraine", 1), new EncodingMap("shiftjis", "SJIS", 0)};
        encodeHash = new Hashtable();
        for (int i = 0; i < encodings.length; ++i) {
            EncodingMap map = encodings[i];
            String tclKey = "tcl," + map.tclName;
            String javaKey = "java," + map.javaName;
            encodeHash.put(tclKey, map);
            encodeHash.put(javaKey, map);
        }
        String enc = null;
        try {
            enc = System.getProperty("file.encoding");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (enc != null) {
            String key = "java," + enc;
            EncodingMap map = (EncodingMap)encodeHash.get(key);
            if (map == null) {
                enc = null;
            } else {
                systemTclEncoding = map.tclName;
                systemJavaEncoding = map.javaName;
            }
        }
        if (enc == null || enc.length() == 0) {
            systemTclEncoding = "iso8859-1";
            systemJavaEncoding = "ISO8859_1";
        }
        validCmds = new String[]{"convertfrom", "convertto", "names", "system"};
    }

    static class EncodingMap {
        String tclName;
        String javaName;
        int bytesPerChar;

        public EncodingMap(String tclName, String javaName, int bytesPerChar) {
            this.tclName = tclName;
            this.javaName = javaName;
            this.bytesPerChar = bytesPerChar;
        }
    }
}

