/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import tcl.lang.FindElemResult;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.QSort;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

public class TclList
implements InternalRep {
    private ArrayList alist;

    private TclList() {
        this.alist = new ArrayList();
    }

    private TclList(int size) {
        this.alist = new ArrayList(size);
    }

    public void dispose() {
        int size = this.alist.size();
        for (int i = 0; i < size; ++i) {
            ((TclObject)((Object)this.alist.get(i))).release();
        }
        this.alist.clear();
    }

    public InternalRep duplicate() {
        int size = this.alist.size();
        TclList newList = new TclList(size);
        for (int i = 0; i < size; ++i) {
            TclObject tobj = (TclObject)((Object)this.alist.get(i));
            tobj.preserve();
            newList.alist.add(tobj);
        }
        return newList;
    }

    public String toString() {
        int size = this.alist.size();
        if (size == 0) {
            return "";
        }
        int est = size * 4;
        StringBuffer sbuf = new StringBuffer(est > 64 ? est : 64);
        try {
            for (int i = 0; i < size; ++i) {
                Object elm = this.alist.get(i);
                if (elm != null) {
                    Util.appendElement(null, sbuf, elm.toString());
                    continue;
                }
                Util.appendElement(null, sbuf, "");
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        return sbuf.toString();
    }

    public static TclObject newInstance() {
        return new TclObject(new TclList());
    }

    private static void setListFromAny(Interp interp, TclObject tobj) throws TclException {
        TclList tlist = new TclList();
        TclList.splitList(interp, tlist.alist, tobj.toString());
        tobj.setInternalRep(tlist);
    }

    private static final void splitList(Interp interp, ArrayList alist, String s) throws TclException {
        int len = s.length();
        int i = 0;
        FindElemResult res = new FindElemResult();
        while (i < len && Util.findElement(interp, s, i, len, res)) {
            TclObject tobj = TclString.newInstance((String)res.elem);
            tobj.preserve();
            alist.add(tobj);
            i = res.elemEnd;
        }
    }

    public static final void append(Interp interp, TclObject tobj, TclObject elemObj) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        elemObj.preserve();
        ((TclList)tobj.getInternalRep()).alist.add(elemObj);
    }

    static final void append(Interp interp, TclObject tobj, TclObject[] objv, int startIdx, int endIdx) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.append() called with shared object");
        }
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        ArrayList alist = ((TclList)tobj.getInternalRep()).alist;
        for (int i = startIdx; i < endIdx; ++i) {
            TclObject elemObj = objv[i];
            elemObj.preserve();
            alist.add(elemObj);
        }
    }

    public static final int getLength(Interp interp, TclObject tobj) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        TclList tlist = (TclList)tobj.getInternalRep();
        return tlist.alist.size();
    }

    public static TclObject[] getElements(Interp interp, TclObject tobj) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.alist.size();
        TclObject[] objArray = new TclObject[size];
        for (int i = 0; i < size; ++i) {
            objArray[i] = (TclObject)((Object)tlist.alist.get(i));
        }
        return objArray;
    }

    public static final TclObject index(Interp interp, TclObject tobj, int index) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        TclList tlist = (TclList)tobj.getInternalRep();
        if (index < 0 || index >= tlist.alist.size()) {
            return null;
        }
        return (TclObject)((Object)tlist.alist.get(index));
    }

    static final void insert(Interp interp, TclObject tobj, int index, TclObject[] elements, int from, int to) throws TclException {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.insert() called with shared object");
        }
        TclList.replace(interp, tobj, index, 0, elements, from, to);
    }

    public static final void replace(Interp interp, TclObject tobj, int index, int count, TclObject[] elements, int from, int to) throws TclException {
        int i;
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclList.replace() called with shared object");
        }
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.alist.size();
        if (index >= size) {
            index = size;
        } else {
            if (index < 0) {
                index = 0;
            }
            if (count > size - index) {
                count = size - index;
            }
            for (i = 0; i < count; ++i) {
                TclObject obj = (TclObject)((Object)tlist.alist.get(index));
                obj.release();
                tlist.alist.remove(index);
            }
        }
        for (i = from; i <= to; ++i) {
            elements[i].preserve();
            tlist.alist.add(index++, elements[i]);
        }
    }

    static void sort(Interp interp, TclObject tobj, int sortMode, int sortIndex, boolean sortIncreasing, String command) throws TclException {
        if (!tobj.isListType()) {
            TclList.setListFromAny(interp, tobj);
        }
        tobj.invalidateStringRep();
        TclList tlist = (TclList)tobj.getInternalRep();
        int size = tlist.alist.size();
        if (size <= 1) {
            return;
        }
        TclObject[] objArray = new TclObject[size];
        for (int i = 0; i < size; ++i) {
            objArray[i] = (TclObject)((Object)tlist.alist.get(i));
        }
        QSort s = new QSort();
        s.sort(interp, objArray, sortMode, sortIndex, sortIncreasing, command);
        for (int i = 0; i < size; ++i) {
            tlist.alist.set(i, objArray[i]);
            objArray[i] = null;
        }
    }
}

