/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas3D.CanvasParameter;
import com.onemoonscientific.swank.canvas3D.SwkImageCanvas;
import com.onemoonscientific.swank.canvas3D.SwkShape;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class SwkShapeRunnable
implements Runnable {
    String tag = null;
    CanvasParameter[] parameters = null;
    SwkImageCanvas swkCanvas = null;
    SwkShape swkShape = null;

    public SwkShapeRunnable(SwkImageCanvas swkCanvas, String tag, CanvasParameter[] parameters) {
        this.swkCanvas = swkCanvas;
        this.tag = tag;
        this.parameters = parameters;
    }

    public SwkShapeRunnable(SwkImageCanvas swkCanvas, SwkShape swkShape, CanvasParameter[] parameters) {
        this.swkCanvas = swkCanvas;
        this.tag = null;
        this.swkShape = swkShape;
        this.parameters = parameters;
    }

    public void exec() {
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        if (this.parameters != null) {
            if (this.swkShape != null) {
                this.configShape(this.swkShape);
            } else {
                Vector shapeList = null;
                try {
                    shapeList = this.swkCanvas.getShapesWithTags(this.tag);
                }
                catch (SwkException swkE) {
                    // empty catch block
                }
                if (shapeList != null) {
                    for (int i = 0; i < shapeList.size(); ++i) {
                        SwkShape swkShape = (SwkShape)shapeList.elementAt(i);
                        this.configShape(swkShape);
                    }
                    if (shapeList.size() > 0) {
                        this.swkCanvas.repaint();
                    }
                }
            }
        }
    }

    public void configShape(SwkShape swkShape) {
        System.out.println("configshape");
        for (int j = 0; j < this.parameters.length; ++j) {
            if (this.parameters[j] == null) continue;
            System.out.println("configshape");
            this.parameters[j].exec(this.swkCanvas, swkShape);
        }
        swkShape.updateShape();
    }
}

