/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.stdlib.Str;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Pervasives", source="byterun/compare.c")
public final class Compare {
    public static final long LESS = -1L;
    public static final Value LESS_VALUE = Value.createLong(-1L);
    public static final long EQUAL = 0L;
    public static final Value EQUAL_VALUE = Value.createLong(0L);
    public static final long GREATER = 1L;
    public static final Value GREATER_VALUE = Value.createLong(1L);
    public static final long UNORDERED = Long.MIN_VALUE;
    public static final Value UNORDERED_VALUE = Value.createLong(Long.MIN_VALUE);

    private Compare() {
    }

    private static long compareDoubles(double d, double d2, boolean bl) {
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (d < d2) {
                return -1L;
            }
            if (d > d2) {
                return 1L;
            }
            return 0L;
        }
        if (!bl) {
            return Long.MIN_VALUE;
        }
        if (!Double.isNaN(d) && Double.isNaN(d2)) {
            return 1L;
        }
        if (Double.isNaN(d) && !Double.isNaN(d2)) {
            return -1L;
        }
        return 0L;
    }

    private static long compare(Value value, Value value2, boolean bl) throws FailException {
        Value value3 = value;
        Value value4 = value2;
        LinkedList<Value> linkedList = new LinkedList<Value>();
        block17: while (true) {
            int n;
            Object object;
            Object object2;
            if ((value3 == value4 || value3.isLong() && value4.isLong() && value3.asLong() == value4.asLong()) && bl) {
                if (linkedList.isEmpty()) {
                    return 0L;
                }
                value4 = (Value)linkedList.remove(0);
                value3 = (Value)linkedList.remove(0);
                continue;
            }
            if (value3.isLong()) {
                if (value3 == value4 || value4.isLong() && value3.asLong() == value4.asLong()) {
                    if (linkedList.isEmpty()) {
                        return 0L;
                    }
                    value4 = (Value)linkedList.remove(0);
                    value3 = (Value)linkedList.remove(0);
                    continue;
                }
                if (value4.isLong()) {
                    return value3.asLong() - value4.asLong();
                }
                switch (value4.getTag()) {
                    case 250: {
                        value4 = value4.get0();
                        continue block17;
                    }
                    case 255: {
                        object2 = value4.getCustomOperations();
                        if (object2.isComparableWithLong()) break;
                        object = new AtomicBoolean();
                        n = object2.compareExt(value3, value4, (AtomicBoolean)object);
                        if (((AtomicBoolean)object).get() && !bl) {
                            return Long.MIN_VALUE;
                        }
                        if (n != 0) {
                            return n;
                        }
                        if (linkedList.isEmpty()) {
                            return 0L;
                        }
                        value4 = (Value)linkedList.remove(0);
                        value3 = (Value)linkedList.remove(0);
                        continue block17;
                    }
                }
                return -1L;
            }
            if (value4.isLong()) {
                switch (value3.getTag()) {
                    case 250: {
                        value3 = value3.get0();
                        continue block17;
                    }
                    case 255: {
                        object2 = value3.getCustomOperations();
                        if (object2.isComparableWithLong()) break;
                        object = new AtomicBoolean();
                        n = object2.compareExt(value3, value4, (AtomicBoolean)object);
                        if (((AtomicBoolean)object).get() && !bl) {
                            return Long.MIN_VALUE;
                        }
                        if (n != 0) {
                            return n;
                        }
                        if (linkedList.isEmpty()) {
                            return 0L;
                        }
                        value4 = (Value)linkedList.remove(0);
                        value3 = (Value)linkedList.remove(0);
                        continue block17;
                    }
                }
                if (value3.getTag() == 250) {
                    value3 = value3.get0();
                    continue;
                }
                return 1L;
            }
            object2 = value3.asBlock();
            object = value4.asBlock();
            n = ((Value)object2).getTag();
            int n2 = ((Value)object).getTag();
            if (n == 250) {
                value3 = ((Value)object2).get0();
                continue;
            }
            if (n2 == 250) {
                value4 = ((Value)object).get0();
                continue;
            }
            if (n != n2) {
                return n - n2;
            }
            switch (n) {
                case 252: {
                    long l;
                    if (value3 == value4 || (l = (long)Str.compare((Value)object2, (Value)object)) == 0L) break;
                    return l;
                }
                case 253: {
                    long l = Compare.compareDoubles(((Value)object2).asDouble(), ((Value)object).asDouble(), bl);
                    if (l == 0L) break;
                    return l;
                }
                case 254: {
                    long l;
                    long l2;
                    long l3 = ((Value)object2).sizeDoubles();
                    long l4 = ((Value)object).sizeDoubles();
                    if (l3 != l4) {
                        return l3 - l4;
                    }
                    for (l2 = 0L; l2 < l3; ++l2) {
                        l = Compare.compareDoubles(((Value)object2).getDouble(l2), ((Value)object).getDouble(l2), bl);
                        if (l == 0L) continue;
                        return l;
                    }
                    break;
                }
                case 251: {
                    Fail.invalidArgument("equal: abstract value");
                    break;
                }
                case 247: 
                case 249: {
                    Fail.invalidArgument("equal: functional value");
                    break;
                }
                case 248: {
                    long l2 = ((Value)object2).get1().asLong();
                    long l = ((Value)object).get1().asLong();
                    if (l2 == l) break;
                    return l2 - l;
                }
                case 255: {
                    CustomOperations customOperations = ((Value)object2).getCustomOperations();
                    if (!customOperations.isComparable()) {
                        Fail.invalidArgument("equal: abstract value");
                    }
                    if (!customOperations.getClass().equals(((Value)object).getCustomOperations().getClass())) {
                        int n3 = customOperations.getIdentifier().compareTo(((Value)object).getCustomOperations().getIdentifier());
                        if (n3 < 0) {
                            return -1L;
                        }
                        if (n3 > 0) {
                            return 1L;
                        }
                        return 0L;
                    }
                    AtomicBoolean atomicBoolean = new AtomicBoolean();
                    long l = customOperations.compare(value3, value4, atomicBoolean);
                    if (atomicBoolean.get() && !bl) {
                        return Long.MIN_VALUE;
                    }
                    if (l == 0L) break;
                    return l;
                }
                default: {
                    long l = ((Value)object2).sizeValues();
                    long l5 = ((Value)object).sizeValues();
                    if (l != l5) {
                        return l - l5;
                    }
                    if (l == 0L) break;
                    for (long i = l - 1L; i >= 1L; --i) {
                        linkedList.add(0, ((Value)object2).get(i));
                        linkedList.add(0, ((Value)object).get(i));
                    }
                    value3 = ((Value)object2).get0();
                    value4 = ((Value)object).get0();
                    continue block17;
                }
            }
            if (linkedList.isEmpty()) {
                return 0L;
            }
            value4 = (Value)linkedList.remove(0);
            value3 = (Value)linkedList.remove(0);
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="int")
    public static Value caml_compare(Value value, Value value2) throws FailException {
        return Value.createLong(Long.signum(Compare.compare(value, value2, true)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_equal(Value value, Value value2) throws FailException {
        if (value == value2) {
            return Value.TRUE;
        }
        return Compare.compare(value, value2, false) == 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_notequal(Value value, Value value2) throws FailException {
        if (value == value2) {
            return Value.FALSE;
        }
        return Compare.compare(value, value2, false) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_lessthan(Value value, Value value2) throws FailException {
        return Compare.compare(value, value2, false) < 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_lessequal(Value value, Value value2) throws FailException {
        return Compare.compare(value, value2, false) <= 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_greaterthan(Value value, Value value2) throws FailException {
        return Compare.compare(value, value2, false) > 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="bool")
    public static Value caml_greaterequal(Value value, Value value2) throws FailException {
        return Compare.compare(value, value2, false) >= 0L ? Value.TRUE : Value.FALSE;
    }
}

