/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;

public class ScriptEvaluator
extends ClassBodyEvaluator {
    public static final String DEFAULT_METHOD_NAME = "eval";
    public static final String[] ZERO_STRINGS = new String[0];
    private boolean staticMethod = true;
    private Class returnType = Void.TYPE;
    private String methodName = "eval";
    private String[] parameterNames = ZERO_STRINGS;
    private Class[] parameterTypes = ClassBodyEvaluator.ZERO_CLASSES;
    private Class[] thrownExceptions = ClassBodyEvaluator.ZERO_CLASSES;
    private Method method = null;

    public ScriptEvaluator(String script) throws CompileException, Parser.ParseException, Scanner.ScanException {
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class returnType) throws CompileException, Parser.ParseException, Scanner.ScanException {
        this.setReturnType(returnType);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class returnType, String[] parameterNames, Class[] parameterTypes) throws CompileException, Parser.ParseException, Scanner.ScanException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions) throws CompileException, Parser.ParseException, Scanner.ScanException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.cook(script);
    }

    public ScriptEvaluator(String optionalFileName, InputStream is, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, is);
    }

    public ScriptEvaluator(String optionalFileName, Reader reader, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, reader);
    }

    public ScriptEvaluator(Scanner scanner, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, Class optionalExtendedType, Class[] implementedTypes, Class returnType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setExtendedType(optionalExtendedType);
        this.setImplementedTypes(implementedTypes);
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class[] implementedTypes, boolean staticMethod, Class returnType, String methodName, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws Scanner.ScanException, Parser.ParseException, CompileException, IOException {
        this.setClassName(className);
        this.setExtendedType(optionalExtendedType);
        this.setImplementedTypes(implementedTypes);
        this.setStaticMethod(staticMethod);
        this.setReturnType(returnType);
        this.setMethodName(methodName);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator() {
    }

    public void setStaticMethod(boolean staticMethod) {
        this.staticMethod = staticMethod;
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameters(String[] parameterNames, Class[] parameterTypes) {
        if (parameterNames.length != parameterTypes.length) {
            throw new IllegalArgumentException("Parameter names and types counts do not match");
        }
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
    }

    public void setThrownExceptions(Class[] thrownExceptions) {
        if (thrownExceptions == null) {
            throw new NullPointerException("Zero thrown exceptions must be specified as \"new Class[0]\", not \"null\"");
        }
        this.thrownExceptions = thrownExceptions;
    }

    protected void internalCook(Scanner scanner) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        Java.CompilationUnit compilationUnit = this.makeCompilationUnit(scanner);
        Java.Block block = this.addClassMethodBlockDeclaration(scanner.location(), compilationUnit, this.returnType);
        Parser parser = new Parser(scanner);
        while (!scanner.peek().isEOF()) {
            block.addStatement(parser.parseBlockStatement());
        }
        this.compileToMethod(compilationUnit);
    }

    protected void compileToMethod(Java.CompilationUnit compilationUnit) throws CompileException {
        Class c = this.compileToClass(compilationUnit, DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION, this.className);
        try {
            this.method = c.getMethod(this.methodName, this.parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("SNO: Loaded class does not declare method \"" + this.methodName + "\"");
        }
    }

    protected Java.Block addClassMethodBlockDeclaration(Location location, Java.CompilationUnit compilationUnit, Class returnType) throws Parser.ParseException {
        if (this.parameterNames.length != this.parameterTypes.length) {
            throw new RuntimeException("Lengths of \"parameterNames\" and \"parameterTypes\" do not match");
        }
        Java.PackageMemberClassDeclaration cd = this.addPackageMemberClassDeclaration(location, compilationUnit);
        Java.Block b = new Java.Block(location);
        Java.FunctionDeclarator.FormalParameter[] fps = new Java.FunctionDeclarator.FormalParameter[this.parameterNames.length];
        for (int i = 0; i < fps.length; ++i) {
            fps[i] = new Java.FunctionDeclarator.FormalParameter(location, true, this.classToType(location, this.parameterTypes[i]), this.parameterNames[i]);
        }
        Java.MethodDeclarator md = new Java.MethodDeclarator(location, null, this.staticMethod ? (short)9 : 1, this.classToType(location, returnType), this.methodName, fps, this.classesToTypes(location, this.thrownExceptions), b);
        cd.addDeclaredMethod(md);
        return b;
    }

    public static Object createFastScriptEvaluator(String script, Class interfaceToImplement, String[] parameterNames) throws CompileException, Parser.ParseException, Scanner.ScanException {
        ScriptEvaluator se = new ScriptEvaluator();
        return ScriptEvaluator.createFastEvaluator(se, script, parameterNames, interfaceToImplement);
    }

    public static Object createFastScriptEvaluator(Scanner scanner, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setParentClassLoader(optionalParentClassLoader);
        return ScriptEvaluator.createFastEvaluator(se, scanner, parameterNames, interfaceToImplement);
    }

    public static Object createFastScriptEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setClassName(className);
        se.setExtendedType(optionalExtendedType);
        se.setParentClassLoader(optionalParentClassLoader);
        return ScriptEvaluator.createFastEvaluator(se, scanner, parameterNames, interfaceToImplement);
    }

    public static Object createFastScriptEvaluator(Scanner scanner, String[] optionalDefaultImports, String className, Class optionalExtendedType, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setClassName(className);
        se.setExtendedType(optionalExtendedType);
        se.setDefaultImports(optionalDefaultImports);
        se.setParentClassLoader(optionalParentClassLoader);
        return ScriptEvaluator.createFastEvaluator(se, scanner, parameterNames, interfaceToImplement);
    }

    public static Object createFastEvaluator(ScriptEvaluator se, String s, String[] parameterNames, Class interfaceToImplement) throws CompileException, Parser.ParseException, Scanner.ScanException {
        try {
            return ScriptEvaluator.createFastEvaluator(se, new Scanner(null, new StringReader(s)), parameterNames, interfaceToImplement);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException despite StringReader");
        }
    }

    public static Object createFastEvaluator(ScriptEvaluator se, Scanner scanner, String[] parameterNames, Class interfaceToImplement) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        if (!interfaceToImplement.isInterface()) {
            throw new RuntimeException("\"" + interfaceToImplement + "\" is not an interface");
        }
        Method[] methods = interfaceToImplement.getDeclaredMethods();
        if (methods.length != 1) {
            throw new RuntimeException("Interface \"" + interfaceToImplement + "\" must declare exactly one method");
        }
        Method methodToImplement = methods[0];
        se.setImplementedTypes(new Class[]{interfaceToImplement});
        se.setStaticMethod(false);
        se.setReturnType(methodToImplement.getReturnType());
        se.setMethodName(methodToImplement.getName());
        se.setParameters(parameterNames, methodToImplement.getParameterTypes());
        se.setThrownExceptions(methodToImplement.getExceptionTypes());
        se.cook(scanner);
        Class<?> c = se.getMethod().getDeclaringClass();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Object evaluate(Object[] parameterValues) throws InvocationTargetException {
        if (this.method == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        try {
            return this.method.invoke(null, parameterValues);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public Method getMethod() {
        if (this.method == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.method;
    }
}

