/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.Opcode;
import org.codehaus.janino.util.ClassFile;

public class CodeContext {
    private static final boolean DEBUG = false;
    private static final int INITIAL_SIZE = 100;
    private static final int SIZE_INCREMENT = 128;
    private ClassFile classFile;
    private short maxStack;
    private short maxLocals;
    private byte[] code;
    private Offset beginning;
    private Inserter end;
    private Inserter currentInserter;
    private List exceptionTableEntries;
    private static final byte UNEXAMINED = -1;
    private static final byte INVALID_OFFSET = -2;
    private short localVariableArrayLength = 0;
    private final Stack savedLocalVariableArrayLengths = new Stack();
    private final List relocatables = new ArrayList();

    public CodeContext(ClassFile classFile) {
        this.classFile = classFile;
        this.maxStack = 0;
        this.maxLocals = 0;
        this.code = new byte[100];
        this.beginning = new Offset();
        this.currentInserter = this.end = new Inserter();
        this.exceptionTableEntries = new ArrayList();
        this.beginning.offset = 0;
        this.end.offset = 0;
        this.beginning.next = this.end;
        this.end.prev = this.beginning;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public short allocateLocalVariable(short size) {
        short res = this.localVariableArrayLength;
        this.localVariableArrayLength = (short)(this.localVariableArrayLength + size);
        if (this.localVariableArrayLength > this.maxLocals) {
            this.maxLocals = this.localVariableArrayLength;
        }
        return res;
    }

    public void saveLocalVariables() {
        this.savedLocalVariableArrayLengths.push(new Short(this.localVariableArrayLength));
    }

    public void restoreLocalVariables() {
        this.localVariableArrayLength = (Short)this.savedLocalVariableArrayLengths.pop();
    }

    protected void storeCodeAttributeBody(DataOutputStream dos, short lineNumberTableAttributeNameIndex) throws IOException {
        dos.writeShort(this.maxStack);
        dos.writeShort(this.maxLocals);
        dos.writeInt(0xFFFF & this.end.offset);
        dos.write(this.code, 0, 0xFFFF & this.end.offset);
        dos.writeShort(this.exceptionTableEntries.size());
        for (int i = 0; i < this.exceptionTableEntries.size(); ++i) {
            ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.exceptionTableEntries.get(i);
            dos.writeShort(((ExceptionTableEntry)exceptionTableEntry).startPC.offset);
            dos.writeShort(((ExceptionTableEntry)exceptionTableEntry).endPC.offset);
            dos.writeShort(((ExceptionTableEntry)exceptionTableEntry).handlerPC.offset);
            dos.writeShort(exceptionTableEntry.catchType);
        }
        ArrayList<ClassFile.LineNumberTableAttribute> attributes = new ArrayList<ClassFile.LineNumberTableAttribute>();
        if (lineNumberTableAttributeNameIndex != 0) {
            ArrayList<ClassFile.LineNumberTableAttribute.Entry> lnt = new ArrayList<ClassFile.LineNumberTableAttribute.Entry>();
            Offset o = this.beginning;
            while (o != null) {
                if (o instanceof LineNumberOffset) {
                    lnt.add(new ClassFile.LineNumberTableAttribute.Entry(o.offset, ((LineNumberOffset)o).lineNumber));
                }
                o = o.next;
            }
            ClassFile.LineNumberTableAttribute.Entry[] lnte = lnt.toArray(new ClassFile.LineNumberTableAttribute.Entry[lnt.size()]);
            attributes.add(new ClassFile.LineNumberTableAttribute(lineNumberTableAttributeNameIndex, lnte));
        }
        dos.writeShort(attributes.size());
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            ClassFile.AttributeInfo attribute = (ClassFile.AttributeInfo)it.next();
            attribute.store(dos);
        }
    }

    public void flowAnalysis(String functionName) {
        int i;
        byte[] stackSizes = new byte[0xFFFF & this.end.offset];
        Arrays.fill(stackSizes, (byte)-1);
        this.flowAnalysis(functionName, this.code, 0xFFFF & this.end.offset, 0, 0, stackSizes);
        int analyzedExceptionHandlers = 0;
        while (analyzedExceptionHandlers != this.exceptionTableEntries.size()) {
            for (i = 0; i < this.exceptionTableEntries.size(); ++i) {
                ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)this.exceptionTableEntries.get(i);
                if (stackSizes[0xFFFF & ((ExceptionTableEntry)exceptionTableEntry).startPC.offset] == -1) continue;
                this.flowAnalysis(functionName, this.code, 0xFFFF & this.end.offset, 0xFFFF & ((ExceptionTableEntry)exceptionTableEntry).handlerPC.offset, stackSizes[0xFFFF & ((ExceptionTableEntry)exceptionTableEntry).startPC.offset] + 1, stackSizes);
                ++analyzedExceptionHandlers;
            }
        }
        this.maxStack = 0;
        for (i = 0; i < stackSizes.length; ++i) {
            byte ss = stackSizes[i];
            if (ss == -1) {
                throw new RuntimeException(functionName + ": Unexamined code at offset " + i);
            }
            if (ss <= this.maxStack) continue;
            this.maxStack = ss;
        }
    }

    private void flowAnalysis(String functionName, byte[] code, int codeSize, int offset, int stackSize, byte[] stackSizes) {
        while (true) {
            short props;
            if (offset < 0 || offset >= codeSize) {
                throw new RuntimeException(functionName + ": Offset out of range");
            }
            byte css = stackSizes[offset];
            if (css == stackSize) {
                return;
            }
            if (css == -2) {
                throw new RuntimeException(functionName + ": Invalid offset");
            }
            if (css != -1) {
                throw new RuntimeException(functionName + ": Operand stack inconsistent at offset " + offset + ": Previous size " + css + ", now " + stackSize);
            }
            stackSizes[offset] = (byte)stackSize;
            byte opcode = code[offset];
            int operandOffset = offset + 1;
            if (opcode == -60) {
                opcode = code[operandOffset++];
                props = Opcode.WIDE_OPCODE_PROPERTIES[0xFF & opcode];
            } else {
                props = Opcode.OPCODE_PROPERTIES[0xFF & opcode];
            }
            if (props == -1) {
                throw new RuntimeException(functionName + ": Invalid opcode " + (0xFF & opcode) + " at offset " + offset);
            }
            switch (props & 0x1F) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    stackSize += (props & 0x1F) - 4;
                    break;
                }
                case 7: {
                    stackSize = 0;
                    break;
                }
                case 9: {
                    --stackSize;
                }
                case 10: {
                    stackSize += this.determineFieldSize((short)((code[operandOffset] << 8) + (0xFF & code[operandOffset + 1])));
                    break;
                }
                case 11: {
                    --stackSize;
                }
                case 12: {
                    stackSize -= this.determineFieldSize((short)((code[operandOffset] << 8) + (0xFF & code[operandOffset + 1])));
                    break;
                }
                case 13: 
                case 14: 
                case 16: {
                    --stackSize;
                }
                case 15: {
                    stackSize -= this.determineArgumentsSize((short)((code[operandOffset] << 8) + (0xFF & code[operandOffset + 1])));
                    break;
                }
                case 18: {
                    stackSize -= code[operandOffset + 2] - 1;
                    break;
                }
                default: {
                    throw new RuntimeException(functionName + ": Invalid stack delta");
                }
            }
            if (stackSize < 0) {
                String msg = this.classFile.getThisClassName() + '.' + functionName + ": Operand stack underrun at offset " + offset;
                throw new RuntimeException(msg);
            }
            if (stackSize > 127) {
                String msg = this.classFile.getThisClassName() + '.' + functionName + ": Operand stack overflow at offset " + offset;
                throw new RuntimeException(msg);
            }
            switch (props & 0x1E0) {
                case 0: {
                    break;
                }
                case 32: 
                case 64: 
                case 128: 
                case 192: {
                    ++operandOffset;
                    break;
                }
                case 96: 
                case 160: 
                case 224: {
                    operandOffset += 2;
                    break;
                }
                case 256: {
                    this.flowAnalysis(functionName, code, codeSize, offset + ((code[operandOffset++] << 8) + (0xFF & code[operandOffset++])), stackSize, stackSizes);
                    break;
                }
                case 384: {
                    int targetOffset = offset + ((code[operandOffset++] << 8) + (0xFF & code[operandOffset++]));
                    if (stackSizes[targetOffset] != -1) break;
                    this.flowAnalysis(functionName, code, codeSize, targetOffset, stackSize + 1, stackSizes);
                    break;
                }
                case 288: {
                    this.flowAnalysis(functionName, code, codeSize, offset + ((code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++])), stackSize, stackSizes);
                    break;
                }
                case 320: {
                    while ((operandOffset & 3) != 0) {
                        ++operandOffset;
                    }
                    this.flowAnalysis(functionName, code, codeSize, offset + ((code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++])), stackSize, stackSizes);
                    int npairs = (code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++]);
                    for (int i = 0; i < npairs; ++i) {
                        operandOffset += 4;
                        this.flowAnalysis(functionName, code, codeSize, offset + ((code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++])), stackSize, stackSizes);
                    }
                    break;
                }
                case 352: {
                    while ((operandOffset & 3) != 0) {
                        ++operandOffset;
                    }
                    this.flowAnalysis(functionName, code, codeSize, offset + ((code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++])), stackSize, stackSizes);
                    int low = (code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++]);
                    int hi = (code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++]);
                    for (int i = low; i <= hi; ++i) {
                        this.flowAnalysis(functionName, code, codeSize, offset + ((code[operandOffset++] << 24) + ((0xFF & code[operandOffset++]) << 16) + ((0xFF & code[operandOffset++]) << 8) + (0xFF & code[operandOffset++])), stackSize, stackSizes);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(functionName + ": Invalid OP1");
                }
            }
            switch (props & 0x600) {
                case 0: {
                    break;
                }
                case 512: {
                    ++operandOffset;
                    break;
                }
                case 1024: {
                    operandOffset += 2;
                    break;
                }
                default: {
                    throw new RuntimeException(functionName + ": Invalid OP2");
                }
            }
            switch (props & 0x800) {
                case 0: {
                    break;
                }
                case 2048: {
                    ++operandOffset;
                    break;
                }
                default: {
                    throw new RuntimeException(functionName + ": Invalid OP3");
                }
            }
            Arrays.fill(stackSizes, offset + 1, operandOffset, (byte)-2);
            if ((props & Short.MIN_VALUE) != 0) {
                return;
            }
            offset = operandOffset;
        }
    }

    public void fixUp() {
        Offset o = this.beginning;
        while (o != this.end) {
            if (o instanceof FixUp) {
                ((FixUp)((Object)o)).fixUp();
            }
            o = o.next;
        }
    }

    public void relocate() {
        for (int i = 0; i < this.relocatables.size(); ++i) {
            ((Relocatable)this.relocatables.get(i)).relocate();
        }
    }

    private int determineFieldSize(short idx) {
        ClassFile.ConstantFieldrefInfo cfi = (ClassFile.ConstantFieldrefInfo)this.classFile.getConstantPoolInfo(idx);
        ClassFile.ConstantNameAndTypeInfo cnati = (ClassFile.ConstantNameAndTypeInfo)this.classFile.getConstantPoolInfo(cfi.getNameAndTypeIndex());
        ClassFile.ConstantUtf8Info cui = (ClassFile.ConstantUtf8Info)this.classFile.getConstantPoolInfo(cnati.getDescriptorIndex());
        return Descriptor.size(cui.getString());
    }

    /*
     * Unable to fully structure code
     */
    private int determineArgumentsSize(short idx) {
        cpi = this.classFile.getConstantPoolInfo(idx);
        nat = (ClassFile.ConstantNameAndTypeInfo)this.classFile.getConstantPoolInfo(cpi instanceof ClassFile.ConstantInterfaceMethodrefInfo != false ? ((ClassFile.ConstantInterfaceMethodrefInfo)cpi).getNameAndTypeIndex() : ((ClassFile.ConstantMethodrefInfo)cpi).getNameAndTypeIndex());
        cui = (ClassFile.ConstantUtf8Info)this.classFile.getConstantPoolInfo(nat.getDescriptorIndex());
        desc = cui.getString();
        if (desc.charAt(0) != '(') {
            throw new RuntimeException("Method descriptor does not start with \"(\"");
        }
        i = 1;
        res = 0;
        block7: while (true) {
            switch (desc.charAt(i++)) {
                case ')': {
                    return res - Descriptor.size(desc.substring(i));
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++res;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    res += 2;
                    continue block7;
                }
                case '[': {
                    ++res;
                    while (desc.charAt(i) == '[') {
                        ++i;
                    }
                    if ("BCFISZDJ".indexOf(desc.charAt(i)) != -1) {
                        ++i;
                        continue block7;
                    }
                    if (desc.charAt(i) != 'L') {
                        throw new RuntimeException("Invalid char after \"[\"");
                    }
                    while (true) {
                        v0 = ++i;
                        ++i;
                        if (desc.charAt(v0) == ';') continue block7;
                    }
                }
                case 'L': {
                    ++res;
                    while (true) {
                        if (desc.charAt(i++) != ';') ** break;
                        continue block7;
                    }
                }
            }
            break;
        }
        throw new RuntimeException("Invalid method descriptor");
    }

    public void write(short lineNumber, byte[] b) {
        block8: {
            if (b.length == 0) {
                return;
            }
            if (lineNumber != -1) {
                Offset o = this.currentInserter.prev;
                while (o != this.beginning) {
                    if (o instanceof LineNumberOffset) {
                        if (((LineNumberOffset)o).lineNumber != lineNumber) break;
                        break block8;
                    }
                    o = o.prev;
                }
                LineNumberOffset lno = new LineNumberOffset(this.currentInserter.offset, lineNumber);
                lno.prev = this.currentInserter.prev;
                lno.next = this.currentInserter;
                this.currentInserter.prev.next = lno;
                this.currentInserter.prev = lno;
            }
        }
        int ico = 0xFFFF & this.currentInserter.offset;
        if ((0xFFFF & this.end.offset) + b.length <= this.code.length) {
            System.arraycopy(this.code, ico, this.code, ico + b.length, (0xFFFF & this.end.offset) - ico);
        } else {
            byte[] oldCode = this.code;
            this.code = new byte[this.code.length + 128];
            if (this.code.length >= 65535) {
                throw new RuntimeException("Code attribute in class \"" + this.classFile.getThisClassName() + "\" grows beyond 64 KB");
            }
            System.arraycopy(oldCode, 0, this.code, 0, ico);
            System.arraycopy(oldCode, ico, this.code, ico + b.length, (0xFFFF & this.end.offset) - ico);
        }
        System.arraycopy(b, 0, this.code, ico, b.length);
        Offset o = this.currentInserter;
        while (o != null) {
            o.offset = (short)(o.offset + b.length);
            o = o.next;
        }
    }

    public void writeShort(short lineNumber, int v) {
        this.write(lineNumber, new byte[]{(byte)(v >> 8), (byte)v});
    }

    public void writeBranch(short lineNumber, int opcode, Offset dst) {
        this.relocatables.add(new Branch(this.newOffset(), dst));
        this.write(lineNumber, new byte[]{(byte)opcode, -1, -1});
    }

    public void writeOffset(short lineNumber, Offset src, Offset dst) {
        this.relocatables.add(new OffsetBranch(this.newOffset(), src, dst));
        this.write(lineNumber, new byte[]{-1, -1, -1, -1});
    }

    public Offset newOffset() {
        Offset o = new Offset();
        o.set();
        return o;
    }

    public Inserter newInserter() {
        Inserter i = new Inserter();
        i.set();
        return i;
    }

    public void pushInserter(Inserter ins) {
        if (ins.nextInserter != null) {
            throw new RuntimeException("An Inserter can only be pushed once at a time");
        }
        ins.nextInserter = this.currentInserter;
        this.currentInserter = ins;
    }

    public void popInserter() {
        Inserter ni = this.currentInserter.nextInserter;
        if (ni == null) {
            throw new RuntimeException("Code inserter stack underflow");
        }
        this.currentInserter.nextInserter = null;
        this.currentInserter = ni;
    }

    public void addExceptionTableEntry(Offset startPC, Offset endPC, Offset handlerPC, String catchTypeFD) {
        this.exceptionTableEntries.add(new ExceptionTableEntry(startPC, endPC, handlerPC, catchTypeFD == null ? (short)0 : this.classFile.addConstantClassInfo(catchTypeFD)));
    }

    public static interface FixUp {
        public void fixUp();
    }

    private abstract class Relocatable {
        private Relocatable() {
        }

        public abstract void relocate();
    }

    public class LineNumberOffset
    extends Offset {
        private final short lineNumber;

        public LineNumberOffset(short offset, short lineNumber) {
            this.lineNumber = lineNumber;
            this.offset = offset;
        }
    }

    public class Inserter
    extends Offset {
        private Inserter nextInserter = null;
    }

    private static class ExceptionTableEntry {
        private final Offset startPC;
        private final Offset endPC;
        private final Offset handlerPC;
        private final short catchType;

        public ExceptionTableEntry(Offset startPC, Offset endPC, Offset handlerPC, short catchType) {
            this.startPC = startPC;
            this.endPC = endPC;
            this.handlerPC = handlerPC;
            this.catchType = catchType;
        }
    }

    public class Offset {
        short offset = (short)-1;
        Offset prev = null;
        Offset next = null;
        static final short UNSET = -1;

        public void set() {
            if (this.offset != -1) {
                throw new RuntimeException("Cannot \"set()\" Offset more than once");
            }
            this.offset = ((CodeContext)CodeContext.this).currentInserter.offset;
            this.prev = ((CodeContext)CodeContext.this).currentInserter.prev;
            this.next = CodeContext.this.currentInserter;
            this.prev.next = this;
            this.next.prev = this;
        }

        public final CodeContext getCodeContext() {
            return CodeContext.this;
        }

        public String toString() {
            return CodeContext.this.classFile.getThisClassName() + ": " + (0xFFFF & this.offset);
        }
    }

    private class OffsetBranch
    extends Relocatable {
        private final Offset where;
        private final Offset source;
        private final Offset destination;

        public OffsetBranch(Offset where, Offset source, Offset destination) {
            this.where = where;
            this.source = source;
            this.destination = destination;
        }

        public void relocate() {
            if (this.source.offset == -1 || this.destination.offset == -1) {
                throw new RuntimeException("Cannot relocate offset branch to unset destination offset");
            }
            int offset = this.destination.offset - this.source.offset;
            byte[] ba = new byte[]{(byte)(offset >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)offset};
            System.arraycopy(ba, 0, CodeContext.this.code, 0xFFFF & this.where.offset, 4);
        }
    }

    private class Branch
    extends Relocatable {
        private final Offset source;
        private final Offset destination;

        public Branch(Offset source, Offset destination) {
            this.source = source;
            this.destination = destination;
        }

        public void relocate() {
            if (this.destination.offset == -1) {
                throw new RuntimeException("Cannot relocate branch to unset destination offset");
            }
            int offset = this.destination.offset - this.source.offset;
            if (offset > Short.MAX_VALUE || offset < Short.MIN_VALUE) {
                throw new RuntimeException("Branch offset out of range");
            }
            byte[] ba = new byte[]{(byte)(offset >> 8), (byte)offset};
            System.arraycopy(ba, 0, CodeContext.this.code, (0xFFFF & this.source.offset) + 1, 2);
        }
    }
}

