/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalHandler;
import org.ocamljava.runtime.util.SignalKind;

public final class NoSignalSupport {
    public static final SignalHandler DEFAULT_HANDLER = null;
    public static final SignalHandler IGNORE_HANDLER = null;
    static final boolean AVAILABLE = false;
    static final String CLASS_SIGNAL = "sun.misc.Signal";
    static final Constructor<?> CSTR_SIGNAL = null;
    static final Method MTH_SIGNAL_GET_NAME = null;
    static final Method MTH_SIGNAL_GET_NUMBER = null;
    static final Method MTH_SIGNAL_HANDLE = null;
    static final Method MTH_SIGNAL_RAISE = null;
    static final Method MTH_HANDLER_HANDLE = null;

    private NoSignalSupport() {
    }

    public static boolean isAvailable() {
        return false;
    }

    public static boolean handle(SignalHandler signalHandler, Signal ... signalArray) {
        assert (signalHandler != null) : "null handler";
        assert (signalArray != null) : "null signals";
        return false;
    }

    public static void test(PrintStream printStream) {
        assert (printStream != null) : "null out";
        for (SignalKind signalKind : SignalKind.values()) {
            printStream.printf("signal '%s' is unsupported\n", signalKind.name());
        }
    }
}

