/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class StateParameter
extends CanvasParameter {
    private static String name = "state";
    private static int defValue = 0;
    private byte newValue = 0;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-state".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        return TclString.newInstance((String)swkShape.getStateString());
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        String stateString = arg.toString();
        if ("normal".startsWith(stateString)) {
            this.newValue = 0;
        } else if ("hidden".startsWith(stateString)) {
            this.newValue = (byte)2;
        } else if ("disabled".startsWith(stateString)) {
            this.newValue = 1;
        } else {
            throw new TclException(interp, "invalid state argument \"" + stateString + "\"");
        }
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null) {
            swkShape.setState(this.newValue);
        }
    }
}

