/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.ArrowShapeParameter;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.CapstyleParameter;
import com.onemoonscientific.swank.canvas.DashParameter;
import com.onemoonscientific.swank.canvas.DashPhaseParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.FontParameter;
import com.onemoonscientific.swank.canvas.ItemLine;
import com.onemoonscientific.swank.canvas.JoinstyleParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.ShearParameter;
import com.onemoonscientific.swank.canvas.SmoothParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TextInterface;
import com.onemoonscientific.swank.canvas.TextParameter;
import com.onemoonscientific.swank.canvas.TextParameters;
import com.onemoonscientific.swank.canvas.TextcolorParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Map;
import java.util.TreeMap;

public class ItemAnnotation
extends ItemLine
implements TextInterface {
    static CanvasParameter[] parameters = new CanvasParameter[]{new FillParameter(), new SmoothParameter(), new DashParameter(), new DashPhaseParameter(), new WidthParameter(), new RotateParameter(), new ShearParameter(), new TagsParameter(), new StateParameter(), new NodeParameter(), new TransformerParameter(), new CapstyleParameter(), new JoinstyleParameter(), new ArrowShapeParameter(), new TextParameter(), new FontParameter(), new TextcolorParameter()};
    static Map parameterMap = new TreeMap();
    TextParameters textPar = TextParameters.getDefault();

    ItemAnnotation(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.gPath = (GeneralPath)shape;
        this.fill = null;
        this.endPointStyle1 = ItemLine.EndPointStyle.SQUARE;
        this.endPointStyle2 = ItemLine.EndPointStyle.ARROW;
    }

    public String getText() {
        return this.textPar.getText();
    }

    public void setText(String newValue) {
        this.textPar = TextParameters.setText(this.textPar, newValue);
    }

    public float[] getAnchor() {
        return this.textPar.getAnchor();
    }

    public void setAnchor(float[] newValue) {
        this.textPar = TextParameters.setAnchor(this.textPar, newValue);
    }

    public Font getFont() {
        return this.textPar.getFont();
    }

    public void setFont(Font newValue) {
        this.textPar = TextParameters.setFont(this.textPar, newValue);
    }

    public Color getTextColor() {
        return this.textPar.getTextColor();
    }

    public void setTextColor(Color newValue) {
        this.textPar = TextParameters.setTextColor(this.textPar, newValue);
    }

    public void paintShape(Graphics2D g2) {
        if (this.stroke != null) {
            g2.setStroke(this.stroke);
        } else {
            g2.setStroke(bstroke);
        }
        if (this.storeCoords == null) {
            return;
        }
        AffineTransform shapeTransform = this.getTransform();
        g2.setPaint(this.outline);
        if (this.endPointStyle1 == ItemLine.EndPointStyle.NONE && this.endPointStyle2 == ItemLine.EndPointStyle.NONE) {
            if (shapeTransform != null) {
                g2.draw(shapeTransform.createTransformedShape(this.shape));
            } else {
                g2.draw(this.shape);
            }
        } else {
            this.applyCoordinates();
            if (shapeTransform != null) {
                g2.draw(shapeTransform.createTransformedShape(this.shape));
            } else {
                g2.draw(this.shape);
            }
            if (this.lastArrowPath != null) {
                if (shapeTransform != null) {
                    // empty if block
                }
                g2.fill(this.lastArrowPath);
                g2.setStroke(bstroke);
                g2.draw(this.lastArrowPath);
            }
        }
        float[] anchor = new float[2];
        anchor[1] = 0.5f;
        anchor[0] = this.storeCoords[1] > this.storeCoords[3] ? 1.0f : 0.0f;
        this.setAnchor(anchor);
        this.textPar.paint(g2, this.getCanvas().getFontRenderContext(), this, this.storeCoords[0], this.storeCoords[1]);
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "annotation";
    }

    public void drawHandles(Graphics2D g2) {
        if (this.shape != null) {
            double[] xy = new double[]{this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]};
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                shapeTransform.transform(xy, 0, xy, 0, xy.length / 2);
            }
            this.drawHandle(g2, (int)xy[0], (int)xy[1]);
            this.drawHandle(g2, (int)xy[2], (int)xy[3]);
        }
    }

    public int hitHandles(double testX, double testY) {
        int hitIndex = -1;
        if (this.shape != null) {
            double[] xy = new double[]{this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]};
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                shapeTransform.transform(xy, 0, xy, 0, xy.length / 2);
            }
            if (this.hitHandle((int)xy[0], (int)xy[1], testX, testY)) {
                hitIndex = 0;
            } else if (this.hitHandle((int)xy[2], (int)xy[3], testX, testY)) {
                hitIndex = 1;
            }
        }
        return hitIndex;
    }

    public Cursor getHandleCursor(int handle) {
        Cursor cursor;
        switch (handle) {
            case 0: {
                cursor = Cursor.getPredefinedCursor(10);
                break;
            }
            case 1: {
                cursor = Cursor.getPredefinedCursor(11);
                break;
            }
            default: {
                cursor = Cursor.getPredefinedCursor(0);
            }
        }
        return cursor;
    }

    static {
        ItemAnnotation.initializeParameters(parameters, parameterMap);
    }
}

