/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.SwkJDesktopPane;
import com.onemoonscientific.swank.SwkJDesktopPaneWidgetCmd;
import com.onemoonscientific.swank.Widgets;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class SwkJDesktopPaneCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length > 2 && "help".equals(argv[1].toString())) {
            if ("options".startsWith(argv[2].toString())) {
                SwkJDesktopPane.getWidgetOptions(interp);
            } else if ("commands".startsWith(argv[2].toString())) {
                SwkJDesktopPane.getWidgetCmds(interp);
            }
        } else if (!EventQueue.isDispatchThread()) {
            this.cmdProcNotET(interp, argv);
        } else {
            throw new TclException(interp, "Can't create widgets on event queue");
        }
    }

    public void cmdProcNotET(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "pathName ?options?");
        }
        if (!argv[1].toString().startsWith(".")) {
            throw new TclException(interp, "bad window path name \"" + argv[1].toString() + "\"");
        }
        String cmdName = argv[0].toString();
        String className = argv[0].toString().substring(0, 1).toUpperCase() + argv[0].toString().substring(1);
        String widgetName = argv[1].toString();
        CmdProc cmdProc = new CmdProc(interp, className, widgetName);
        try {
            SwingUtilities.invokeAndWait(cmdProc);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        SwkJDesktopPane swkjdesktoppane = cmdProc.getwidget();
        if (Widgets.exists(interp, argv[1].toString())) {
            swkjdesktoppane = (SwkJDesktopPane)Widgets.get(interp, argv[1].toString());
            if (swkjdesktoppane.isCreated()) {
                throw new TclException(interp, "window name \"" + argv[1].toString() + "\" already exists in parent");
            }
            swkjdesktoppane.className = className.intern();
        } else {
            if (argv[1].toString().length() > 1 && Character.isUpperCase(argv[1].toString().charAt(1))) {
                throw new TclException(interp, "window name starts with an upper-case letter: \"" + argv[1].toString().charAt(1) + "\"");
            }
            swkjdesktoppane.className = className.intern();
            Object children = null;
            interp.createCommand(argv[1].toString(), (Command)new SwkJDesktopPaneWidgetCmd());
            TclObject tObj = ReflectObject.newInstance((Interp)interp, SwkJDesktopPane.class, (Object)swkjdesktoppane);
            tObj.preserve();
            swkjdesktoppane.configure(interp, argv, 2);
            Widgets.addNewWidget(interp, argv[1].toString(), tObj);
        }
        swkjdesktoppane.setCreated(true);
        BindCmd.addDefaultListeners(interp, swkjdesktoppane);
        interp.setResult(argv[1].toString());
    }

    class CmdProc
    implements Runnable {
        Interp interp;
        TclObject[] argv = null;
        String className = "";
        String widgetName = "";
        SwkJDesktopPane swkjdesktoppane = null;

        CmdProc(Interp interp, String className, String widgetName) {
            this.interp = interp;
            this.className = className;
            this.widgetName = widgetName;
        }

        public SwkJDesktopPane getwidget() {
            return this.swkjdesktoppane;
        }

        public void run() {
            this.swkjdesktoppane = new SwkJDesktopPane(this.interp, this.widgetName, this.className);
        }
    }
}

