/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ImageCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkJComboBox;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJComboBoxWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "remove", "item", "index"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_REMOVE = 2;
    private static final int OPT_ITEM = 3;
    private static final int OPT_INDEX = 4;
    static boolean gotDefaults = false;
    int index;
    Interp interp = null;
    SwkJComboBox swkjcombobox = null;

    SwkJComboBoxWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        SwkJComboBox swkjcombobox;
        this.interp = interp;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        this.swkjcombobox = swkjcombobox = (SwkJComboBox)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjcombobox.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjcombobox.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjcombobox.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjcombobox.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJComboBox.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjcombobox.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.remove(interp, swkjcombobox, argv);
                break;
            }
            case 3: {
                this.item(interp, swkjcombobox, argv);
                break;
            }
            case 4: {
                this.index(interp, swkjcombobox, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void index(Interp interp, SwkJComboBox swkjcombobox, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        new GetIndex().exec(argv[2].toString());
    }

    void remove(Interp interp, SwkJComboBox swkjcombobox, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        int rIndex = !argv[2].toString().equals("all") ? TclInteger.get((Interp)interp, (TclObject)argv[2]) : -1;
        new RemoveItems().exec(rIndex);
    }

    void item(Interp interp, SwkJComboBox swkjcombobox, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 2, argv, "index ?element element ...?");
        }
        if (argv[2].toString().equals("count")) {
            new GetItemCount().exec();
        } else if (argv[2].toString().equals("name")) {
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            this.index = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            String result = new GetItemAt().exec(this.index);
            interp.setResult(result);
        } else if (argv[2].toString().equals("append")) {
            if (argv.length < 4) {
                throw new TclNumArgsException(interp, 2, argv, "option");
            }
            String[] itemStrings = new String[argv.length - 3];
            for (int i = 3; i < argv.length; ++i) {
                itemStrings[i - 3] = argv[i].toString();
            }
            new AddItems().exec(itemStrings);
        } else {
            throw new TclException(interp, "Invalid item argument");
        }
    }

    class AddItems
    extends GetValueOnEventThread {
        Object[] itemObjects = null;
        String s1 = null;

        AddItems() {
        }

        void exec(String[] itemStrings) {
            this.getObjects(itemStrings);
            this.execOnThread();
            SwkJComboBoxWidgetCmd.this.swkjcombobox.commandListener.setVarValue(this.s1);
            SwkJComboBoxWidgetCmd.this.swkjcombobox.setCreated(true);
        }

        void getObjects(String[] itemStrings) {
            this.itemObjects = new Object[itemStrings.length];
            for (int i = 0; i < itemStrings.length; ++i) {
                if (itemStrings[i].startsWith(".")) {
                    TclObject tObj2 = (TclObject)Widgets.getWidget(SwkJComboBoxWidgetCmd.this.interp, itemStrings[i]);
                    if (tObj2 != null) {
                        try {
                            SwkWidget widget = (SwkWidget)ReflectObject.get((Interp)SwkJComboBoxWidgetCmd.this.interp, (TclObject)tObj2);
                            this.itemObjects[i] = widget;
                        }
                        catch (TclException tclE) {
                            this.itemObjects[i] = itemStrings[i];
                        }
                        continue;
                    }
                    this.itemObjects[i] = itemStrings[i];
                    continue;
                }
                if (itemStrings[i].startsWith("image:") && itemStrings[i].length() > 7) {
                    Object imageObject = ImageCmd.getImage(itemStrings[i].substring(6));
                    if (imageObject != null && imageObject instanceof BufferedImage) {
                        this.itemObjects[i] = (BufferedImage)imageObject;
                        continue;
                    }
                    if (imageObject != null && imageObject instanceof ImageIcon) {
                        this.itemObjects[i] = (ImageIcon)imageObject;
                        continue;
                    }
                    this.itemObjects[i] = itemStrings[i];
                    continue;
                }
                this.itemObjects[i] = itemStrings[i];
            }
        }

        public void run() {
            SwkJComboBoxWidgetCmd.this.swkjcombobox.setCreated(false);
            for (int i = 0; i < this.itemObjects.length; ++i) {
                if (this.itemObjects[i] instanceof SwkWidget) {
                    SwkJComboBoxWidgetCmd.this.swkjcombobox.addItem((SwkWidget)this.itemObjects[i]);
                    continue;
                }
                if (this.itemObjects[i] instanceof BufferedImage) {
                    SwkJComboBoxWidgetCmd.this.swkjcombobox.addItem(this.itemObjects[i]);
                    continue;
                }
                if (this.itemObjects[i] instanceof ImageIcon) {
                    SwkJComboBoxWidgetCmd.this.swkjcombobox.addItem(this.itemObjects[i]);
                    continue;
                }
                SwkJComboBoxWidgetCmd.this.swkjcombobox.addItem((String)this.itemObjects[i]);
            }
            this.s1 = SwkJComboBoxWidgetCmd.this.swkjcombobox.getSelectedItem().toString();
        }
    }

    class GetItemAt
    extends GetValueOnEventThread {
        String result;
        int index = 0;

        GetItemAt() {
        }

        String exec(int index) {
            this.index = index;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            this.result = SwkJComboBoxWidgetCmd.this.swkjcombobox.getItemAt(this.index).toString();
        }
    }

    class GetItemCount
    extends GetValueOnEventThread {
        int intResult;

        GetItemCount() {
        }

        void exec() {
            this.execOnThread();
            SwkJComboBoxWidgetCmd.this.interp.setResult(this.intResult);
        }

        public void run() {
            this.intResult = SwkJComboBoxWidgetCmd.this.swkjcombobox.getItemCount();
        }
    }

    class RemoveItems
    extends UpdateOnEventThread {
        int index = -1;

        RemoveItems() {
        }

        void exec(int index) {
            this.index = index;
            this.execOnThread();
        }

        public void run() {
            SwkJComboBoxWidgetCmd.this.swkjcombobox.setCreated(false);
            if (this.index == -1) {
                SwkJComboBoxWidgetCmd.this.swkjcombobox.removeAllItems();
            } else {
                SwkJComboBoxWidgetCmd.this.swkjcombobox.removeItemAt(this.index);
            }
            SwkJComboBoxWidgetCmd.this.swkjcombobox.setCreated(true);
        }
    }

    class GetIndex
    extends GetValueOnEventThread {
        int index = -1;
        String item = null;

        GetIndex() {
        }

        void exec(String item) {
            this.item = item;
            this.execOnThread();
            SwkJComboBoxWidgetCmd.this.interp.setResult(this.index);
        }

        public void run() {
            for (int i = 0; i < SwkJComboBoxWidgetCmd.this.swkjcombobox.getItemCount(); ++i) {
                if (!SwkJComboBoxWidgetCmd.this.swkjcombobox.getItemAt(i).toString().equals(this.item)) continue;
                this.index = i;
                break;
            }
        }
    }
}

