/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.ImageTestCmd;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class ImageCmd
implements Command {
    public static Hashtable images = new Hashtable();
    static Hashtable builtinImages = new Hashtable();
    static int iImage = 0;
    private static final String[] builtinImageNames = new String[]{"error", "gray12", "gray25", "gray50", "gray75", "hourglass", "info", "question", "questhead", "warning"};
    private static final String[] validCmds = new String[]{"create", "delete", "configure", "types", "names", "object", "edge", "scale"};
    private static final int OPT_CREATE = 0;
    private static final int OPT_DELETE = 1;
    private static final int OPT_CONFIGURE = 2;
    private static final int OPT_TYPES = 3;
    private static final int OPT_NAMES = 4;
    private static final int OPT_OBJECT = 5;
    private static final int OPT_EDGE = 6;
    private static final int OPT_SCALE = 7;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: {
                String imageName;
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                }
                if (!(argv[2].toString().startsWith("bitmap") || argv[2].toString().startsWith("photo") || argv[2].toString().startsWith("obj") || argv[2].toString().startsWith("test"))) {
                    throw new TclException(interp, "image type \"" + argv[2].toString() + "\" doesn't exist");
                }
                int firstOption = 3;
                if (argv[3].toString().startsWith("-")) {
                    imageName = "image" + iImage;
                    ++iImage;
                    firstOption = 3;
                } else {
                    imageName = argv[3].toString();
                    firstOption = 4;
                }
                ImageIcon image = null;
                if (argv[2].toString().equals("test")) {
                    ImageIcon quest = (ImageIcon)builtinImages.get("questhead");
                    image = new ImageIcon(quest.getImage());
                } else {
                    image = new ImageIcon();
                }
                image.setDescription(imageName);
                images.put(imageName, image);
                ImageCmd.configure(interp, image, argv, firstOption);
                if (argv[2].toString().equals("test")) {
                    interp.createCommand(imageName, (Command)new ImageTestCmd());
                } else if (!argv[2].toString().equals("bitmapb")) {
                    interp.createCommand(imageName, (Command)new ImageCmd());
                }
                interp.setResult(imageName);
                break;
            }
            case 1: {
                for (int i = 2; i < argv.length; ++i) {
                    images.remove(argv[i].toString());
                    interp.deleteCommand(argv[i].toString());
                }
                break;
            }
            case 2: {
                ImageIcon image = null;
                if (argv[0].toString().equals("image")) {
                    if (argv.length < 4) {
                        throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                    }
                    image = (ImageIcon)images.get(argv[2].toString());
                    if (image == null) break;
                    ImageCmd.configure(interp, image, argv, 3);
                    break;
                }
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                }
                image = (ImageIcon)images.get(argv[0].toString());
                if (image == null) break;
                ImageCmd.configure(interp, image, argv, 2);
                break;
            }
            case 6: {
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                }
                Object sourceObject = images.get(argv[2].toString());
                Object destObject = images.get(argv[3].toString());
                BufferedImage destImage = null;
                if (destObject != null && destObject instanceof BufferedImage) {
                    destImage = (BufferedImage)destObject;
                }
                if (sourceObject == null || !(sourceObject instanceof BufferedImage)) break;
                destImage = ImageCmd.edge(interp, (BufferedImage)sourceObject, destImage);
                if (destObject != null) break;
                images.put(argv[3].toString(), destImage);
                break;
            }
            case 7: {
                if (argv.length < 4 || argv.length > 5) {
                    throw new TclNumArgsException(interp, 1, argv, "image scale ? offset ?");
                }
                Object sourceObject = images.get(argv[2].toString());
                if (sourceObject == null) {
                    throw new TclException(interp, "image " + argv[2].toString() + " doesn't exist");
                }
                if (!(sourceObject instanceof BufferedImage)) {
                    throw new TclException(interp, "image " + argv[2].toString() + " not BufferedImage");
                }
                double scaleValue = TclDouble.get((Interp)interp, (TclObject)argv[3]);
                double offset = 0.0;
                if (argv.length == 5) {
                    offset = TclDouble.get((Interp)interp, (TclObject)argv[4]);
                }
                BufferedImage sourceImage = (BufferedImage)sourceObject;
                BufferedImage destImage = ImageCmd.scale(interp, sourceImage, scaleValue, offset, sourceImage);
                break;
            }
            case 5: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 1, argv, "object imageName");
                }
                Object imageObject = images.get(argv[2].toString());
                if (imageObject == null) {
                    throw new TclException(interp, "image " + argv[2].toString() + " doesn't exist");
                }
                if (imageObject instanceof BufferedImage) {
                    TclObject tObj = ReflectObject.newInstance((Interp)interp, BufferedImage.class, (Object)((BufferedImage)imageObject));
                    interp.setResult(tObj);
                    break;
                }
                BufferedImage bufferedImage = ImageCmd.makeBufferedImage((ImageIcon)imageObject);
                images.put(argv[2].toString(), bufferedImage);
                TclObject tObj = ReflectObject.newInstance((Interp)interp, BufferedImage.class, (Object)bufferedImage);
                interp.setResult(tObj);
                break;
            }
            case 3: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                TclObject list = TclList.newInstance();
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"photo"));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"bitmap"));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"test"));
                interp.setResult(list);
                break;
            }
            case 4: {
                if (argv.length != 2) {
                    throw new TclNumArgsException(interp, 1, argv, "option");
                }
                TclObject list = TclList.newInstance();
                Enumeration e = images.keys();
                while (e.hasMoreElements()) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)e.nextElement())));
                }
                interp.setResult(list);
                break;
            }
        }
    }

    public static BufferedImage edge(Interp interp, BufferedImage sourceImage, BufferedImage destImage) {
        float[] edge = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, edge), 1, null);
        return op.filter(sourceImage, destImage);
    }

    public static BufferedImage scale(Interp interp, BufferedImage sourceImage, double scaleValue, double offsetValue, BufferedImage destImage) {
        RescaleOp op = new RescaleOp((float)scaleValue, (float)offsetValue, null);
        return op.filter(sourceImage, destImage);
    }

    public static void configure(Interp interp, ImageIcon image, TclObject[] argv, int start) throws TclException {
        if (argv.length <= start) {
            return;
        }
        Object ro = null;
        for (int i = start; i < argv.length; i += 2) {
            Object iObj;
            String imageName;
            if (argv[i].toString().equals("-file")) {
                String fileName = argv[i + 1].toString();
                imageName = image.getDescription();
                ImageIcon image2 = null;
                URL url = null;
                url = fileName.startsWith("resource:") ? Thread.currentThread().getContextClassLoader().getResource(fileName.substring(10)) : Thread.currentThread().getContextClassLoader().getResource(fileName);
                image2 = url != null ? new ImageIcon(url, imageName) : new ImageIcon(fileName, imageName);
                if (image2 == null) {
                    throw new TclException(interp, "Couldn't create image from file " + fileName);
                }
                image.setImage(image2.getImage());
                continue;
            }
            if (!argv[i].toString().equals("-object") || !((iObj = ReflectObject.get((Interp)interp, (TclObject)argv[i + 1])) instanceof BufferedImage)) continue;
            imageName = image.getDescription();
            images.put(imageName, (BufferedImage)iObj);
        }
    }

    public static Object getImage(String imageName) {
        Object imageObject = builtinImages.get(imageName);
        if (imageObject == null) {
            imageObject = images.get(imageName);
        }
        return imageObject;
    }

    public static BufferedImage makeBufferedImage(ImageIcon imageIcon) {
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(imageIcon.getImage(), 0, 0, null);
        return bufferedImage;
    }

    static {
        for (int i = 0; i < builtinImageNames.length; ++i) {
            ImageIcon image;
            String fileName = "com/onemoonscientific/swank/library/images/" + builtinImageNames[i] + ".bmp";
            URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
            if (url == null || (image = new ImageIcon(url, builtinImageNames[i])) == null) continue;
            builtinImages.put(builtinImageNames[i], image);
        }
    }
}

