/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class FontCmd
implements Command {
    private static final String[] validCmds = new String[]{"actual", "configure", "create", "delete", "families", "measure", "metrics", "names"};
    private static final int OPT_ACTUAL = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_CREATE = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_FAMILIES = 4;
    private static final int OPT_MEASURE = 5;
    private static final int OPT_METRICS = 6;
    private static final int OPT_NAMES = 7;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: {
                if (argv.length >= 4) break;
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            case 1: {
                if (argv.length >= 4) break;
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            case 2: {
                if (argv.length >= 4) break;
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            case 3: {
                if (argv.length >= 4) break;
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
            case 4: {
                String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                TclObject list = TclList.newInstance();
                for (int i = 0; i < fontFamilies.length; ++i) {
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)fontFamilies[i]));
                }
                interp.setResult(list);
                break;
            }
            case 5: {
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                }
                Font font = SwankUtil.getFont(interp, argv[2]);
                if (font == null) {
                    throw new TclException(interp, "unknown font \"" + argv[2].toString() + "\"");
                }
                Component comp = null;
                if (argv.length > 3 && "-displayof".startsWith(argv[3].toString())) {
                    if (argv.length == 4) {
                        throw new TclException(interp, "-value for \"-displayof\" missing");
                    }
                    comp = (Component)Widgets.get(interp, argv[4].toString());
                }
                if (comp == null) {
                    comp = (Component)Widgets.get(interp, "any");
                }
                if (comp == null) {
                    throw new TclException(interp, "can't get component for font command");
                }
                FontMetrics fontMetrics = comp.getFontMetrics(font);
                int width = fontMetrics.stringWidth(argv[3].toString());
                interp.setResult(width);
                break;
            }
            case 6: {
                if (argv.length < 3) {
                    throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
                }
                int start = 3;
                Component comp = null;
                Font font = SwankUtil.getFont(interp, argv[2]);
                if (font == null) {
                    throw new TclException(interp, "unknown font \"" + argv[2].toString() + "\"");
                }
                if (argv.length > 3 && "-displayof".startsWith(argv[3].toString())) {
                    if (argv.length == 4) {
                        throw new TclException(interp, "-value for \"-displayof\" missing");
                    }
                    start = 5;
                    comp = (Component)Widgets.get(interp, argv[4].toString());
                }
                if (comp == null) {
                    comp = (Component)Widgets.get(interp, "any");
                }
                if (comp == null) {
                    throw new TclException(interp, "can't get component for font command");
                }
                FontMetrics fontMetrics = new Add().exec(comp, font);
                boolean getAscent = true;
                boolean getDescent = true;
                boolean getLinespace = true;
                boolean getFixed = true;
                boolean singleMode = false;
                for (int i = start; i < argv.length; ++i) {
                    if (i == start) {
                        getFixed = false;
                        getLinespace = false;
                        getDescent = false;
                        getAscent = false;
                        singleMode = true;
                    }
                    if ("-ascent".startsWith(argv[i].toString())) {
                        getAscent = true;
                    }
                    if ("-descent".startsWith(argv[i].toString())) {
                        getDescent = true;
                    }
                    if ("-linespace".startsWith(argv[i].toString())) {
                        getLinespace = true;
                    }
                    if (!"-fixed".startsWith(argv[i].toString())) continue;
                    getFixed = true;
                }
                TclObject list = TclList.newInstance();
                if (getAscent) {
                    if (!singleMode) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-ascent"));
                    }
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)fontMetrics.getAscent()));
                }
                if (getDescent) {
                    if (!singleMode) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-descent"));
                    }
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)fontMetrics.getDescent()));
                }
                if (getLinespace) {
                    if (!singleMode) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-linespace"));
                    }
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)fontMetrics.getHeight()));
                }
                if (getFixed) {
                    if (!singleMode) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"-fixed"));
                    }
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclBoolean.newInstance((fontMetrics.charWidth('m') == fontMetrics.charWidth('i') ? 1 : 0) != 0));
                }
                interp.setResult(list);
                break;
            }
            case 7: {
                if (argv.length >= 4) break;
                throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
            }
        }
    }

    class Add
    extends GetValueOnEventThread {
        Component comp = null;
        Font font = null;
        FontMetrics fontMetrics = null;

        Add() {
        }

        FontMetrics exec(Component comp, Font font) {
            this.comp = comp;
            this.font = font;
            this.execOnThread();
            return this.fontMetrics;
        }

        public void run() {
            this.fontMetrics = this.comp.getFontMetrics(this.font);
        }
    }
}

