/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class EventCmd
implements Command {
    public static Map virtualEvents = new LinkedHashMap();
    private static final String[] validCmds = new String[]{"add", "delete", "generate", "info"};
    private static final int OPT_ADD = 0;
    private static final int OPT_DELETE = 1;
    private static final int OPT_GENERATE = 2;
    private static final int OPT_INFO = 3;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        switch (opt) {
            case 0: {
                if (argv.length < 4) {
                    throw new TclNumArgsException(interp, 2, argv, "<<virtual>> sequence ?sequence ...?");
                }
                String virtual = argv[2].toString();
                if (!EventCmd.checkVirtual(virtual)) {
                    throw new TclException(interp, "virtual event \"" + virtual + "\" badly formed");
                }
                Vector<SwkBinding> sequenceVec = (Vector<SwkBinding>)virtualEvents.get(virtual);
                if (sequenceVec == null) {
                    sequenceVec = new Vector<SwkBinding>(2);
                    virtualEvents.put(virtual, sequenceVec);
                }
                for (int i = 3; i < argv.length; ++i) {
                    SwkBinding binding = SwkBind.getBinding(interp, argv, i);
                    sequenceVec.add(binding);
                }
                break;
            }
            case 1: {
                System.out.println("event delete not implemented yet");
                break;
            }
            case 2: {
                System.out.println("event generate not implemented yet");
                break;
            }
            case 3: {
                if (argv.length != 2 && argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?<<virtual>>?");
                }
                if (argv.length == 2) {
                    Iterator iter = virtualEvents.keySet().iterator();
                    TclObject list = TclList.newInstance();
                    while (iter.hasNext()) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)iter.next())));
                    }
                    interp.setResult(list);
                    break;
                }
                String virtual = argv[2].toString();
                if (!EventCmd.checkVirtual(virtual)) {
                    throw new TclException(interp, "virtual event \"" + virtual + "\" badly formed");
                }
                Vector sequenceVec = (Vector)virtualEvents.get(virtual);
                if (sequenceVec == null) break;
                TclObject list = TclList.newInstance();
                for (int i = 0; i < sequenceVec.size(); ++i) {
                    SwkBinding binding = (SwkBinding)sequenceVec.elementAt(i);
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)binding.toString()));
                }
                interp.setResult(list);
                break;
            }
        }
    }

    public static boolean checkVirtual(String virtual) {
        return virtual.matches("^<<[^<>]+>>$");
    }

    public static Vector getVirtualEvents(String name) {
        Vector sequenceVec = (Vector)virtualEvents.get(name);
        return sequenceVec;
    }
}

