/*
 * Decompiled with CFR 0.152.
 */
package itcl.lang;

import itcl.lang.BiCmds;
import itcl.lang.Class;
import itcl.lang.Ensemble;
import itcl.lang.Itcl;
import itcl.lang.ItclClass;
import itcl.lang.ItclInt;
import itcl.lang.ItclObject;
import itcl.lang.ItclObjectInfo;
import itcl.lang.ItclVarLookup;
import itcl.lang.Itcl_Stack;
import itcl.lang.Methods;
import itcl.lang.Migrate;
import itcl.lang.Objects;
import itcl.lang.Parse;
import itcl.lang.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.AssocData;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.ItclAccess;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

class Cmds {
    static String initScript = "namespace eval ::itcl { source resource:/itcl/lang/library/itcl.tcl }";
    static String safeInitScript = "proc ::itcl::local {class name args} {\n    set ptr [uplevel [list $class $name] $args]\n    uplevel [list set itcl-local-$ptr $ptr]\n    set cmd [uplevel namespace which -command $ptr]\n    uplevel [list trace variable itcl-local-$ptr u \"::itcl::delete object $cmd; list\"]\n    return $ptr\n}";
    static int itclCompatFlags = -1;

    Cmds() {
    }

    static void Initialize(Interp interp) throws TclException {
        String TCL_VERSION = "8.0";
        interp.pkgRequire("Tcl", TCL_VERSION, false);
        if (interp.getCommand("::itcl::class") != null) {
            throw new TclException(interp, "already installed: [incr Tcl]");
        }
        itclCompatFlags = 0;
        Ensemble.EnsembleInit(interp);
        ItclObjectInfo info = new ItclObjectInfo();
        info.interp = interp;
        info.objects = new HashMap();
        info.transparentFrames = new Itcl_Stack();
        Util.InitStack(info.transparentFrames);
        info.contextFrames = new HashMap();
        info.protection = 4;
        info.cdefnStack = new Itcl_Stack();
        Util.InitStack(info.cdefnStack);
        interp.setAssocData(ItclInt.INTERP_DATA, (AssocData)info);
        interp.createCommand("::itcl::class", (Command)new Parse.ClassCmd(info));
        Util.PreserveData(info);
        interp.createCommand("::itcl::body", (Command)new Methods.BodyCmd());
        interp.createCommand("::itcl::configbody", (Command)new Methods.ConfigBodyCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::find");
        Ensemble.AddEnsemblePart(interp, "::itcl::find", "classes", "?pattern?", (Command)new FindClassesCmd(info));
        Util.PreserveData(info);
        Ensemble.AddEnsemblePart(interp, "::itcl::find", "objects", "?-class className? ?-isa className? ?pattern?", (Command)new FindObjectsCmd(info));
        Util.PreserveData(info);
        Ensemble.CreateEnsemble(interp, "::itcl::delete");
        Ensemble.AddEnsemblePart(interp, "::itcl::delete", "class", "name ?name...?", (Command)new DelClassCmd(info));
        Util.PreserveData(info);
        Ensemble.AddEnsemblePart(interp, "::itcl::delete", "object", "name ?name...?", (Command)new DelObjectCmd(info));
        Util.PreserveData(info);
        Ensemble.CreateEnsemble(interp, "::itcl::is");
        Ensemble.AddEnsemblePart(interp, "::itcl::is", "class", "name", (Command)new IsClassCmd(info));
        Util.PreserveData(info);
        Ensemble.AddEnsemblePart(interp, "::itcl::is", "object", "?-class classname? name", (Command)new IsObjectCmd(info));
        Util.PreserveData(info);
        interp.createCommand("::itcl::code", (Command)new CodeCmd());
        interp.createCommand("::itcl::scope", (Command)new ScopeCmd());
        Ensemble.CreateEnsemble(interp, "::itcl::import::stub");
        Ensemble.AddEnsemblePart(interp, "::itcl::import::stub", "create", "name", (Command)new StubCreateCmd());
        Ensemble.AddEnsemblePart(interp, "::itcl::import::stub", "exists", "name", (Command)new StubExistsCmd());
        Objects.ScopedVarResolverImpl resolver = new Objects.ScopedVarResolverImpl();
        interp.addInterpResolver("itcl", (Resolver)resolver);
        Parse.ParseInit(interp, info);
        BiCmds.BiInit(interp);
        Namespace itclNs = Namespace.findNamespace((Interp)interp, (String)"::itcl", null, (int)512);
        if (itclNs == null) {
            throw new TclException(interp, interp.getResult().toString());
        }
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"body", (boolean)true);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"class", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"code", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"configbody", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"delete", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"delete_helper", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"ensemble", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"find", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"local", (boolean)false);
        Namespace.exportList((Interp)interp, (Namespace)itclNs, (String)"scope", (boolean)false);
        interp.setVar("::itcl::patchLevel", TclString.newInstance((String)Itcl.PATCH_LEVEL), 2);
        interp.setVar("::itcl::version", TclString.newInstance((String)Itcl.VERSION), 2);
    }

    static void Init(Interp interp) throws TclException {
        Cmds.Initialize(interp);
        interp.eval(initScript);
    }

    static void SafeInit(Interp interp) throws TclException {
        Cmds.Initialize(interp);
        interp.eval(safeInitScript);
    }

    static void DelObjectInfo(ItclObjectInfo info) {
        ItclObject contextObj;
        while ((contextObj = (ItclObject)ItclAccess.FirstHashEntry(info.objects)) != null) {
            info.interp.deleteCommandFromToken(contextObj.w_accessCmd);
        }
        info.objects.clear();
        info.objects = null;
        Iterator iter = info.contextFrames.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            contextObj = (ItclObject)entry.getValue();
            Util.ReleaseData(contextObj);
        }
        info.contextFrames.clear();
        info.contextFrames = null;
        Util.DeleteStack(info.transparentFrames);
        info.transparentFrames = null;
        Util.DeleteStack(info.cdefnStack);
        info.cdefnStack = null;
    }

    static boolean IsStub(WrappedCommand wcmd) {
        return wcmd.cmd instanceof HandleStubCmd;
    }

    static void ItclDeleteStub(Object cdata) {
    }

    static class IsClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        IsClassCmd(ItclObjectInfo info) {
            this.info = info;
        }

        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass classDefn = null;
            Namespace contextNs = null;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "commandname");
            }
            String name = objv[1].toString();
            Util.DecodeScopedCommandResult res = Util.DecodeScopedCommand(interp, name);
            contextNs = res.rNS;
            String cname = res.rCmd;
            classDefn = Class.FindClass(interp, cname, false);
            if (classDefn != null) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }

    static class IsObjectCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        IsObjectCmd(ItclObjectInfo info) {
            this.info = info;
        }

        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclObject contextObj;
            boolean classFlag = false;
            int idx = 0;
            String name = null;
            Namespace contextNs = null;
            ItclClass classDefn = null;
            if (objv.length != 2 && objv.length != 4) {
                throw new TclNumArgsException(interp, 1, objv, "?-class classname? commandname");
            }
            for (idx = 1; idx < objv.length; ++idx) {
                String token = objv[idx].toString();
                if (token.equals("-class")) {
                    String cname = objv[idx + 1].toString();
                    classDefn = Class.FindClass(interp, cname, false);
                    if (classDefn == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++idx;
                    classFlag = true;
                    continue;
                }
                name = objv[idx].toString();
            }
            if (name == null) {
                throw new TclRuntimeError("name not assigned in objc loop");
            }
            Util.DecodeScopedCommandResult res = Util.DecodeScopedCommand(interp, name);
            String cmdName = res.rCmd;
            contextNs = res.rNS;
            WrappedCommand wcmd = Namespace.findCommand((Interp)interp, (String)cmdName, (Namespace)contextNs, (int)0);
            if (wcmd == null || !Objects.IsObject(wcmd)) {
                interp.setResult(false);
                return;
            }
            if (classFlag && !Objects.ObjectIsa(contextObj = Objects.GetContextFromObject(wcmd), classDefn)) {
                interp.setResult(false);
                return;
            }
            interp.setResult(true);
        }
    }

    static class HandleStubCmd
    implements CommandWithDispose {
        WrappedCommand wcmd;

        HandleStubCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            String cmdName = interp.getCommandFullName(this.wcmd);
            interp.eval("::auto_load \"" + cmdName + "\"");
            TclObject obj = interp.getResult();
            boolean err = false;
            int loaded = 0;
            try {
                loaded = TclInteger.get((Interp)interp, (TclObject)obj);
            }
            catch (TclException ex) {
                err = true;
            }
            if (err || loaded != 1) {
                interp.resetResult();
                throw new TclException(interp, "can't autoload \"" + cmdName + "\"");
            }
            TclObject cmdline = Util.CreateArgs(interp, cmdName, objv, 1);
            TclObject[] cmdlinev = TclList.getElements((Interp)interp, (TclObject)cmdline);
            interp.resetResult();
            Util.EvalArgs(interp, cmdlinev);
        }

        public void disposeCmd() {
            Cmds.ItclDeleteStub(null);
        }
    }

    static class StubExistsCmd
    implements Command {
        StubExistsCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "name");
            }
            String cmdName = objv[1].toString();
            WrappedCommand wcmd = Namespace.findCommand((Interp)interp, (String)cmdName, null, (int)0);
            if (wcmd != null && Cmds.IsStub(wcmd)) {
                interp.setResult(true);
            } else {
                interp.setResult(false);
            }
        }
    }

    static class StubCreateCmd
    implements Command {
        StubCreateCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            WrappedCommand wcmd;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "name");
            }
            String cmdName = objv[1].toString();
            interp.createCommand(cmdName, (Command)new HandleStubCmd());
            ((HandleStubCmd)wcmd.cmd).wcmd = wcmd = Namespace.findCommand((Interp)interp, (String)cmdName, null, (int)2);
        }
    }

    static class CodeCmd
    implements Command {
        CodeCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            String token;
            int pos;
            Namespace contextNs = Namespace.getCurrentNamespace((Interp)interp);
            for (pos = 1; pos < objv.length && (token = objv[pos].toString()).length() >= 2 && token.charAt(0) == '-'; ++pos) {
                if (token.equals("-namespace")) {
                    if (objv.length == 2) {
                        throw new TclNumArgsException(interp, 1, objv, "?-namespace name? command ?arg arg...?");
                    }
                    token = objv[pos + 1].toString();
                    contextNs = Namespace.findNamespace((Interp)interp, (String)token, null, (int)512);
                    if (contextNs == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++pos;
                    continue;
                }
                if (token.equals("--")) {
                    ++pos;
                    break;
                }
                throw new TclException(interp, "bad option \"" + token + "\": should be -namespace or --");
            }
            if (objv.length < 2) {
                throw new TclNumArgsException(interp, 1, objv, "?-namespace name? command ?arg arg...?");
            }
            TclObject list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"namespace"));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"inscope"));
            TclObject obj = contextNs == Namespace.getGlobalNamespace((Interp)interp) ? TclString.newInstance((String)"::") : TclString.newInstance((String)contextNs.fullName);
            TclList.append((Interp)interp, (TclObject)list, (TclObject)obj);
            if (objv.length - pos == 1) {
                obj = objv[pos];
            } else {
                obj = TclList.newInstance();
                for (int i = pos; i < objv.length; ++i) {
                    TclList.append((Interp)interp, (TclObject)obj, (TclObject)objv[i]);
                }
            }
            TclList.append((Interp)interp, (TclObject)list, (TclObject)obj);
            interp.setResult(list);
        }
    }

    static class ScopeCmd
    implements Command {
        ScopeCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Namespace contextNs = Namespace.getCurrentNamespace((Interp)interp);
            String openParen = null;
            if (objv.length != 2) {
                throw new TclNumArgsException(interp, 1, objv, "varname");
            }
            String token = objv[1].toString();
            if (token.startsWith("::")) {
                interp.setResult(objv[1]);
                return;
            }
            int openParenEnd = -1;
            int openParenStart = -1;
            for (int p = 0; p < token.length(); ++p) {
                if (token.charAt(p) == '(') {
                    openParenStart = p;
                    continue;
                }
                if (token.charAt(p) != ')' || openParenStart == -1) continue;
                openParenEnd = p;
                break;
            }
            if (openParenStart != -1 && openParenEnd != -1) {
                openParen = token.substring(openParenStart, openParenEnd + 1);
                token = token.substring(0, openParenStart);
            }
            if (Class.IsClassNamespace(contextNs)) {
                ItclClass contextClass = Class.GetClassFromNamespace(contextNs);
                ItclVarLookup vlookup = (ItclVarLookup)contextClass.resolveVars.get(token);
                if (vlookup == null) {
                    throw new TclException(interp, "variable \"" + token + "\" not found in class \"" + contextClass.fullname + "\"");
                }
                if ((vlookup.vdefn.member.flags & ItclInt.COMMON) != 0) {
                    StringBuffer buffer = new StringBuffer(64);
                    buffer.append(vlookup.vdefn.member.fullname);
                    if (openParen != null) {
                        buffer.append(openParen);
                        openParen = null;
                    }
                    interp.setResult(buffer.toString());
                    return;
                }
                CallFrame frame = Migrate.GetCallFrame(interp, 0);
                ItclObjectInfo info = contextClass.info;
                ItclObject contextObj = (ItclObject)info.contextFrames.get(frame);
                if (contextObj == null) {
                    throw new TclException(interp, "can't scope variable \"" + token + "\": missing object context\"");
                }
                TclObject list = TclList.newInstance();
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)"@itcl"));
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)interp.getCommandFullName(contextObj.w_accessCmd)));
                StringBuffer buffer = new StringBuffer(64);
                buffer.append(vlookup.vdefn.member.fullname);
                if (openParen != null) {
                    buffer.append(openParen);
                    openParen = null;
                }
                TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)buffer.toString()));
                interp.setResult(list);
            } else {
                StringBuffer buffer = new StringBuffer(64);
                Var var = Namespace.findNamespaceVar((Interp)interp, (String)token, (Namespace)contextNs, (int)2);
                if (var == null) {
                    throw new TclException(interp, "variable \"" + token + "\" not found in namespace \"" + contextNs.fullName + "\"");
                }
                String fname = Var.getVariableFullName((Interp)interp, (Var)var);
                buffer.append(fname);
                if (openParen != null) {
                    buffer.append(openParen);
                    openParen = null;
                }
                interp.setResult(buffer.toString());
            }
        }
    }

    static class DelObjectCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        DelObjectCmd(ItclObjectInfo info) {
            this.info = info;
        }

        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            for (int i = 1; i < objv.length; ++i) {
                String name = objv[i].toString();
                ItclObject contextObj = Objects.FindObject(interp, name);
                if (contextObj == null) {
                    throw new TclException(interp, "object \"" + name + "\" not found");
                }
                Objects.DeleteObject(interp, contextObj);
            }
        }
    }

    static class DelClassCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        DelClassCmd(ItclObjectInfo info) {
            this.info = info;
        }

        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclClass cdefn;
            String name;
            int i;
            for (i = 1; i < objv.length; ++i) {
                name = objv[i].toString();
                cdefn = Class.FindClass(interp, name, true);
                if (cdefn != null) continue;
                throw new TclException(interp, interp.getResult().toString());
            }
            for (i = 1; i < objv.length; ++i) {
                name = objv[i].toString();
                cdefn = Class.FindClass(interp, name, false);
                if (cdefn == null) continue;
                interp.resetResult();
                Class.DeleteClass(interp, cdefn);
            }
            interp.resetResult();
        }
    }

    static class ProtectionCmd
    implements Command {
        ProtectionCmd() {
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            throw new TclRuntimeError("unused function");
        }
    }

    static class FindObjectsCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        FindObjectsCmd(ItclObjectInfo info) {
            this.info = info;
        }

        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Namespace activeNs = Namespace.getCurrentNamespace((Interp)interp);
            Namespace globalNs = Namespace.getGlobalNamespace((Interp)interp);
            boolean forceFullNames = false;
            String pattern = null;
            ItclClass classDefn = null;
            ItclClass isaDefn = null;
            String name = null;
            String token = null;
            String cmdName = null;
            TclObject result = TclList.newInstance();
            int pos = 0;
            while (++pos < objv.length) {
                token = objv[pos].toString();
                if (token.length() == 0 || token.charAt(0) != '-') {
                    if (pattern != null) break;
                    pattern = token;
                    forceFullNames = pattern.indexOf("::") != -1;
                    continue;
                }
                if (pos + 1 < objv.length && token.equals("-class")) {
                    name = objv[pos + 1].toString();
                    classDefn = Class.FindClass(interp, name, true);
                    if (classDefn == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++pos;
                    continue;
                }
                if (pos + 1 < objv.length && token.equals("-isa")) {
                    name = objv[pos + 1].toString();
                    isaDefn = Class.FindClass(interp, name, true);
                    if (isaDefn == null) {
                        throw new TclException(interp, interp.getResult().toString());
                    }
                    ++pos;
                    continue;
                }
                if (pos != objv.length - 1 || pattern != null) break;
                pattern = token;
                forceFullNames = pattern.indexOf("::") != -1;
            }
            if (pos < objv.length) {
                throw new TclNumArgsException(interp, 1, objv, "?-class className? ?-isa className? ?pattern?");
            }
            Itcl_Stack search = new Itcl_Stack();
            Util.InitStack(search);
            Util.PushStack(globalNs, search);
            Util.PushStack(activeNs, search);
            HashMap<WrappedCommand, String> unique = new HashMap<WrappedCommand, String>();
            boolean handledActiveNs = false;
            while (Util.GetStackSize(search) > 0) {
                Map.Entry entry;
                Namespace ns = (Namespace)Util.PopStack(search);
                if (ns == activeNs && handledActiveNs) continue;
                Iterator iter = ns.cmdTable.entrySet().iterator();
                while (iter.hasNext()) {
                    TclObject obj;
                    entry = iter.next();
                    String key = (String)entry.getKey();
                    WrappedCommand wcmd = (WrappedCommand)entry.getValue();
                    if (!Objects.IsObject(wcmd)) continue;
                    WrappedCommand originalCmd = Namespace.getOriginalCommand((WrappedCommand)wcmd);
                    if (originalCmd != null) {
                        wcmd = originalCmd;
                    }
                    ItclObject contextObj = Objects.GetContextFromObject(wcmd);
                    if (forceFullNames || ns != activeNs || originalCmd != null) {
                        cmdName = interp.getCommandFullName(wcmd);
                        obj = TclString.newInstance((String)cmdName);
                    } else {
                        cmdName = interp.getCommandName(wcmd);
                        obj = TclString.newInstance((String)cmdName);
                    }
                    boolean newEntry = unique.put(wcmd, "") == null;
                    boolean match = false;
                    if (newEntry && (pattern == null || tcl.lang.Util.stringMatch((String)cmdName, (String)pattern)) && (classDefn == null || contextObj.classDefn == classDefn)) {
                        if (isaDefn == null) {
                            match = true;
                        } else if (contextObj.classDefn.heritage.get(isaDefn) != null) {
                            match = true;
                        }
                    }
                    if (!match) continue;
                    TclList.append((Interp)interp, (TclObject)result, (TclObject)obj);
                }
                handledActiveNs = true;
                iter = ns.childTable.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    Namespace child = (Namespace)entry.getValue();
                    Util.PushStack(child, search);
                }
            }
            unique.clear();
            Util.DeleteStack(search);
            interp.setResult(result);
        }
    }

    static class FindClassesCmd
    implements CommandWithDispose {
        ItclObjectInfo info;

        FindClassesCmd(ItclObjectInfo info) {
            this.info = info;
        }

        public void disposeCmd() {
            Util.ReleaseData(this.info);
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            String pattern;
            Namespace activeNs = Namespace.getCurrentNamespace((Interp)interp);
            Namespace globalNs = Namespace.getGlobalNamespace((Interp)interp);
            boolean forceFullNames = false;
            if (objv.length > 2) {
                throw new TclNumArgsException(interp, 1, objv, "?pattern?");
            }
            if (objv.length == 2) {
                pattern = objv[1].toString();
                forceFullNames = pattern.indexOf("::") != -1;
            } else {
                pattern = null;
            }
            Itcl_Stack search = new Itcl_Stack();
            Util.InitStack(search);
            Util.PushStack(globalNs, search);
            Util.PushStack(activeNs, search);
            HashMap<WrappedCommand, String> unique = new HashMap<WrappedCommand, String>();
            TclObject result = TclList.newInstance();
            boolean handledActiveNs = false;
            while (Util.GetStackSize(search) > 0) {
                String key;
                Map.Entry entry;
                Namespace ns = (Namespace)Util.PopStack(search);
                if (ns == activeNs && handledActiveNs) continue;
                Iterator iter = ns.cmdTable.entrySet().iterator();
                while (iter.hasNext()) {
                    boolean newEntry;
                    TclObject obj;
                    String cmdName;
                    entry = iter.next();
                    key = (String)entry.getKey();
                    WrappedCommand cmd = (WrappedCommand)entry.getValue();
                    if (!Class.IsClass(cmd)) continue;
                    WrappedCommand originalCmd = Namespace.getOriginalCommand((WrappedCommand)cmd);
                    if (forceFullNames || ns != activeNs || originalCmd != null) {
                        cmdName = interp.getCommandFullName(cmd);
                        obj = TclString.newInstance((String)cmdName);
                    } else {
                        cmdName = interp.getCommandName(cmd);
                        obj = TclString.newInstance((String)cmdName);
                    }
                    if (originalCmd != null) {
                        cmd = originalCmd;
                    }
                    if (!(newEntry = unique.put(cmd, "") == null) || pattern != null && !tcl.lang.Util.stringMatch((String)cmdName, (String)pattern)) continue;
                    TclList.append((Interp)interp, (TclObject)result, (TclObject)obj);
                }
                handledActiveNs = true;
                iter = ns.childTable.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    key = (String)entry.getKey();
                    Namespace child = (Namespace)entry.getValue();
                    Util.PushStack(child, search);
                }
            }
            unique.clear();
            Util.DeleteStack(search);
            interp.setResult(result);
        }
    }
}

