/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.SymbolParameter;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.Transformer;
import com.onemoonscientific.swank.chart.DatasetParameter;
import com.onemoonscientific.swank.chart.DatasetShape;
import com.onemoonscientific.swank.chart.NumberDomain;
import com.onemoonscientific.swank.chart.NumberRange;
import com.onemoonscientific.swank.chart.PlotInterface;
import com.onemoonscientific.swank.chart.PlotLegend;
import com.onemoonscientific.swank.chart.XYData;
import com.onemoonscientific.swank.chart.XYLineAndShapeComplete;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYDataset;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class XYPlotShape
extends SwkShape
implements DatasetShape,
NumberDomain,
NumberRange,
PlotInterface {
    static CanvasParameter[] parameters = new CanvasParameter[]{new TagsParameter(), new DatasetParameter(), new FillParameter()};
    static Map parameterMap = new TreeMap();
    GeneralPath gPath = new GeneralPath();
    float radius = 2.0f;
    int symbolType = 3;
    boolean drawLine = false;
    XYPlot plot = new XYPlot();
    PlotLegend plotLegend = new PlotLegend((LegendItemSource)this.plot);
    ChartRenderingInfo chartInfo = new ChartRenderingInfo();
    PlotRenderingInfo state = new PlotRenderingInfo(this.chartInfo);
    Rectangle2D.Double plotArea = null;
    String plotType = "lineandshape";
    XYItemRenderer renderer = null;
    Rectangle2D rect2D = new Rectangle2D.Double();
    String legendLoc = "s.n";
    boolean legendState = false;

    public XYPlotShape() {
        this.setRenderer();
        this.setShape(this.rect2D);
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public String getType() {
        return this.plotType;
    }

    public void setRenderer() {
        this.renderer = new XYLineAndShapeRenderer();
        this.plot.setRenderer(this.renderer);
    }

    public void setRenderer(XYItemRenderer newRenderer) {
        this.renderer = newRenderer;
        this.plot.setRenderer(this.renderer);
    }

    public void setSplineRenderer(int precision) {
        XYSplineRenderer splineRenderer = new XYSplineRenderer();
        splineRenderer.setPrecision(precision);
        this.renderer = splineRenderer;
        this.plot.setRenderer(this.renderer);
    }

    public void setDataset(String name) {
        XYData xyData = XYData.get(name);
        this.plot.setDataset((XYDataset)xyData);
    }

    public void setDataset(int index, String name) {
        XYData xyData = XYData.get(name);
        this.plot.setDataset(index, (XYDataset)xyData);
    }

    public void setDataset(XYData xyData) {
        this.plot.setDataset((XYDataset)xyData);
    }

    public void setDrawline(boolean newValue) {
        this.drawLine = newValue;
    }

    public boolean getDrawline() {
        return this.drawLine;
    }

    public void setSymbolType(int newSymbolType) {
        this.symbolType = newSymbolType;
    }

    public String getSymbolType() {
        return SymbolParameter.getSymbolType((int)this.symbolType);
    }

    public void setRadius(double newRadius) {
        this.radius = (float)newRadius;
    }

    public double getRadius() {
        return this.radius;
    }

    public String getLegendLoc() {
        return this.legendLoc;
    }

    public void setLegendLoc(String loc) {
        this.legendLoc = loc;
    }

    public boolean getLegendState() {
        return this.legendState;
    }

    public void setLegendState(boolean state) {
        this.legendState = state;
    }

    public String hit(double x, double y) {
        ChartEntity entity;
        EntityCollection entities;
        String result = "";
        if (this.state != null && (entities = this.state.getOwner().getEntityCollection()) != null && (entity = entities.getEntity(x, y)) != null) {
            result = entity.getToolTipText();
        }
        return result;
    }

    public boolean hitShape(double x, double y) {
        Rectangle bounds;
        boolean hit = false;
        Shape checkShape = this.getShape();
        AffineTransform shapeTransform = this.getTransform();
        if (shapeTransform != null) {
            checkShape = shapeTransform.createTransformedShape(checkShape);
        }
        if ((bounds = checkShape.getBounds()).contains(x, y)) {
            hit = true;
        }
        return hit;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length != 4) {
            throw new SwkException("wrong # coordinates: expected 8, got " + coords.length);
        }
        this.gPath.reset();
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        AffineTransform aT = new AffineTransform();
        this.checkCoordinates(this.storeCoords);
        this.rect2D.setFrame(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2] - this.storeCoords[0], this.storeCoords[3] - this.storeCoords[1]);
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.getXShear(), this.getYShear());
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.getRotate(), (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.plotArea = new Rectangle2D.Double();
        this.plotArea.setFrameFromDiagonal(this.storeCoords[0], this.storeCoords[1], this.storeCoords[2], this.storeCoords[3]);
    }

    public void checkCoordinates(double[] coords) {
        double hold;
        if (coords == null || coords.length != 4) {
            return;
        }
        if (coords[0] > coords[2]) {
            hold = coords[0];
            coords[0] = coords[2];
            coords[2] = hold;
        }
        if (coords[1] > coords[3]) {
            hold = coords[1];
            coords[1] = coords[3];
            coords[3] = hold;
        }
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public void paintShape(Graphics2D g2) {
        Point2D.Double anchor = new Point2D.Double();
        this.applyCoordinates();
        Rectangle2D plotAreaNow = (Rectangle2D)this.plotArea.clone();
        AffineTransform shapeTransform = this.getTransform();
        if (shapeTransform != null) {
            plotAreaNow = shapeTransform.createTransformedShape(plotAreaNow).getBounds2D();
        }
        if (this.legendState) {
            Rectangle2D legendArea = this.plotLegend.arrangeLegend(g2, plotAreaNow);
            this.plot.draw(g2, plotAreaNow, (Point2D)anchor, null, this.state);
            this.plotLegend.drawLegend(g2, legendArea);
        } else {
            this.plot.draw(g2, plotAreaNow, (Point2D)anchor, null, this.state);
        }
        ValueAxis dAxis = this.plot.getDomainAxis();
        double lowerBoundX = dAxis.getLowerBound();
        double upperBoundX = dAxis.getUpperBound();
        ValueAxis rAxis = this.plot.getRangeAxis();
        double lowerBoundY = rAxis.getLowerBound();
        double upperBoundY = rAxis.getUpperBound();
        Rectangle2D dataArea = this.state.getDataArea();
        double x1 = dataArea.getMinX();
        double x2 = dataArea.getMaxX();
        double y1 = dataArea.getMinY();
        double y2 = dataArea.getMaxY();
        double scaleX = (x2 - x1) / (upperBoundX - lowerBoundX);
        double scaleY = (y2 - y1) / (lowerBoundY - upperBoundY);
        SwkImageCanvas canvas = this.getCanvas();
        Transformer plotTransformer = canvas.setTransformer("xyplot" + this.getId(), null);
        AffineTransform aT = plotTransformer.getTransform();
        aT.setToIdentity();
        aT.translate(x1, y1);
        aT.scale(scaleX, scaleY);
        aT.translate(-lowerBoundX, -upperBoundY);
    }

    public void addSymbol(float x1, float y1, float radius) {
    }

    public TclObject getDatasets(Interp interp) throws TclException {
        int nDatasets = this.plot.getDatasetCount();
        TclObject list = TclList.newInstance();
        for (int i = 0; i < nDatasets; ++i) {
            XYData xyData = (XYData)this.plot.getDataset(i);
            if (xyData == null) continue;
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)xyData.getName()));
        }
        return list;
    }

    public void updateDatasets(String[] datasetNames) {
        int nDatasets = this.plot.getDatasetCount();
        for (int i = 0; i < datasetNames.length; ++i) {
            this.setDataset(i, datasetNames[i]);
            if (i < nDatasets) continue;
            XYLineAndShapeRenderer newRenderer = new XYLineAndShapeRenderer();
            newRenderer.setToolTipGenerator(XYLineAndShapeComplete.generator);
            this.plot.setRenderer(i, (XYItemRenderer)newRenderer);
        }
    }

    public TclObject getColors(Interp interp) throws TclException {
        int nDatasets = this.plot.getDatasetCount();
        TclObject list = TclList.newInstance();
        for (int iData = 0; iData < nDatasets; ++iData) {
            XYItemRenderer renderer = this.plot.getRenderer(iData);
            if (renderer == null) {
                renderer = this.plot.getRenderer();
            }
            if (renderer instanceof XYLineAndShapeRenderer) {
                XYData data = (XYData)this.plot.getDataset(iData);
                if (data == null) continue;
                int nSeries = data.getSeriesCount();
                for (int i = 0; i < nSeries; ++i) {
                    Color color = (Color)((XYLineAndShapeRenderer)renderer).getSeriesPaint(i);
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)SwankUtil.parseColor((Color)color)));
                }
                continue;
            }
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
        }
        return list;
    }

    public void updateColors(Color[] colors) {
        Color color = Color.BLACK;
        int nDatasets = this.plot.getDatasetCount();
        int j = 0;
        for (int iData = 0; iData < nDatasets; ++iData) {
            XYData data;
            XYItemRenderer renderer = this.plot.getRenderer(iData);
            if (renderer == null) {
                renderer = this.plot.getRenderer();
            }
            if (!(renderer instanceof XYLineAndShapeRenderer) || (data = (XYData)this.plot.getDataset(iData)) == null) continue;
            int nSeries = data.getSeriesCount();
            for (int i = 0; i < nSeries; ++i) {
                color = Color.BLACK;
                if (colors.length > j) {
                    color = colors[j];
                }
                ((XYLineAndShapeRenderer)renderer).setSeriesPaint(i, (Paint)color);
                ((XYLineAndShapeRenderer)renderer).setSeriesFillPaint(i, (Paint)color);
                ((XYLineAndShapeRenderer)renderer).setSeriesOutlinePaint(i, (Paint)color);
                ++j;
            }
        }
    }

    public NumberAxis getDomainAxis() {
        return (NumberAxis)this.plot.getDomainAxis();
    }

    public NumberAxis getRangeAxis() {
        return (NumberAxis)this.plot.getRangeAxis();
    }

    static {
        XYPlotShape.initializeParameters((CanvasParameter[])parameters, (Map)parameterMap);
    }
}

