/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlOption<T extends OCamlValue>
extends OCamlValue {
    private final Wrapper<T> wrapper;

    private OCamlOption(Wrapper<T> wrapper, Value value) {
        super(value);
        assert (wrapper != null) : "null w";
        this.wrapper = wrapper;
    }

    public Wrapper<? extends OCamlOption<T>> getWrapper() {
        return OCamlOption.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        switch (n) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public T get() {
        if (this.value.isLong()) {
            return null;
        }
        return this.wrapper.wrap(this.value.get0());
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlOption) {
            OCamlOption oCamlOption = (OCamlOption)object;
            if (this.value.isLong()) {
                if (oCamlOption.value.isLong()) {
                    return this.value.asLong() == oCamlOption.value.asLong();
                }
                return false;
            }
            if (oCamlOption.value.isLong()) {
                return false;
            }
            return this.value.get0() == oCamlOption.value.get0();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlOption(");
        if (this.value.isLong()) {
            stringBuilder.append("None");
        } else {
            stringBuilder.append("Some(");
            stringBuilder.append(((OCamlValue)this.wrapper.wrap(this.value.get0())).toString());
            stringBuilder.append(")");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static <T extends OCamlValue> OCamlOption<T> create(T t) {
        return new OCamlOption<OCamlValue>(t.getWrapper(), Value.createBlock(0, t.value()));
    }

    public static <T extends OCamlValue> OCamlOption<T> create() {
        return new OCamlOption<OCamlUnit>(OCamlUnit.WRAPPER, Value.ZERO);
    }

    public static <T extends OCamlValue> OCamlOption<T> wrap(Wrapper<T> wrapper, Value value) {
        assert (value != null) : "null v";
        return new OCamlOption<T>(wrapper, value);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlOption<T>> wrapper(final Wrapper<T> wrapper) {
        return new ComposedWrapper<OCamlOption<T>>(new Wrapper[0]){

            @Override
            public OCamlOption<T> wrap(Value value) {
                return new OCamlOption(wrapper, value);
            }
        };
    }
}

