/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.PredefinedExceptions;
import org.ocamljava.runtime.values.Value;

public final class Misc {
    private static final long MATCH_FAILURE_EXCEPTION = 7L;
    private static final long ASSERT_FAILURE_EXCEPTION = 10L;
    private static final long UNDEFINED_RECURSIVE_MODULE_EXCEPTION = 11L;

    private Misc() {
    }

    private static boolean isSpecialException(Value value) {
        PredefinedExceptions predefinedExceptions = CurrentContext.PREDEFINED_EXCEPTIONS;
        return value == predefinedExceptions.exnMatchFailure || value == predefinedExceptions.exnAssertFailure || value == predefinedExceptions.exnUndefinedRecursiveModule;
    }

    public static String convertException(Value value, Value value2) {
        boolean bl;
        assert (value != null) : "null exception";
        StringBuilder stringBuilder = new StringBuilder();
        if (value2 == null) {
            PredefinedExceptions predefinedExceptions = CurrentContext.PREDEFINED_EXCEPTIONS;
            bl = value.get0() == predefinedExceptions.exnJavaException || value.get0() == predefinedExceptions.exnJavaError;
        } else {
            bl = false;
        }
        stringBuilder.append(value.get0().get0().asString());
        if (value.sizeValues() >= 2L) {
            int n;
            Value value3;
            if (value.sizeValues() == 2L && value.get1().isBlock() && value.get1().getTag() == 0 && Misc.isSpecialException(value.get0())) {
                value3 = value.get1();
                n = 0;
            } else {
                value3 = value;
                n = 1;
            }
            stringBuilder.append('(');
            int n2 = (int)value3.sizeValues();
            for (int i = n; i < n2; ++i) {
                Value value4;
                if (i > n) {
                    stringBuilder.append(", ");
                }
                if ((value4 = value3.get(i)).isLong()) {
                    stringBuilder.append(value4.asLong());
                    continue;
                }
                if (value4.isBlock() && value4.getTag() == 252) {
                    stringBuilder.append('\"');
                    stringBuilder.append(value4.asString());
                    stringBuilder.append('\"');
                    continue;
                }
                if (bl && i == n) {
                    stringBuilder.append(((Throwable)value4.asCustom()).toString());
                    continue;
                }
                stringBuilder.append('_');
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static int convertFlagList(Value value, int[] nArray) {
        assert (value != null) : "null list";
        assert (nArray != null) : "null flags";
        int n = 0;
        for (Value value2 = value; value2 != Value.EMPTY_LIST; value2 = value2.get1()) {
            n |= nArray[value2.get0().asCastedInt()];
        }
        return n;
    }
}

