/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwkTableModel;
import com.onemoonscientific.swank.chart.BoxAndWhiskerData;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class BoxAndWhiskerTableData
extends BoxAndWhiskerData {
    int xColumn = -1;
    int gColumn = -1;
    int yColumn = -1;
    int[] yColumns = new int[0];
    SwkTableModel tableModel = null;
    Map seriesMap = new TreeMap();
    List seriesNames = new ArrayList();
    List seriesLists = new ArrayList();

    public BoxAndWhiskerTableData() {
        this.name = "xyData" + id;
        datasetMap.put(this.name, this);
        ++id;
    }

    public BoxAndWhiskerTableData(String name) {
        this.name = name;
        datasetMap.put(name, this);
    }

    public void setTableModel(SwkTableModel model) {
        if (EventQueue.isDispatchThread()) {
            this.setTableModelOnEventThread(model);
        } else {
            new SetModel().exec(model);
        }
    }

    public void setTableModelOnEventThread(SwkTableModel model) {
        this.tableModel = model;
        this.xColumn = -1;
        this.gColumn = -1;
        this.yColumns = new int[1];
        this.yColumns[0] = -1;
    }

    public void setXColumn(int column) {
        this.xColumn = column;
    }

    public void setGColumn(int column) {
        this.gColumn = column;
    }

    public void setYColumn(int column) {
        this.yColumns = new int[1];
        this.yColumns[0] = -1;
    }

    public void setYColumns(Interp interp, TclObject columnArgs) throws TclException {
        TclObject[] columnObjects = TclList.getElements((Interp)interp, (TclObject)columnArgs);
        this.yColumns = new int[columnObjects.length];
        for (int i = 0; i < columnObjects.length; ++i) {
            int column;
            this.yColumns[i] = column = TclInteger.get((Interp)interp, (TclObject)columnObjects[i]);
        }
    }

    public void setYColumns(int[] columns) {
        this.yColumns = columns;
    }

    public void getSeries() {
        int nRows = this.tableModel.getNRows();
        String yColumnName = "Data";
        for (int j = 0; j < this.yColumns.length; ++j) {
            int i;
            this.seriesMap.clear();
            this.seriesLists.clear();
            this.seriesNames.clear();
            int yColumn = this.yColumns[j];
            int nSeries = 0;
            if (yColumn >= 0 && yColumn < this.tableModel.getNCols()) {
                yColumnName = this.tableModel.getColumnName(yColumn);
                for (i = 0; i < nRows; ++i) {
                    Object gObject = this.tableModel.getValueAt(i, this.gColumn);
                    Number y = null;
                    Object yObject = this.tableModel.getValueAt(i, yColumn);
                    if (yObject instanceof Number) {
                        y = (Number)yObject;
                    }
                    Integer seriesIndex = (Integer)this.seriesMap.get(gObject);
                    ArrayList<Number> arrayList = null;
                    if (seriesIndex == null) {
                        this.seriesNames.add(gObject);
                        this.seriesMap.put(gObject, nSeries);
                        arrayList = new ArrayList<Number>();
                        this.seriesLists.add(arrayList);
                        ++nSeries;
                    } else {
                        int index = seriesIndex;
                        arrayList = (ArrayList<Number>)this.seriesLists.get(index);
                    }
                    if (y == null) continue;
                    arrayList.add(y);
                }
            }
            for (i = 0; i < nSeries; ++i) {
                ArrayList arrayList = (ArrayList)this.seriesLists.get(i);
                Object seriesName = this.seriesNames.get(i);
                this.add(arrayList, (Comparable)seriesName, (Comparable)((Object)yColumnName));
            }
        }
    }

    class SetModel
    extends GetValueOnEventThread {
        SwkTableModel model;

        SetModel() {
        }

        void exec(SwkTableModel model) {
            this.model = model;
            this.execOnThread();
        }

        public void run() {
            BoxAndWhiskerTableData.this.setTableModelOnEventThread(this.model);
        }
    }
}

