/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.labltk;

import java.util.ArrayList;
import java.util.List;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.labltk.Misc;
import org.ocamljava.runtime.primitives.otherlibs.labltk.TKSlot;
import org.ocamljava.runtime.values.Value;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

@PrimitiveProvider(library="labltk", module="Tk", source="otherlibs/labltk/support/cltkEval.c")
public final class CltkEval {
    private CltkEval() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value camltk_tcl_eval(Value str) throws FailException {
        TKSlot slot = TKSlot.checkInit();
        Interp interp = slot.getInterpreter();
        interp.resetResult();
        try {
            Misc.eval(interp, str.asString());
        }
        catch (TclException te) {
            slot.tkError(te);
        }
        return Value.createString((String)interp.getResult().toString());
    }

    static void fillArgs(TKSlot slot, List<TclObject> argv, Value v) throws TclException, FailException {
        switch (v.getTag()) {
            case 0: {
                String s = v.get0().asString();
                argv.add(TclString.newInstance((String)s));
                break;
            }
            case 1: {
                Value l = v.get0();
                while (l.isBlock()) {
                    CltkEval.fillArgs(slot, argv, l.get0());
                    l = l.get1();
                }
                break;
            }
            case 2: {
                ArrayList<TclObject> tmpArgv = new ArrayList<TclObject>();
                CltkEval.fillArgs(slot, tmpArgv, v.get0());
                TclObject elem = TclList.newInstance();
                for (TclObject o : tmpArgv) {
                    TclList.append((Interp)slot.getInterpreter(), (TclObject)elem, (TclObject)o);
                }
                argv.add(elem);
                break;
            }
            default: {
                slot.tkError("fillArgs: illegal tag");
            }
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Protocol.tkArgs array"}, returnType="string")
    public static Value camltk_tcl_direct_eval(Value v) throws FailException {
        TKSlot slot = TKSlot.checkInit();
        Interp interp = slot.getInterpreter();
        int size = (int)v.sizeValues();
        ArrayList<TclObject> argv = new ArrayList<TclObject>();
        try {
            for (int i = 0; i < size; ++i) {
                CltkEval.fillArgs(slot, argv, v.get(i));
            }
        }
        catch (TclException te) {
            slot.tkError("fillArgs error");
        }
        TclObject[] args = argv.toArray(new TclObject[argv.size()]);
        interp.resetResult();
        Command cmd = interp.getCommand(args[0].toString());
        if (cmd != null) {
            try {
                cmd.cmdProc(interp, args);
            }
            catch (TclException te) {
                slot.tkError(te);
            }
        } else {
            Command unkCmd = interp.getCommand("unknown");
            if (unkCmd != null) {
                int len = args.length;
                TclObject[] newArgs = new TclObject[len + 1];
                System.arraycopy(args, 0, newArgs, 1, len);
                newArgs[0] = TclString.newInstance((String)"unknown");
                try {
                    unkCmd.cmdProc(interp, newArgs);
                }
                catch (TclException te) {
                    slot.tkError(te);
                }
            } else {
                String msg = String.format("Unknown command \"%s\"", args[0]);
                interp.setResult(TclString.newInstance((String)msg));
            }
        }
        return Value.createString((String)interp.getResult().toString());
    }
}

