/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.values.AbstractBasicBlockValue;
import org.ocamljava.runtime.values.BasicBlockValue0;
import org.ocamljava.runtime.values.BasicBlockValue1;
import org.ocamljava.runtime.values.BasicBlockValue2;
import org.ocamljava.runtime.values.BasicBlockValue3;
import org.ocamljava.runtime.values.BasicBlockValue4;
import org.ocamljava.runtime.values.BasicBlockValue5;
import org.ocamljava.runtime.values.BasicBlockValue6;
import org.ocamljava.runtime.values.BasicBlockValue7;
import org.ocamljava.runtime.values.BasicBlockValue8;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class BasicBlockValue
extends AbstractBasicBlockValue {
    private Value[] values;

    BasicBlockValue(int tag, int sz) {
        super(tag, sz);
        this.values = new Value[sz];
        for (int i = 0; i < sz; ++i) {
            this.values[i] = Value.ZERO;
        }
    }

    BasicBlockValue(int tag, Value[] vals) {
        super(tag, vals.length);
        int sz = vals.length;
        this.values = vals;
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx];
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx];
    }

    @Override
    public Value get0() {
        return this.values[0];
    }

    @Override
    public Value get1() {
        return this.values[1];
    }

    @Override
    public Value get2() {
        return this.values[2];
    }

    @Override
    public Value get3() {
        return this.values[3];
    }

    @Override
    public Value get4() {
        return this.values[4];
    }

    @Override
    public Value get5() {
        return this.values[5];
    }

    @Override
    public Value get6() {
        return this.values[6];
    }

    @Override
    public Value get7() {
        return this.values[7];
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.values[(int)idx] = x;
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.values[idx] = x;
    }

    @Override
    public void set0(Value x) {
        assert (x != null) : "null x";
        this.values[0] = x;
    }

    @Override
    public void set1(Value x) {
        assert (x != null) : "null x";
        this.values[1] = x;
    }

    @Override
    public void set2(Value x) {
        assert (x != null) : "null x";
        this.values[2] = x;
    }

    @Override
    public void set3(Value x) {
        assert (x != null) : "null x";
        this.values[3] = x;
    }

    @Override
    public void set4(Value x) {
        assert (x != null) : "null x";
        this.values[4] = x;
    }

    @Override
    public void set5(Value x) {
        assert (x != null) : "null x";
        this.values[5] = x;
    }

    @Override
    public void set6(Value x) {
        assert (x != null) : "null x";
        this.values[6] = x;
    }

    @Override
    public void set7(Value x) {
        assert (x != null) : "null x";
        this.values[7] = x;
    }

    @Override
    public long sizeValues() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    protected void truncateInstance(long sz) {
        int s = (int)sz;
        this.values = Arrays.copyOf(this.values, s);
    }

    @Override
    public void copy(BlockValue src) {
        int len = (int)Math.min((long)this.values.length, src.sizeValues());
        for (int i = 0; i < len; ++i) {
            this.values[i] = src.get(i);
        }
    }

    @Override
    public BasicBlockValue duplicate() {
        int len = this.values.length;
        BasicBlockValue res = new BasicBlockValue(this.getTag(), len);
        System.arraycopy(this.values, 0, res.values, 0, len);
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        System.arraycopy(this.values, 0, dest, 0, this.values.length);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        System.arraycopy(this.values, 0, dest, destOfs, this.values.length);
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.values[i].asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.values[i].getRawValue();
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        int l = (int)len;
        int o = (int)ofs;
        int tag = this.getTag();
        switch (l) {
            case 0: {
                return new BasicBlockValue0(tag);
            }
            case 1: {
                return new BasicBlockValue1(tag, this.values[o + 0]);
            }
            case 2: {
                return new BasicBlockValue2(tag, this.values[o + 0], this.values[o + 1]);
            }
            case 3: {
                return new BasicBlockValue3(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2]);
            }
            case 4: {
                return new BasicBlockValue4(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3]);
            }
            case 5: {
                return new BasicBlockValue5(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4]);
            }
            case 6: {
                return new BasicBlockValue6(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5]);
            }
            case 7: {
                return new BasicBlockValue7(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6]);
            }
            case 8: {
                return new BasicBlockValue8(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6], this.values[o + 7]);
            }
        }
        Value[] v = new Value[l];
        System.arraycopy(this.values, o, v, 0, l);
        return new BasicBlockValue(tag, v);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (dest instanceof BasicBlockValue) {
            BasicBlockValue that = (BasicBlockValue)dest;
            System.arraycopy(this.values, (int)srcOfs, that.values, (int)destOfs, (int)len);
        } else if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += this.values[i].hashCode();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicBlockValue) {
            BasicBlockValue that = (BasicBlockValue)obj;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws FatalError {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.values[(int)idx] = x;
    }

    @Override
    public long sizeLongs() {
        return this.values.length;
    }

    @Override
    public long sizeDoubles() {
        return this.values.length;
    }

    @Override
    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = Value.createDouble(x);
    }

    @Override
    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx].asDouble();
    }

    @Override
    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx].asDouble();
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx].asDouble();
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx].asDouble();
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = Value.createDouble(x);
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = Value.createDouble(x);
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx].getRawValue();
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx].getRawValue();
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = Value.createFromRawLong(x);
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = Value.createFromRawLong(x);
    }

    @Override
    public void setGenericDouble0(double x) {
        this.values[0] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble0() {
        return this.values[0].asDouble();
    }

    @Override
    public void setDouble0(double x) {
        this.values[0] = Value.createDouble(x);
    }

    @Override
    public double getDouble0() {
        return this.values[0].asDouble();
    }

    @Override
    public void setRawLong0(long x) {
        this.values[0] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong0() {
        return this.values[0].getRawValue();
    }

    @Override
    public void setGenericDouble1(double x) {
        this.values[1] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble1() {
        return this.values[1].asDouble();
    }

    @Override
    public void setDouble1(double x) {
        this.values[1] = Value.createDouble(x);
    }

    @Override
    public double getDouble1() {
        return this.values[1].asDouble();
    }

    @Override
    public void setRawLong1(long x) {
        this.values[1] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong1() {
        return this.values[1].getRawValue();
    }

    @Override
    public void setGenericDouble2(double x) {
        this.values[2] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble2() {
        return this.values[2].asDouble();
    }

    @Override
    public void setDouble2(double x) {
        this.values[2] = Value.createDouble(x);
    }

    @Override
    public double getDouble2() {
        return this.values[2].asDouble();
    }

    @Override
    public void setRawLong2(long x) {
        this.values[2] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong2() {
        return this.values[2].getRawValue();
    }

    @Override
    public void setGenericDouble3(double x) {
        this.values[3] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble3() {
        return this.values[3].asDouble();
    }

    @Override
    public void setDouble3(double x) {
        this.values[3] = Value.createDouble(x);
    }

    @Override
    public double getDouble3() {
        return this.values[3].asDouble();
    }

    @Override
    public void setRawLong3(long x) {
        this.values[3] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong3() {
        return this.values[3].getRawValue();
    }

    @Override
    public void setGenericDouble4(double x) {
        this.values[4] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble4() {
        return this.values[4].asDouble();
    }

    @Override
    public void setDouble4(double x) {
        this.values[4] = Value.createDouble(x);
    }

    @Override
    public double getDouble4() {
        return this.values[4].asDouble();
    }

    @Override
    public void setRawLong4(long x) {
        this.values[4] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong4() {
        return this.values[4].getRawValue();
    }

    @Override
    public void setGenericDouble5(double x) {
        this.values[5] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble5() {
        return this.values[5].asDouble();
    }

    @Override
    public void setDouble5(double x) {
        this.values[5] = Value.createDouble(x);
    }

    @Override
    public double getDouble5() {
        return this.values[5].asDouble();
    }

    @Override
    public void setRawLong5(long x) {
        this.values[5] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong5() {
        return this.values[5].getRawValue();
    }

    @Override
    public void setGenericDouble6(double x) {
        this.values[6] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble6() {
        return this.values[6].asDouble();
    }

    @Override
    public void setDouble6(double x) {
        this.values[6] = Value.createDouble(x);
    }

    @Override
    public double getDouble6() {
        return this.values[6].asDouble();
    }

    @Override
    public void setRawLong6(long x) {
        this.values[6] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong6() {
        return this.values[6].getRawValue();
    }

    @Override
    public void setGenericDouble7(double x) {
        this.values[7] = Value.createDouble(x);
    }

    @Override
    public double getGenericDouble7() {
        return this.values[7].asDouble();
    }

    @Override
    public void setDouble7(double x) {
        this.values[7] = Value.createDouble(x);
    }

    @Override
    public double getDouble7() {
        return this.values[7].asDouble();
    }

    @Override
    public void setRawLong7(long x) {
        this.values[7] = Value.createFromRawLong(x);
    }

    @Override
    public long getRawLong7() {
        return this.values[7].getRawValue();
    }
}

