/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Printexc", source="byterun/backtrace.c")
public final class BackTrace {
    private BackTrace() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="unit")
    public static Value caml_record_backtrace(Value flag) {
        CurrentContext.getCodeState().setBacktraceActive(flag != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="bool")
    public static Value caml_backtrace_status(Value unit) {
        return CurrentContext.getCodeState().isBacktraceActive() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Printexc.raw_backtrace")
    public static Value caml_get_current_callstack(Value max) {
        return OCamlJavaThread.getCodeRunner().getCurrentCallStack(max.asCastedInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Printexc.raw_backtrace"}, returnType="Printexc.backtrace option")
    public static Value caml_convert_raw_backtrace(Value backtrace) {
        return backtrace;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Printexc.raw_backtrace")
    public static Value caml_get_exception_raw_backtrace(Value unit) {
        return OCamlJavaThread.getCodeRunner().getExceptionRawBacktrace();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Printexc.raw_backtrace option")
    public static Value caml_get_exception_backtrace(Value unit) {
        Value raw = BackTrace.caml_get_exception_raw_backtrace(unit);
        Value res = BackTrace.caml_convert_raw_backtrace(raw);
        return res;
    }
}

