/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Digest", source="byterun/md5.c")
public final class Md5 {
    private static final String ALGO = "MD5";
    private static final int BUFFER_SIZE = 65536;

    private Md5() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Raises [Invalid_argument] if MD5 algorithm is not available."}, parameterTypes={"string", "int", "int"}, returnType="Digest.t")
    public static Value caml_md5_string(Value str, Value ofs, Value len) throws FailException {
        try {
            MessageDigest md5 = MessageDigest.getInstance(ALGO);
            md5.update(str.getBytes(), ofs.asCastedInt(), len.asCastedInt());
            return Value.createString(md5.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            Fail.invalidArgument("Digest.substring");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Raises [Invalid_argument] if MD5 algorithm is not available."}, parameterTypes={"Pervasives.in_channel", "int"}, returnType="Digest.t")
    public static Value caml_md5_chan(Value channel, Value len) throws FailException, FalseExit {
        try {
            byte[] buffer = new byte[65536];
            Channel ch = (Channel)channel.asCustom();
            MessageDigest md5 = MessageDigest.getInstance(ALGO);
            int l = len.asCastedInt();
            if (l < 0) {
                int nb = ch.read(buffer, 0, 65536);
                while (nb != -1) {
                    md5.update(buffer, 0, nb);
                    nb = ch.read(buffer, 0, 65536);
                }
            } else {
                int nb;
                for (int rem = l; rem > 0; rem -= nb) {
                    nb = ch.read(buffer, 0, Math.min(65536, rem));
                    if (nb == -1) {
                        Fail.raiseEndOfFile();
                    }
                    md5.update(buffer, 0, nb);
                }
            }
            return Value.createString(md5.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            Fail.invalidArgument("Digest.substring");
            return Value.UNIT;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
            return Value.UNIT;
        }
    }
}

