/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

public final class EncodingUtils {
    private EncodingUtils() {
    }

    public static byte convertCharToByte(char c) {
        return (byte)(c < '\u0100' ? (int)c : 63);
    }

    public static char convertByteToChar(byte by) {
        return (char)((short)by & 0xFF);
    }

    public static byte[] convertStringToBytes(String string) {
        assert (string != null) : "null s";
        byte[] byArray = new byte[string.length()];
        EncodingUtils.convertStringToBytes(string, byArray, 0);
        return byArray;
    }

    public static void convertStringToBytes(String string, byte[] byArray, int n) {
        assert (string != null) : "null s";
        assert (byArray != null) : "null dest";
        assert (n >= 0) : "ofs should be >= 0";
        assert (byArray.length >= n + string.length()) : "invalid ofs";
        int n2 = string.length();
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            byArray[n3] = EncodingUtils.convertCharToByte(string.charAt(n4));
            ++n4;
            ++n3;
        }
    }

    public static void convertCharsToBytes(char[] cArray, byte[] byArray, int n, int n2) {
        assert (cArray != null) : "null ch";
        assert (byArray != null) : "null dest";
        assert (n >= 0) : "ofs should be >= 0";
        assert (n2 >= 0) : "len should be >= 0";
        assert (byArray.length >= n + n2) : "invalid ofs";
        assert (n2 <= cArray.length) : "invalid len";
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            byArray[n3] = EncodingUtils.convertCharToByte(cArray[n4]);
            ++n4;
            ++n3;
        }
    }

    public static String convertBytesToString(byte[] byArray) {
        assert (byArray != null) : "null b";
        return EncodingUtils.convertBytesToString(byArray, 0, byArray.length);
    }

    public static String convertBytesToString(byte[] byArray, int n, int n2) {
        assert (byArray != null) : "null b";
        assert (n >= 0) : "ofs should be >= 0";
        assert (n2 >= 0) : "len should be >= 0";
        assert (n + n2 <= byArray.length) : "invalid ofs";
        char[] cArray = new char[n2];
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            cArray[n4] = EncodingUtils.convertByteToChar(byArray[n3]);
            ++n4;
            ++n3;
        }
        return new String(cArray);
    }
}

