/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicBool", source="")
public final class AtomicBool {
    private AtomicBool() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"bool"}, returnType="AtomicBool.t")
    public static Value ocamljava_atomicbool_make(Value value) {
        return Value.createInstance(new AtomicBoolean(value != Value.FALSE));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool", "bool"}, returnType="bool")
    public static Value ocamljava_atomicbool_compare_and_set(Value value, Value value2, Value value3) {
        AtomicBoolean atomicBoolean = (AtomicBoolean)value.asCustom();
        boolean bl = atomicBoolean.compareAndSet(value2 != Value.FALSE, value3 != Value.FALSE);
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t"}, returnType="bool")
    public static Value ocamljava_atomicbool_get(Value value) {
        AtomicBoolean atomicBoolean = (AtomicBoolean)value.asCustom();
        boolean bl = atomicBoolean.get();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool"}, returnType="bool")
    public static Value ocamljava_atomicbool_get_and_set(Value value, Value value2) {
        AtomicBoolean atomicBoolean = (AtomicBoolean)value.asCustom();
        boolean bl = atomicBoolean.getAndSet(value2 != Value.FALSE);
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool"}, returnType="unit")
    public static Value ocamljava_atomicbool_lazy_set(Value value, Value value2) {
        AtomicBoolean atomicBoolean = (AtomicBoolean)value.asCustom();
        atomicBoolean.lazySet(value2 != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool"}, returnType="unit")
    public static Value ocamljava_atomicbool_set(Value value, Value value2) {
        AtomicBoolean atomicBoolean = (AtomicBoolean)value.asCustom();
        atomicBoolean.set(value2 != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicBool.t", "bool", "bool"}, returnType="bool")
    public static Value ocamljava_atomicbool_weak_compare_and_set(Value value, Value value2, Value value3) {
        AtomicBoolean atomicBoolean = (AtomicBoolean)value.asCustom();
        boolean bl = atomicBoolean.weakCompareAndSet(value2 != Value.FALSE, value3 != Value.FALSE);
        return bl ? Value.TRUE : Value.FALSE;
    }
}

