/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.labltk;

import com.onemoonscientific.swank.Widgets;
import java.awt.Window;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.labltk.CamlWindowAdapter;
import org.ocamljava.runtime.primitives.otherlibs.labltk.TKSlot;
import org.ocamljava.runtime.values.Value;
import tcl.lang.Interp;
import tcl.lang.TclException;

@PrimitiveProvider(library="labltk", module="Tk", source="otherlibs/labltk/support/cltkWait.c")
public final class CltkWait {
    private CltkWait() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="unit")
    public static Value camltk_wait_vis(Value win, Value cbid) throws FailException {
        CltkWait.addWindowListener(true, win.asString(), cbid.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="unit")
    public static Value camltk_wait_des(Value win, Value cbid) throws FailException {
        CltkWait.addWindowListener(false, win.asString(), cbid.asLong());
        return Value.UNIT;
    }

    private static void addWindowListener(boolean vis, String name, long id) throws FailException {
        TKSlot slot = TKSlot.checkInit();
        try {
            Object obj = Widgets.get((Interp)slot.getInterpreter(), (String)name);
            if (obj instanceof Window) {
                Window win = (Window)obj;
                win.addWindowListener(new CamlWindowAdapter(slot, vis, id));
            }
        }
        catch (TclException te) {
            slot.tkError(te);
        }
    }
}

